/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Dec 12 01:35:17 2007 by Jeff Dalton
 * Copyright: (c) 2003, 2007, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.io.Serializable;
import java.util.Date;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Wrapper for messages sent via an {@link IServeCommunicationStrategy}.
 */
public class MessageWrapper implements Serializable {

    String from;
    String command;
    LList args;

    Date sendDate;		// typically only when command is send-to
    Integer sequenceNumber;	// Integer, rather than int, so it can be null

    String remoteHost;
    String remoteAddr;

    public MessageWrapper() {	// needed for XML translator etc
    }

    public MessageWrapper(String from, String command) {
	this(from, command, Lisp.list());
    }

    public MessageWrapper(String from, String command, Object arg1) {
	this(from, command, Lisp.list(arg1));
    }

    public MessageWrapper(String from, String command, 
			  Object arg1, Object arg2) {
	this(from, command, Lisp.list(arg1, arg2));
    }

    public MessageWrapper(String from, String command, LList args) {
	this.from = from;
	this.command = command;
	this.args = args;
    }

    public String getFrom() {
	return from;
    }
    public void setFrom(String from) {
	this.from = from;
    }

    public String getCommand() {
	return command;
    }
    public void setCommand(String command) {
	this.command = command;
    }

    public LList getArgs() {
	return args;
    }
    public Object getArg(int i) {
	return args.get(i);
    }
    public void setArgs(LList args) {
	this.args = args;
    }

    public Date getSendDate() {
	return sendDate;
    }
    public void setSendDate(Date sendDate) {
	this.sendDate = sendDate;
    }

    public Integer getSequenceNumber() {
	return sequenceNumber;
    }
    public void setSequenceNumber(Integer s) {
	this.sequenceNumber = s;
    }
    public int getSeqNo() {
	return sequenceNumber.intValue();
    }
    public void setSeqNo(int i) {
	this.sequenceNumber = new Integer(i);
    }

    public String getRemoteHost() {
	return remoteHost;
    }
    public void setRemoteHost(String remoteHost) {
	this.remoteHost = remoteHost;
    }

    public String getRemoteAddr() {
	return remoteAddr;
    }
    public void setRemoteAddr(String remoteAddr) {
	this.remoteAddr = remoteAddr;
    }

    public LList toList() {	// for debugging
	return Lisp.list(from, command, args, remoteHost, remoteAddr);
    }

}
