/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Dec 12 01:45:39 2007 by Jeff Dalton
 * Copyright: (c) 2003, 2007, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.util.*;

import ix.util.*;

public class MessageMemory {

    protected SortedMap seqNoToMessageMap = new TreeMap();

    public MessageMemory() { }

    public int size() {
	return seqNoToMessageMap.size();
    }

    public void remember(MessageWrapper m) {
	Integer i = m.getSequenceNumber();
	Debug.expect(!seqNoToMessageMap.containsKey(i));
	seqNoToMessageMap.put(i, m);
    }

    public void forget(MessageWrapper m) {
	forgetKey(m.getSequenceNumber());
    }

    public void forgetKey(Integer key) {
	Debug.expect(seqNoToMessageMap.containsKey(key));
	seqNoToMessageMap.remove(key);
    }

    public boolean containsKey(Object key) {
	return seqNoToMessageMap.containsKey(key);
    }

    public Object firstKey() {
	return seqNoToMessageMap.firstKey();
    }

    public Object lastKey() {
	return seqNoToMessageMap.lastKey();
    }

    public MessageWrapper getFirstRemainingMessage() {
	return seqNoToMessageMap.isEmpty()
	    ? null
	    : (MessageWrapper)seqNoToMessageMap
	          .get(seqNoToMessageMap.firstKey());
    }

    public void walkContents(Proc p) {
	for (Iterator i = seqNoToMessageMap.entrySet().iterator();
	     i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    p.call(e.getKey(), e.getValue());
	}
    }

}
