/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Dec 12 03:25:20 2007 by Jeff Dalton
 * Copyright: (c) 2003, 2007, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.util.*;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.*;

import ix.icore.IXAgent;
import ix.ip2.*;		// /\/
import ix.iface.util.*;
import ix.util.*;

/**
 * The user interface to an {@link IServeCommunicationStrategy}.
 */
public class IServeCommunicationTool {

    IServeCommunicationStrategy strategy;

    ToolFrame frame;

    public IServeCommunicationTool(IServeCommunicationStrategy strategy) {
	this.strategy = strategy;
	strategy.setTool(this);
	frame = new ToolFrame(strategy.agent.getAgentDisplayName() +
			      " I-Serve Communications");
	transcript("Communications base URL: " + strategy.getMessageUrl());
    }

    public void setVisible(boolean v) {
	frame.setVisible(v);
    }

    void register() {
	frame.registerButton.setEnabled(false);
	while(!strategy.isAbleToSend()) {
	    String already = IXAgent.getAgent().getAgentSymbolName();
	    String name =
		showInputDialog(frame, "Enter the agent name", already);
	    if (name == null) {
		frame.registerButton.setEnabled(true);
		return;		// user cancelled
	    }
	    try {
		strategy.registerAs(name);
	    }
	    catch (Exception e) {
		Debug.displayException(e);
	    }
	}
	Debug.expect(strategy.isAbleToSend());
    }

    String showInputDialog(Component parent, Object message,
			   Object initialSelectionValue) {
	// The Java 1.4 JOptionPane provides a method like this,
	// but 1.3 doesn't.
	return (String)JOptionPane.
	    showInputDialog(parent, message, 
			    "Question",		// title
			    JOptionPane.QUESTION_MESSAGE,
			    null, 		// icon
			    null, 		// selection values
			    initialSelectionValue);
    }

    void needToReregister() {
	Util.displayAndWait(frame, new String[] {
	    "This agent is unable to connect to the server needed",
	    "for applet communications, probably because the server",
	    "has exited.  You will need to re-register when a server",
	    "is again available.  Some messages may have been lost."
	});
	frame.registerButton.setEnabled(true);
    }

    void transcript(String line) {
	frame.appendLine(line);
    }

    /**
     * A simple GUI.
     */
    protected class ToolFrame extends TextAreaFrame {
	JButton registerButton;
	ToolFrame(String title) {
	    super(0, 0, title, new String[]{});
	    setEditable(false);
	    addListener(new ToolTListener());
	}
	protected void finishFrame() {
	    // Doesn't make visible, unlike super method.
	    frame.pack();
	    frame.setSize(400, 200);
	    frame.validate();
	}
	protected TFrame makeTFrame(String title, String[] buttons) {
	    return new ToolTFrame(title, buttons);
	}
	class ToolTFrame extends TFrame {
	    ToolTFrame(String title, String[] buttons) {
		super(title, buttons);
		contentPane.add(makeButtonPanel(), BorderLayout.SOUTH);
	    }
	    protected JPanel makeButtonPanel() {
		JPanel panel = new JPanel();
		panel.add(registerButton = makeButton("Register"));
		return panel;
	    }
	}
	class ToolTListener implements TListener {
	    ToolTListener() {}
	    public void buttonPressed(String command) {
		if (command.equals("Register"))
		    IServeCommunicationTool.this.register();
		else
		    // Ignore commands that might be handled elsewhere
		    Debug.noteln("ToolTListener ignores", command);
	    }
	}
    }

    /**
     * A {@link ToolController} for an {@link AppletCommunicationTool}.
     */
    public static class Controller extends ToolController {
	IServeCommunicationStrategy strategy;
	public Controller(IServeCommunicationStrategy strategy) {
	    super("I-Serve Communications");
	    this.strategy = strategy;
	}
	protected Object createTool() {
	    return new IServeCommunicationTool(strategy);
	}
    }

}
