/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Dec  3 17:20:15 2007 by Jeff Dalton
 * Copyright: (c) 2006, 2007, AIAI, University of Edinburgh
 */

package ix.iserve;

import java.util.*;

import ix.ip2.*;

import ix.util.*;
import ix.util.http.*;

/**
 * A process panel that acts as an HTTP server.
 */
public class IServe extends Ip2 {

    HttpServer server;

    Thread serverThread;

    public IServe() {
	super(true);		// true = stand-alone
        agentTypeName = "I-X Server";
	logoLine1 = "I-Serve";
	displayName = "I-Serve";
	showOptions = false;
    }

    public static void main(String[] argv) {
	Util.printGreeting("I-Serve");
	Debug.noteThreads = true;
	System.setProperty("java.net.preferIPv4Stack", "true");
	new IServe().mainStartup(argv);
    }

    public HttpServer getHttpServer() {
	return server;
    }

    /*
    public void startup() {
	Debug.noteln("Security manager =", System.getSecurityManager());
	System.setSecurityManager(new IServeSecurityManager());
	super.startup();
    }
    */

    public void startup() {

	String docRoot = Parameters.getParameter("http-root-directory");
	int port = Parameters.getInt("http-server-port", 0);
	server = new HttpServer(port);
	if (docRoot != null)
	    server.setDocRoot(docRoot, "/files");
	server.setLogPath("logs", getAgentSymbolName());
	server.start();
// 	serverThread = new Thread("HTTP Server") {
// 	    public void run() {
// 		Debug.noteln(Thread.currentThread() + " is running.");
// 		server.setupServer();
// // 		server.addServlet(new IXHttpServer.HelloServlet("ok!"),
// // 				  "/ok/*");
// 		server.start();
// 	    }
// 	};
// 	serverThread.start();

	super.startup();

    }

    public void addAboutInfo(List about) {
	about.add("");
	about.add("I-Serve is running an HTTP server on port " +
		  server.getServerPort());
	about.add("Its document root is " +
		  server.getDocRoot());
    }

    protected void addHandlers() {
	super.addHandlers();
	controller
	    .addActivityHandler(new AddServletHandler(this));
    }

}
