/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Nov 30 18:46:34 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.iserve;

import java.util.*;

import javax.servlet.http.HttpServlet;

import ix.icore.*;
import ix.ip2.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.http.*;

public class AddServletHandler extends ActivityHandler {

    private Symbol ADD_SERVLET = Symbol.intern("add-servlet");

    private IServe iserve;

    public AddServletHandler(IServe iserve) {
	super("Add a servlet");
	this.iserve = iserve;
    }

    @Override
    public  List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((add-servlet ?class-name (?parameter ...) ?pathSpec))");
    }

    @Override
    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.length() == 4
	    && pattern.get(0) == ADD_SERVLET;
    }

    @Override
    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }

    @Override
    public void handle(AgendaItem item) {
	LList pattern = (LList)Variable.removeVars(item.getPattern());
	Symbol className = Util.mustBe(Symbol.class, pattern.get(1));
	List parameters = Util.mustBe(List.class, pattern.get(2));
	String pathSpec = Util.mustBe(String.class, pattern.get(3));

	try {
	    Class c = Class.forName(className.toString());
	    Object obj = Util.makeInstance(c, parameters.toArray());
	    HttpServlet servlet = Util.mustBe(HttpServlet.class, obj);
	    iserve.getHttpServer().addServlet(servlet, pathSpec);
	}
	catch (Exception e) {
	    throw new RethrownException(e);
	}
	item.setStatus(Status.COMPLETE);	
    }

}
