/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Feb 25 16:32:59 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package test;

import javax.swing.*;

import ix.itest.*;
import ix.icore.*;
import ix.util.*;

public class ItestExample extends Itest {

    public ItestExample() {
	super("I-Test Example");
    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {

        Util.printGreeting("I-Test Test Example");

        new ItestExample().mainStartup(argv);

    }

    /**
     * Command-line argument processing used by all versions of I-TEST.
     *
     * @see ix.icore.IXAgent#processCommandLineArguments()
     */
    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
    }

    /**
     * Constructs a panel containing a nice, UN-related picture.
     */
    public JPanel makeLogoPanel() {
        JPanel imagePanel = new JPanel();
        ImageIcon icon = new ImageIcon("images/un-sec-gen-office.jpg");
        imagePanel.add(new JLabel(icon));
        return imagePanel;
    }

    /**
     * Tests
     */
    protected void addTests() {

        /* Any inherited tests */

        super.addTests();

        /* I-LEED tests */

        addIssueTest("ILEED", Priority.HIGH,
                     "consider elephants laki_safari_park");
        addIssueTest("ILEED", Priority.HIGH, "consider lions sw_region");
        addIssueTest("ILEED", Priority.HIGH, "consider lions nw_region");

        /* I-DEEL tests */

        addIssueTest("IDEEL", "avoid elephants laki_safari_park");

        addReportSequenceTest
            ("Send to IDEEL MCA reports for no conflicts",
             "IDEEL",
             "MCA-IDEEL-1",
             new String[] { "done - no conflicts" });

        addReportSequenceTest
            ("Send to IDEEL MCA reports for no solutions",
             "IDEEL",
             "MCA-IDEEL-1",
             new String[] { "done - no solutions" });

        addReportSequenceTest
            ("Send to IDEEL MCA reports for 3 solutions",
             "IDEEL",
             "MCA-IDEEL-1",
             new String[] {
                "solutions found 1",
                "solutions found 2",
                "solutions found 3",
                "done - solutions found 3"
             });

        addReportSequenceTest
            ("Send to IDEEL MCA reports for 10 solutions",
             "IDEEL",
             "MCA-IDEEL-1",
             new String[] {
                "solutions found 1",
                "solutions found 2",
                "solutions found 3",
                "solutions found 4",
                "solutions found 5",
                "solutions found 6",
                "solutions found 7",
                "solutions found 8",
                "solutions found 9",
                "solutions found 10",
                "done - solutions found 10"
             });

    }

}


