/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Hashtable;
import java.util.Iterator;

public class Timers {
    public static long NOT_STARTED = -1L;
    Hashtable timers = new Hashtable();

    public Timer createTimer(String name) {
        Timer t = new Timer(name);
        this.timers.put(name, t);
        return t;
    }

    public void startTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.start();
    }

    public void resetTimer(String name) {
        this.createTimer(name);
        this.startTimer(name);
    }

    public void stopTimer(String name) {
        Timer t = this.getTimer(name);
        if (t != null) {
            t.stop();
        }
    }

    public Timer getTimer(String name) {
        return (Timer)this.timers.get(name);
    }

    public String toString() {
        String str = "";
        Iterator i = this.timers.values().iterator();
        while (i.hasNext()) {
            Timer t = (Timer)i.next();
            str = String.valueOf(str) + t + "\n";
        }
        return str;
    }

    static class Timer {
        String name;
        long totalTime;
        long startTime;
        long count;
        long startCount;

        Timer(String name) {
            this.name = name;
            this.totalTime = 0L;
            this.startTime = NOT_STARTED;
            this.startCount = 0L;
            this.count = 0L;
        }

        void start() {
            if (this.startTime != NOT_STARTED) {
                ++this.startCount;
                return;
            }
            this.startTime = System.currentTimeMillis();
        }

        void stop() {
            if (this.startTime == NOT_STARTED) {
                return;
            }
            if (this.startCount > 0L) {
                --this.startCount;
                return;
            }
            this.totalTime += System.currentTimeMillis() - this.startTime;
            this.startTime = NOT_STARTED;
            ++this.count;
        }

        public String toString() {
            double avg = (double)this.totalTime / (double)this.count;
            return "Timer " + this.name + " Avg: " + avg + " Count: " + this.count + " Total: " + this.totalTime;
        }
    }
}

