/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermList;
import java.util.HashSet;
import org.mindswap.pellet.ATermUtils;

public class Role {
    private final String[] TYPES = new String[]{"Undefined", "Object", "Datatype", "Annotation", "Ontology"};
    public static final int UNDEFINED = 0;
    public static final int OBJECT = 1;
    public static final int DATATYPE = 2;
    public static final int ANNOTATION = 3;
    public static final int ONTOLOGY = 4;
    ATerm name;
    int type = 0;
    ATerm inverse = null;
    HashSet subRoles = new HashSet();
    HashSet superRoles = new HashSet();
    ATermList domain = ATermUtils.makeList();
    ATermList range = ATermUtils.makeList();
    boolean isTransitive = false;
    boolean isFunctional = false;
    boolean isInverseFunctional = false;
    boolean isSymmetric = false;

    public Role(ATerm name) {
        this(name, 0);
    }

    public Role(ATerm name, int type) {
        this.name = name;
        this.type = type;
        this.addSubRole(name);
        this.addSuperRole(name);
    }

    public String toString() {
        String str = "(" + this.TYPES[this.type] + "Role " + this.name;
        if (this.isTransitive) {
            str = String.valueOf(str) + " Transitive";
        }
        if (this.isSymmetric) {
            str = String.valueOf(str) + " Symmetric";
        }
        if (this.isFunctional) {
            str = String.valueOf(str) + " Functional";
        }
        if (this.isInverseFunctional) {
            str = String.valueOf(str) + " InverseFunctional";
        }
        if (this.type == 1 || this.type == 2) {
            if (!this.domain.isEmpty()) {
                str = String.valueOf(str) + " domain=" + this.domain;
            }
            if (!this.range.isEmpty()) {
                str = String.valueOf(str) + " range=" + this.range;
            }
            str = String.valueOf(str) + " subPropertyOf=" + this.subRoles;
            str = String.valueOf(str) + " superPropertyOf=" + this.superRoles;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public void addSubRole(ATerm r) {
        this.subRoles.add(r);
    }

    public void addSuperRole(ATerm r) {
        this.superRoles.add(r);
    }

    public void addDomain(ATerm a) {
        this.domain = ATermUtils.insert(a, this.domain);
    }

    public void addRange(ATerm a) {
        this.range = ATermUtils.insert(a, this.range);
    }

    public ATermList getDomain() {
        return this.domain;
    }

    public ATerm getInverse() {
        return this.inverse;
    }

    public boolean isFunctional() {
        return this.isFunctional;
    }

    public boolean isInverseFunctional() {
        return this.isInverseFunctional;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public ATerm getName() {
        return this.name;
    }

    public ATermList getRange() {
        return this.range;
    }

    public HashSet getSubRoles() {
        return this.subRoles;
    }

    public HashSet getSuperRoles() {
        return this.superRoles;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.TYPES[this.type];
    }

    public void setInverse(ATerm term) {
        this.inverse = term;
    }

    public void setFunctional(boolean b) {
        this.isFunctional = b;
    }

    public void setInverseFunctional(boolean b) {
        this.isInverseFunctional = b;
    }

    public void setSymmetric(boolean b) {
        this.isSymmetric = b;
    }

    public void setTransitive(boolean b) {
        this.isTransitive = b;
    }
}

