/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.PrintStream;
import java.io.PrintWriter;

public class OutputFormatter {
    PrintWriter out = null;
    boolean formatHTML;

    public OutputFormatter() {
        this(false);
    }

    public OutputFormatter(boolean formatHTML) {
        this(System.out, formatHTML);
    }

    public OutputFormatter(PrintStream out, boolean formatHTML) {
        this(new PrintWriter(out), formatHTML);
    }

    public OutputFormatter(PrintWriter out, boolean formatHTML) {
        this.out = out;
        this.formatHTML = formatHTML;
    }

    public boolean isFormatHTML() {
        return this.formatHTML;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void flush() {
        this.out.flush();
    }

    public OutputFormatter print(String s) {
        this.out.print(s);
        return this;
    }

    public OutputFormatter print(Object o) {
        this.out.print(o);
        return this;
    }

    public OutputFormatter print(boolean b) {
        this.out.print(b);
        return this;
    }

    public OutputFormatter println(Object o) {
        this.print(o);
        this.println();
        return this;
    }

    public OutputFormatter println(String s) {
        this.out.print(s);
        this.println();
        return this;
    }

    public OutputFormatter println() {
        this.printTag("<br>");
        this.out.println();
        return this;
    }

    public OutputFormatter printParagraph() {
        if (this.formatHTML) {
            this.out.println("<p>");
        } else {
            this.out.println();
        }
        return this;
    }

    public OutputFormatter printLink(String uri) {
        if (this.formatHTML) {
            this.printLink(uri, uri);
        } else {
            this.out.print(uri);
        }
        return this;
    }

    public OutputFormatter printLink(String uri, String label) {
        if (this.formatHTML) {
            this.out.print("<a href=\"");
            this.out.print(uri);
            this.out.print("\">");
            this.out.print(label);
            this.out.print("</a>");
        } else {
            this.out.print(String.valueOf(label) + " (" + uri + ")");
        }
        return this;
    }

    public OutputFormatter printBold(String s) {
        return this.printInsideTag(s, "b");
    }

    public OutputFormatter printItalic(String s) {
        return this.printInsideTag(s, "i");
    }

    public OutputFormatter printInsideTag(String s, String tag) {
        if (this.formatHTML) {
            this.out.print("<");
            this.out.print(tag);
            this.out.print(">");
            this.out.print(s);
            this.out.print("</");
            this.out.print(tag);
            this.out.print(">");
        } else {
            this.out.print(s);
        }
        return this;
    }

    public OutputFormatter printTag(String tag) {
        if (this.formatHTML) {
            this.out.print(tag);
        }
        return this;
    }

    public OutputFormatter startTable() {
        return this.startTable(0);
    }

    public OutputFormatter startTable(int borderWidth) {
        this.printTag("<table border=" + borderWidth + ">");
        return this;
    }

    public OutputFormatter startRow() {
        this.printTag("<tr>");
        return this;
    }

    public OutputFormatter startCol() {
        this.printTag("<td>");
        return this;
    }

    public OutputFormatter endTable() {
        this.printTag("</table>");
        return this;
    }

    public OutputFormatter endRow() {
        this.printTag("</tr>");
        return this;
    }

    public OutputFormatter endCol() {
        this.printTag("</td>");
        return this;
    }
}

