/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ABoxQuery;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Classify;
import org.mindswap.pellet.Datatype;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLRule;
import org.mindswap.pellet.OWLRuleVocabulary;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.UnsupportedFeatureException;

public class OWLReasoner {
    public static boolean DEBUG = false;
    private ABox originalABox = null;
    private ABox completeABox = null;
    private Model model = null;
    private Classify classification = null;
    private HashSet loadedFiles = new HashSet();

    public OWLReasoner() {
        this.loadedFiles.add("http://www.w3.org/2002/07/owl#");
        this.loadedFiles.add(RDF.getURI());
        this.loadedFiles.add(RDFS.getURI());
        this.originalABox = new ABox();
    }

    public void ignoreImport(String uri) {
        if (!uri.endsWith("#")) {
            uri = String.valueOf(uri) + "#";
        }
        this.loadedFiles.add(uri);
    }

    public Object clone() {
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.classification = this.classification;
        reasoner.originalABox = this.originalABox.cloneABox();
        reasoner.completeABox = this.completeABox;
        reasoner.model = this.model;
        return reasoner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ATerm node2term(RDFNode node) {
        ATermAppl aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (r.getModel() == null) {
                return ATermUtils.makeTermAppl(OWLParser.getFriendlyName(r.getURI()));
            }
            if (r.hasProperty(RDF.first)) {
                return this.createList(r);
            }
            if (r.hasProperty(OWL.onProperty)) {
                return this.createRestriction(r);
            }
            if (r.isAnon()) {
                if (r.hasProperty(OWL.intersectionOf)) {
                    ATermList list = this.createList(r.getProperty(OWL.intersectionOf).getResource());
                    return ATermUtils.makeAnd(list);
                }
                if (r.hasProperty(OWL.unionOf)) {
                    ATermList list = this.createList(r.getProperty(OWL.unionOf).getResource());
                    return ATermUtils.makeOr(list);
                }
                if (r.hasProperty(OWL.oneOf)) {
                    ATermList list = this.createList(r.getProperty(OWL.oneOf).getResource());
                    ATermList result = ATermUtils.makeList();
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATerm c = l.getFirst();
                        result = result.insert((ATerm)ATermUtils.makeValue(c));
                        l = l.getNext();
                    }
                    return ATermUtils.makeOr(result);
                }
                if (!r.hasProperty(OWL.complementOf)) return null;
                ATerm complement = this.node2term((RDFNode)r.getProperty(OWL.complementOf).getResource());
                return ATermUtils.makeNot(complement);
            }
            if (!r.getNameSpace().startsWith("http://www.w3.org/2001/XMLSchema")) return ATermUtils.makeTermAppl(OWLParser.getFriendlyName(r.getURI()));
            return ATermUtils.makeDatatype(r.getURI());
        }
        Literal l = (Literal)node;
        String dt = l.getDatatypeURI();
        if (dt != null) return ATermUtils.makeLiteral(l.getString(), l.getLanguage(), dt);
        dt = "";
        return ATermUtils.makeLiteral(l.getString(), l.getLanguage(), dt);
    }

    private ATermList createList(Resource r) {
        if (r.equals((Object)RDF.nil)) {
            return ATermUtils.makeList();
        }
        ATerm first = this.node2term(r.getProperty(RDF.first).getObject());
        Resource rest = (Resource)r.getProperty(RDF.rest).getObject();
        return ATermUtils.makeList(first, this.createList(rest));
    }

    private ATerm createMinCardinality(ATerm p, int cardinality) throws UnsupportedFeatureException {
        switch (cardinality) {
            case 0: {
                return ATermUtils.TOP;
            }
            case 1: {
                return ATermUtils.makeSomeValues(p, ATermUtils.TOP);
            }
        }
        if (cardinality < 0) {
            throw new UnsupportedFeatureException("owl:minCardinality with a negative value is invalid");
        }
        if (cardinality > OWLParser.MAX_CARD_VALUE) {
            throw new UnsupportedFeatureException("cardinality restriction greater than " + OWLParser.MAX_CARD_VALUE + " is not supported");
        }
        return ATermUtils.makeMin(p, cardinality);
    }

    private ATerm createMaxCardinality(ATerm p, int cardinality) throws UnsupportedFeatureException {
        switch (cardinality) {
            case 0: {
                return ATermUtils.makeAllValues(p, ATermUtils.BOTTOM);
            }
        }
        if (cardinality < 0) {
            throw new UnsupportedFeatureException("owl:maxCardinality with a negative value is invalid");
        }
        if (cardinality > OWLParser.MAX_CARD_VALUE) {
            throw new UnsupportedFeatureException("cardinality restriction greater than " + OWLParser.MAX_CARD_VALUE + " is not supported");
        }
        return ATermUtils.makeMax(p, cardinality);
    }

    private ATerm createRestriction(Resource s) throws UnsupportedFeatureException {
        Resource p = (Resource)s.getProperty(OWL.onProperty).getObject();
        ATerm aTerm = null;
        ATerm pt = this.node2term((RDFNode)p);
        if (!s.isAnon()) {
            throw new UnsupportedFeatureException("Restrictions should be anonymous in OWL DL!");
        }
        if (s.hasProperty(OWL.hasValue)) {
            throw new UnsupportedFeatureException("owl:hasValue construct is not supported");
        }
        if (s.hasProperty(OWL.allValuesFrom)) {
            Resource o = (Resource)s.getProperty(OWL.allValuesFrom).getObject();
            ATerm ot = this.node2term((RDFNode)o);
            if (o.equals((Object)OWL.Thing)) {
                ot = ATermUtils.TOP;
            } else if (o.equals((Object)OWL.Nothing)) {
                ot = ATermUtils.BOTTOM;
            }
            aTerm = ATermUtils.makeAllValues(pt, ot);
        } else if (s.hasProperty(OWL.someValuesFrom)) {
            Resource o = (Resource)s.getProperty(OWL.someValuesFrom).getObject();
            ATerm ot = this.node2term((RDFNode)o);
            if (o.equals((Object)OWL.Thing)) {
                ot = ATermUtils.TOP;
            } else if (o.equals((Object)OWL.Nothing)) {
                ot = ATermUtils.BOTTOM;
            }
            aTerm = ATermUtils.makeSomeValues(pt, ot);
        } else if (s.hasProperty(OWL.minCardinality)) {
            int cardinality = s.getProperty(OWL.minCardinality).getInt();
            aTerm = this.createMinCardinality(pt, cardinality);
        } else if (s.hasProperty(OWL.maxCardinality)) {
            int cardinality = s.getProperty(OWL.maxCardinality).getInt();
            aTerm = this.createMaxCardinality(pt, cardinality);
        } else if (s.hasProperty(OWL.cardinality)) {
            int cardinality = s.getProperty(OWL.cardinality).getInt();
            aTerm = ATermUtils.makeAnd(this.createMinCardinality(pt, cardinality), this.createMaxCardinality(pt, cardinality));
        }
        return aTerm;
    }

    public void loadRules(String url) throws Exception {
        Model model = ModelFactory.createDefaultModel();
        model.read(url);
        Resource rule = model.listStatements(null, RDF.type, (RDFNode)OWLRuleVocabulary.Rule).nextStatement().getSubject();
        OWLRule owlRule = new OWLRule(rule);
        this.originalABox.rules.add(owlRule);
    }

    public void loadOntology(String url) throws Exception {
        this.loadOntology(url, "RDF/XML");
    }

    public void loadOntology(String url, String lang) throws Exception {
        this.loadOntology(new URL(url).openConnection().getInputStream(), url, lang);
    }

    public void loadOntology(InputStream in) throws Exception {
        this.loadOntology(in, "RDF/XML");
    }

    public void loadOntology(InputStream in, String lang) throws Exception {
        this.loadOntology(in, OWLParser.BASE_URI, lang);
    }

    public void loadOntology(InputStream in, String url, String lang) throws Exception {
        this.model = ModelFactory.createDefaultModel();
        Pellet.timers.resetTimer("Loading");
        System.out.println("load " + url);
        this.model.read(in, url, lang);
        this.load(null);
        Pellet.timers.stopTimer("Loading");
        System.out.println("process " + url);
        this.loadOntology(this.model);
    }

    public void loadOntology(Model model) throws Exception {
        if (model.isEmpty()) {
            return;
        }
        this.classification = null;
        OWLParser.parse(model, this.originalABox);
    }

    public boolean isLoaded(String f) {
        if (f == null) {
            return false;
        }
        if (!f.endsWith("#")) {
            f = String.valueOf(f) + "#";
        }
        return this.loadedFiles.contains(f);
    }

    private void load(String f) {
        if (f != null && !f.endsWith("#")) {
            f = String.valueOf(f) + "#";
        }
        if (this.loadedFiles.contains(f)) {
            return;
        }
        if (f != null) {
            try {
                System.out.println("load model " + f);
                this.loadedFiles.add(f);
                this.model.read(f, "");
            }
            catch (Exception e) {
                System.err.println("Warning: The import file " + f + " cannot be loaded");
                System.err.println(e);
            }
        }
        Vector<String> imports = new Vector<String>();
        StmtIterator i = this.model.listStatements(null, OWL.imports, null);
        while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            String s = stmt.getResource().toString();
            imports.add(s);
        }
        int j = 0;
        while (j < imports.size()) {
            this.load(imports.get(j).toString());
            ++j;
        }
    }

    public ABox getABox() {
        return this.originalABox;
    }

    public void setABox(ABox abox) {
        this.originalABox = abox;
    }

    public String getLevel() {
        return this.originalABox.level;
    }

    public void checkConsistency() {
        Pellet.timers.resetTimer("Consistency");
        this.completeABox = this.originalABox.completeABox();
        Pellet.timers.stopTimer("Consistency");
    }

    public boolean isConsistent() {
        if (this.completeABox == null) {
            this.checkConsistency();
        }
        return this.completeABox.clashFree();
    }

    public void classify() {
        if (!this.isConsistent()) {
            throw new UnsupportedFeatureException("Cannot classify inconsistent ontologies");
        }
        Pellet.timers.startTimer("Classification");
        if (this.classification == null) {
            this.classification = new Classify(this);
            System.out.println("Classifying...");
        }
        Pellet.timers.stopTimer("Classification");
    }

    public void realize() {
        this.classify();
        Pellet.timers.startTimer("Realization");
        this.classification.realize();
        Pellet.timers.stopTimer("Realization");
    }

    public Classify getClassification() {
        return this.classification;
    }

    public boolean isClass(Resource c) {
        return c.equals((Object)OWL.Thing) || c.equals((Object)OWL.Nothing) || this.originalABox.tbox.classes.contains(this.node2term((RDFNode)c));
    }

    public boolean isSatisfiable(ATerm c) {
        long time = System.currentTimeMillis();
        Pellet.timers.startTimer("isSatisfiable");
        boolean isSat = this.originalABox.isSatisfiable(c);
        Pellet.timers.stopTimer("isSatisfiable");
        return isSat;
    }

    public boolean isSubclassOf(Resource r1, Resource r2) {
        ATerm c2;
        ATerm c1 = this.node2term((RDFNode)r1);
        if (c1.equals((Object)(c2 = this.node2term((RDFNode)r2)))) {
            return true;
        }
        if (this.classification != null && ATermUtils.isPrimitive(c1) && ATermUtils.isPrimitive(c2)) {
            return this.classification.isSubclassOf(c1, c2);
        }
        return this.originalABox.isSubclassOf(c1, c2);
    }

    public boolean isEquivalentClass(Resource c1, Resource c2) {
        return this.isSubclassOf(c1, c2) && this.isSubclassOf(c2, c1);
    }

    public boolean isDisjoint(Resource c1, Resource c2) {
        return !this.originalABox.isSatisfiable(ATermUtils.makeAnd(this.node2term((RDFNode)c1), this.node2term((RDFNode)c2)));
    }

    public boolean isComplement(Resource c1, Resource c2) {
        ATermAppl a2;
        ATerm a1 = this.node2term((RDFNode)c1);
        return this.originalABox.isSubclassOf(a1, (ATerm)(a2 = ATermUtils.makeNot(this.node2term((RDFNode)c2)))) && this.originalABox.isSubclassOf((ATerm)a2, a1);
    }

    public boolean isProperty(Resource p) {
        return this.originalABox.rbox.isRole(this.node2term((RDFNode)p));
    }

    public boolean isDatatypeProperty(Resource p) {
        return this.originalABox.rbox.isDatatypeRole(this.node2term((RDFNode)p));
    }

    public boolean isObjectProperty(Resource p) {
        return this.originalABox.rbox.isObjectRole(this.node2term((RDFNode)p));
    }

    public boolean isAnnotationProperty(Resource p) {
        return this.originalABox.rbox.isAnnotationRole(this.node2term((RDFNode)p));
    }

    public boolean isTransitiveProperty(Resource p) {
        ATerm r = this.node2term((RDFNode)p);
        if (this.originalABox.rbox.isTransitive(r)) {
            return true;
        }
        ABox abox = this.originalABox.cloneABox();
        ATermAppl x = ATermUtils.makeTermAppl("_x_");
        ATermAppl y = ATermUtils.makeTermAppl("_y_");
        ATermAppl Y = ATermUtils.makeValue((ATerm)y);
        ATermAppl a1 = ATermUtils.makeSomeValues(r, (ATerm)ATermUtils.makeSomeValues(r, (ATerm)Y));
        ATermAppl a2 = ATermUtils.makeAllValues(r, (ATerm)ATermUtils.makeNot((ATerm)Y));
        abox.addNode((ATerm)x);
        abox.addType((ATerm)x, (ATerm)a1);
        abox.addType((ATerm)x, (ATerm)a2);
        abox.addNode((ATerm)y);
        return !abox.isConsistent();
    }

    public boolean isSymmetricProperty(Resource p) {
        return this.isInverse(p, p);
    }

    public boolean isFunctionalProperty(Resource p) {
        ATermAppl max1P = ATermUtils.makeMax1(this.node2term((RDFNode)p));
        return this.originalABox.isSubclassOf(ATermUtils.TOP, (ATerm)max1P);
    }

    public boolean isInverseFunctionalProperty(Resource p) {
        ATerm invP = this.originalABox.rbox.getInverseRole(this.node2term((RDFNode)p));
        ATermAppl max1invP = ATermUtils.makeMax1(invP);
        return this.originalABox.isSubclassOf(ATermUtils.TOP, (ATerm)max1invP);
    }

    public boolean isSubPropertyOf(Resource p1, Resource p2) {
        ATerm s;
        ATerm r = this.node2term((RDFNode)p1);
        if (this.originalABox.rbox.isSubRole(r, s = this.node2term((RDFNode)p2))) {
            return true;
        }
        ABox abox = this.originalABox.cloneABox();
        ATermAppl x = ATermUtils.makeTermAppl("_x_");
        ATermAppl y = ATermUtils.makeTermAppl("_y_");
        ATermAppl Y = ATermUtils.makeValue((ATerm)y);
        ATermAppl someRfromY = ATermUtils.makeSomeValues(r, (ATerm)Y);
        ATermAppl someSfromY = ATermUtils.makeSomeValues(s, (ATerm)Y);
        abox.addNode((ATerm)x);
        abox.addType((ATerm)x, (ATerm)someRfromY);
        abox.addType((ATerm)x, (ATerm)ATermUtils.makeNot((ATerm)someSfromY));
        abox.addNode((ATerm)y);
        return !abox.isConsistent();
    }

    public boolean isEquivalentProperty(Resource p1, Resource p2) {
        return this.isSubPropertyOf(p1, p2) && this.isSubPropertyOf(p2, p1);
    }

    public boolean isInverse(Resource p1, Resource p2) {
        ATerm r2;
        ATerm r1 = this.node2term((RDFNode)p1);
        if (this.originalABox.rbox.isInverse(r1, r2 = this.node2term((RDFNode)p2))) {
            return true;
        }
        ABox abox = this.originalABox.cloneABox();
        ATermAppl x = ATermUtils.makeTermAppl("_x_");
        ATermAppl X = ATermUtils.makeValue((ATerm)x);
        ATermAppl c = ATermUtils.makeSomeValues(r1, (ATerm)ATermUtils.makeSomeValues(r2, (ATerm)ATermUtils.makeNot((ATerm)X)));
        abox.addNode((ATerm)x);
        abox.addType((ATerm)x, (ATerm)c);
        return !abox.isConsistent();
    }

    public boolean hasDomain(Resource p, Resource c) {
        ATerm invP = this.originalABox.rbox.getInverseRole(this.node2term((RDFNode)p));
        ATermAppl allValues = ATermUtils.makeAllValues(invP, this.node2term((RDFNode)c));
        return this.originalABox.isSubclassOf(ATermUtils.TOP, (ATerm)allValues);
    }

    public boolean hasRange(Resource p, Resource c) {
        ATermAppl allValues = ATermUtils.makeAllValues(this.node2term((RDFNode)p), this.node2term((RDFNode)c));
        return this.originalABox.isSubclassOf(ATermUtils.TOP, (ATerm)allValues);
    }

    public boolean isIndividual(Resource i) {
        ATerm x = this.node2term((RDFNode)i);
        if (x == null) {
            return true;
        }
        return this.originalABox.isNode(x);
    }

    public boolean isSameAs(Resource i1, Resource i2) {
        ATerm t1 = this.node2term((RDFNode)i1);
        ATerm t2 = this.node2term((RDFNode)i2);
        return this.isSameAs(t1, t2);
    }

    public boolean isSameAs(ATerm t1, ATerm t2) {
        if (!this.originalABox.isNode(t1)) {
            throw new UnsupportedFeatureException(t1 + " is not an individual and cannot be used in owl:sameAs construct!");
        }
        if (!this.originalABox.isNode(t2)) {
            throw new UnsupportedFeatureException(t2 + " is not an individual and cannot be used in owl:sameAs construct!");
        }
        if (this.originalABox.isSame(t1, t2)) {
            return true;
        }
        ABox abox = this.originalABox.cloneABox();
        ATermAppl c = ATermUtils.makeTermAppl("_c_");
        ATermAppl notC = ATermUtils.makeNot((ATerm)c);
        abox.addType(t1, (ATerm)c);
        abox.addType(t2, (ATerm)notC);
        return !abox.isConsistent();
    }

    public boolean isDifferentFrom(Resource i1, Resource i2) {
        ATerm t1 = this.node2term((RDFNode)i1);
        ATerm t2 = this.node2term((RDFNode)i2);
        return this.isDifferentFrom(t1, t2);
    }

    public boolean isDifferentFrom(ATerm t1, ATerm t2) {
        if (this.originalABox.isDifferent(t1, t2)) {
            return true;
        }
        ABox abox = this.originalABox.cloneABox();
        ATermAppl p = ATermUtils.makeTermAppl("_p_");
        abox.rbox.addObjectRole((ATerm)p);
        ATermAppl x = ATermUtils.makeTermAppl("_x_");
        abox.addNode((ATerm)x);
        abox.addType((ATerm)x, (ATerm)ATermUtils.makeMax1((ATerm)p));
        abox.addEdge((ATerm)p, (ATerm)x, t1);
        abox.addEdge((ATerm)p, (ATerm)x, t2);
        return !abox.isConsistent();
    }

    public boolean isType(Resource i, Resource r) {
        ATerm x = this.node2term((RDFNode)i);
        ATerm c = this.node2term((RDFNode)r);
        return this.isType(x, c);
    }

    public boolean isType(ATerm x, ATerm c) {
        if (x == null) {
            return this.originalABox.isSatisfiable(c);
        }
        if (!this.originalABox.isNode(x)) {
            return false;
        }
        if (this.originalABox.hasType(x, c)) {
            return true;
        }
        ABox abox = this.originalABox.cloneABox();
        abox.addType(x, (ATerm)ATermUtils.makeNot(c));
        return !abox.isConsistent();
    }

    public boolean isOntology(Resource r) {
        if (r.isAnon()) {
            return this.originalABox.ontologies.size() > 1;
        }
        String onto = r.toString();
        if (!onto.endsWith("#")) {
            onto = String.valueOf(onto) + "#";
        }
        return this.originalABox.ontologies.contains(onto);
    }

    public boolean hasPropertyValue(Resource s, Resource p, RDFNode o) {
        ABox abox = this.originalABox.cloneABox();
        ATerm a = this.node2term((RDFNode)s);
        ATerm r = this.node2term((RDFNode)p);
        if (abox.rbox.isAnnotationRole(r)) {
            throw new UnsupportedFeatureException("Reasoning with respect to annotation properties is not supported");
        }
        if (a == null) {
            return true;
        }
        if (!abox.isNode(a)) {
            return false;
        }
        if (abox.rbox.isDatatypeRole(r)) {
            Literal lit = (Literal)o;
            Object value = lit.getValue();
            Datatype dt = null;
            if (value instanceof String) {
                dt = new Datatype.DTString((String)value);
            } else if (value instanceof Number) {
                dt = new Datatype.DTInteger(((Number)value).longValue());
            }
            dt.negate();
            String dtName = "http://www.mindswap.org/2003/pellet#tempDtName";
            ATermAppl dtTerm = ATermUtils.makeDatatype(dtName);
            abox.dtReasoner.defineDatatype(dtName, dt);
            ATermAppl allRnotD = ATermUtils.makeAllValues(r, (ATerm)dtTerm);
            abox.addType(a, (ATerm)allRnotD);
            return !abox.isConsistent();
        }
        ATerm b = this.node2term(o);
        if (b == null) {
            ABox qbox = new ABox();
            OWLParser.parse(s.getModel(), qbox);
            ABoxQuery q = new ABoxQuery(this.originalABox, qbox);
            boolean isConsistent = false;
            try {
                isConsistent = q.runQuery() != null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return isConsistent;
        }
        ATermAppl B = ATermUtils.makeTermAppl("_B_");
        ATermAppl allRnotB = ATermUtils.makeAllValues(r, (ATerm)ATermUtils.makeNot((ATerm)B));
        if (!abox.isNode(b)) {
            return false;
        }
        abox.addType(b, (ATerm)B);
        abox.addType(a, (ATerm)allRnotB);
        if (abox.edgeExists(r, a, b)) {
            return true;
        }
        return !abox.isConsistent();
    }

    public boolean hasPropertyValue(ATerm a, ATerm r, ATerm b) {
        ABox abox = this.originalABox.cloneABox();
        if (abox.rbox.isAnnotationRole(r)) {
            throw new UnsupportedFeatureException("Reasoning with respect to annotation properties is not supported");
        }
        if (!abox.isNode(a)) {
            return false;
        }
        if (abox.rbox.isDatatypeRole(r)) {
            throw new UnsupportedFeatureException("Oops!");
        }
        ATermAppl B = ATermUtils.makeTermAppl("_B_");
        ATermAppl allRnotB = ATermUtils.makeAllValues(r, (ATerm)ATermUtils.makeNot((ATerm)B));
        if (!abox.isNode(b)) {
            return false;
        }
        abox.addType(b, (ATerm)B);
        abox.addType(a, (ATerm)allRnotB);
        if (abox.edgeExists(r, a, b)) {
            return true;
        }
        return !abox.isConsistent();
    }

    public boolean isEntailed(String url) throws Exception {
        return this.isEntailed(url, "RDF/XML");
    }

    public boolean isEntailed(String url, String lang) throws Exception {
        return this.isEntailed(new URL(url).openConnection().getInputStream(), url, lang);
    }

    public boolean isEntailed(InputStream in) throws Exception {
        return this.isEntailed(in, "RDF/XML");
    }

    public boolean isEntailed(InputStream in, String lang) throws Exception {
        return this.isEntailed(in, OWLParser.BASE_URI, lang);
    }

    public boolean isEntailed(InputStream in, String url, String lang) throws Exception {
        if (DEBUG) {
            System.err.println("Entailment check starting...");
        }
        Model model = ModelFactory.createDefaultModel();
        model.read(in, url, lang);
        Pellet.timers.resetTimer("Entailment");
        boolean isEntailed = this.isEntailed(model);
        Pellet.timers.stopTimer("Entailment");
        return isEntailed;
    }

    public boolean isEntailed(Model model) throws UnsupportedFeatureException {
        StmtIterator i = model.listStatements();
        while (i.hasNext()) {
            Statement stmt = (Statement)i.next();
            if (this.isEntailed(stmt)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailed(Statement stmt) throws UnsupportedFeatureException {
        boolean isEntailed;
        if (DEBUG) {
            System.out.println("Check entailment " + stmt);
        }
        if (!(isEntailed = this.isEntailed(stmt.getSubject(), stmt.getPredicate(), stmt.getObject()))) {
            System.err.println("Does not entail: (" + stmt + ")");
        }
        return isEntailed;
    }

    public boolean isEntailed(Resource s, Property p, RDFNode ox) throws UnsupportedFeatureException {
        Resource o;
        if (OWLParser.RESTRICTION_PROPS.contains(p) && !p.equals((Object)RDF.type) || p.equals((Object)RDF.first) || p.equals((Object)RDF.rest)) {
            if (DEBUG) {
                System.out.println("Skip list related triple");
            }
            return true;
        }
        Resource resource = o = ox instanceof Resource ? (Resource)ox : null;
        if (p.equals((Object)RDF.type)) {
            if (o.equals((Object)OWL.Class) || o.equals((Object)RDFS.Class)) {
                return this.isClass(s);
            }
            if (o.equals((Object)OWL.Thing)) {
                return this.isIndividual(s);
            }
            if (o.equals((Object)RDF.List)) {
                if (DEBUG) {
                    System.out.println("Skip type triple for rdf:List");
                }
                return true;
            }
            if (o.equals((Object)OWL.Restriction)) {
                if (DEBUG) {
                    System.out.println("Skip type triple for owl:Different");
                }
                return true;
            }
            if (o.equals((Object)OWL.AllDifferent)) {
                throw new UnsupportedFeatureException("owl:AllDifferent is not supported");
            }
            if (o.equals((Object)RDF.Property)) {
                return this.isProperty(s);
            }
            if (o.equals((Object)OWL.ObjectProperty)) {
                return this.isObjectProperty(s);
            }
            if (o.equals((Object)OWL.DatatypeProperty)) {
                return this.isDatatypeProperty(s);
            }
            if (o.equals((Object)OWL.AnnotationProperty)) {
                return this.isAnnotationProperty(s);
            }
            if (o.equals((Object)OWL.Ontology)) {
                return this.isOntology(s);
            }
            if (o.equals((Object)OWL.TransitiveProperty)) {
                return this.isTransitiveProperty(s);
            }
            if (o.equals((Object)OWL.SymmetricProperty)) {
                return this.isSymmetricProperty(s);
            }
            if (o.equals((Object)OWL.FunctionalProperty)) {
                return this.isFunctionalProperty(s);
            }
            if (o.equals((Object)OWL.InverseFunctionalProperty)) {
                return this.isInverseFunctionalProperty(s);
            }
            return this.isType(s, o);
        }
        if (p.equals((Object)OWL.intersectionOf)) {
            if (DEBUG) {
                System.out.println("Skip intersection of triple");
            }
            return true;
        }
        if (p.equals((Object)OWL.unionOf)) {
            if (DEBUG) {
                System.out.println("Skip union of triple");
            }
            return true;
        }
        if (p.equals((Object)OWL.complementOf)) {
            return this.isComplement(s, o);
        }
        if (p.equals((Object)OWL.subClassOf)) {
            return this.isSubclassOf(s, o);
        }
        if (p.equals((Object)OWL.equivalentClass)) {
            return this.isEquivalentClass(s, o);
        }
        if (p.equals((Object)OWL.disjointWith)) {
            return this.isDisjoint(s, o);
        }
        if (p.equals((Object)OWL.equivalentProperty)) {
            return this.isEquivalentProperty(s, o);
        }
        if (p.equals((Object)OWL.subPropertyOf)) {
            return this.isSubPropertyOf(s, o);
        }
        if (p.equals((Object)OWL.inverseOf)) {
            return this.isInverse(s, o);
        }
        if (p.equals((Object)OWL.sameAs) || p.equals((Object)OWL.sameIndividualAs)) {
            return this.isSameAs(s, o);
        }
        if (p.equals((Object)OWL.differentFrom)) {
            return this.isDifferentFrom(s, o);
        }
        if (p.equals((Object)RDFS.domain)) {
            return this.hasDomain(s, o);
        }
        if (p.equals((Object)RDFS.range)) {
            return this.hasRange(s, o);
        }
        if (p.equals((Object)OWL.distinctMembers)) {
            throw new UnsupportedFeatureException("owl:distinctMembers is not supported yet");
        }
        if (p.equals((Object)OWL.oneOf)) {
            if (DEBUG) {
                System.out.println("Skip oneOf triple");
            }
            return true;
        }
        if (p.equals((Object)OWL.imports)) {
            throw new UnsupportedFeatureException("owl:imports is not supported yet");
        }
        if (p.getURI().startsWith("http://www.w3.org/2002/07/owl#")) {
            System.err.println("Warning: " + p + " does not belong to OWL namespace");
            if (p.getLocalName().equals("differentIndividualFrom")) {
                System.err.println("Warning: Renaming the predicate to owl:differentFrom");
                return this.isDifferentFrom(s, o);
            }
            if (p.getLocalName().equals("samePropertyAs")) {
                System.err.println("Warning: Renaming the predicate to owl:equivalentProperty");
                return this.isEquivalentProperty(s, o);
            }
            if (p.getLocalName().equals("sameClassAs")) {
                System.err.println("Warning: Renaming the predicate to owl:equivalentClass");
                return this.isEquivalentClass(s, o);
            }
            throw new UnsupportedFeatureException(p + " does not belong to OWL namespace");
        }
        return this.hasPropertyValue(s, (Resource)p, ox);
    }
}

