/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.mindswap.wsdl.WSDLOperation;
import org.w3c.dom.Node;

public class WSDLService {
    private boolean DEBUG = false;
    private Parser wsdlParser = null;
    private String uri = null;
    private Hashtable operations = new Hashtable();
    static /* synthetic */ Class class$0;

    public WSDLService(String wsdlURL) throws Exception {
        this.uri = wsdlURL;
        this.wsdlParser = new Parser();
        System.out.println("Reading WSDL document from '" + wsdlURL + "'");
        this.wsdlParser.run(wsdlURL);
        this.readOperations();
    }

    public static WSDLService createService(String wsdlLoc) {
        WSDLService s = null;
        try {
            s = new WSDLService(wsdlLoc);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return s;
    }

    private void readOperations() {
        try {
            String serviceNS = null;
            String serviceName = null;
            String operationName = null;
            String portName = null;
            Service service = this.selectService(serviceNS, serviceName);
            org.apache.axis.client.Service dpf = new org.apache.axis.client.Service(this.wsdlParser, service.getQName());
            Port port = this.selectPort(service.getPorts(), portName);
            if (portName == null) {
                portName = port.getName();
            }
            Binding binding = port.getBinding();
            SymbolTable symbolTable = this.wsdlParser.getSymbolTable();
            BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
            Parameters parameters = null;
            Iterator i = bEntry.getParameters().keySet().iterator();
            while (i.hasNext()) {
                Node doc;
                Operation o = (Operation)i.next();
                operationName = o.getName();
                Call call = (Call)dpf.createCall(QName.valueOf(portName), QName.valueOf(operationName));
                WSDLOperation op = new WSDLOperation(call);
                op.setService(this);
                this.operations.put(operationName, op);
                if (this.DEBUG) {
                    System.out.println("       Operation: " + op.getName());
                }
                Message inputMessage = o.getInput().getMessage();
                Message outputMessage = o.getOutput().getMessage();
                op.setInputMessageName(inputMessage.getQName().getLocalPart());
                op.setOutputMessageName(outputMessage.getQName().getLocalPart());
                op.setPortName(port.getName());
                Object obj = bEntry.getInputBodyType(o);
                obj = o.getInput().getMessage().getQName().getLocalPart();
                if (o.getDocumentationElement() != null && (doc = o.getDocumentationElement().getFirstChild()) != null) {
                    op.setDocumentation(doc.getNodeValue());
                }
                parameters = (Parameters)bEntry.getParameters().get(o);
                int j = 0;
                while (j < parameters.list.size()) {
                    Parameter p = (Parameter)parameters.list.get(j);
                    String name = p.getQName().getLocalPart();
                    QName type = p.getType().getQName();
                    if (p.getMode() == 1) {
                        op.addInput(name, type);
                        if (this.DEBUG) {
                            System.out.println("       Input    : " + name + " " + type);
                        }
                    } else if (p.getMode() == 2) {
                        op.addOutput(name, type);
                        if (this.DEBUG) {
                            System.out.println("       Output   : " + name + " " + type);
                        }
                    } else if (p.getMode() == 3) {
                        op.addInput(name, type);
                        op.addOutput(name, type);
                        System.err.println("WARNING: A wsdl parameter is defined as INOUT is not tested yet");
                        System.err.println("         Parameter = " + name);
                        if (this.DEBUG) {
                            System.out.println("       InOut    : " + name + " " + type);
                        }
                    }
                    ++j;
                }
                if (parameters.returnParam != null) {
                    Parameter p = parameters.returnParam;
                    String name = p.getQName().getLocalPart();
                    QName type = p.getType().getQName();
                    op.addOutput(name, type);
                    if (this.DEBUG) {
                        System.out.println("       Return   : " + name + " " + type);
                    }
                }
                if (!this.DEBUG) continue;
                System.out.println("       Inputs   : " + op.getInputs().size());
                System.out.println("       Outputs  : " + op.getOutputs().size());
                System.out.println("       Document : " + op.getDocumentation());
                System.out.println();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public Service selectService(String serviceNS, String serviceName) throws Exception {
        QName serviceQName = serviceNS != null && serviceName != null ? new QName(serviceNS, serviceName) : null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.wsdl.symbolTable.ServiceEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceEntry serviceEntry = (ServiceEntry)this.getSymTabEntry(serviceQName, clazz);
        return serviceEntry.getService();
    }

    public SymTabEntry getSymTabEntry(QName qname, Class cls) {
        HashMap map = this.wsdlParser.getSymbolTable().getHashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Vector v = (Vector)entry.getValue();
            if (qname != null && !qname.equals(qname)) continue;
            int i = 0;
            while (i < v.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (cls.isInstance(symTabEntry)) {
                    return symTabEntry;
                }
                ++i;
            }
        }
        return null;
    }

    public Port selectPort(Map ports, String portName) throws Exception {
        Iterator valueIterator = ports.keySet().iterator();
        while (valueIterator.hasNext()) {
            String name = (String)valueIterator.next();
            if (portName == null || portName.length() == 0) {
                Port port = (Port)ports.get(name);
                List list = port.getExtensibilityElements();
                int i = 0;
                while (list != null && i < list.size()) {
                    Object obj = list.get(i);
                    if (obj instanceof SOAPAddress) {
                        return port;
                    }
                    ++i;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return (Port)ports.get(name);
        }
        return null;
    }

    public String getFileURI() {
        return this.uri;
    }

    public Vector getOperations() {
        return new Vector(this.operations.values());
    }

    public WSDLOperation getOperation(String opName) {
        return (WSDLOperation)this.operations.get(opName);
    }
}

