/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import org.mindswap.owl.vocabulary.OWL;
import org.mindswap.utils.Utils;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.mindswap.wsdl.WSDLTranslator;

public class WSDL2OWLS
extends JPanel {
    final String[] nsColumnNames = new String[]{"Abbr", "URI"};
    final String[] columnNames = new String[]{"WSDL Parameter", "WSDL Type", "DAML-S Name", "DAML Type", "XSLT"};
    final String[][] emptyRow = new String[0][5];
    final String[] defaultFiles = new String[]{"http://www.mindswap.org/services/AddressPhotoService.wsdl", "http://www.swanandmokashi.com/HomePage/WebServices/StockQuotes.asmx?WSDL", "http://www.xmethods.net/sd/2001/BNQuoteService.wsdl", "http://www.mindswap.org/2002/services/BabelFishTranslator.wsdl", "file://C/Mindswap/services/fujitsu/displaymap.wsdl", "http://www.tinetics.com/webservices/get_states.cfc?wsdl", "http://www.webservicex.net/uszip.asmx?WSDL", "http://www.mindswap.org/2002/services/Dictionary.wsdl"};
    JComboBox urls = new JComboBox<String>(this.defaultFiles);
    JList opList = new JList();
    JTable inputTable = new DNDTable(this.emptyRow, this.columnNames);
    JTable outputTable = new DNDTable(this.emptyRow, this.columnNames);
    JTextField fileNameField = new JTextField();
    JTextField serviceNameField = new JTextField();
    JTextArea textDescription = new JTextArea(10, 20);
    JTable nsTable = new JTable(0, 2);

    public WSDL2OWLS() {
        JPanel contentPane = new JPanel();
        JPanel addressPanel = new JPanel();
        JPanel middlePanel = new JPanel();
        JPanel operationsPanel = new JPanel();
        JPanel detailsPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        this.setLayout(new GridLayout(1, 1));
        this.add(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPane.add(addressPanel);
        contentPane.add(Box.createVerticalStrut(2));
        contentPane.add(middlePanel);
        contentPane.add(Box.createVerticalStrut(2));
        contentPane.add(buttonPanel);
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2OWLS.this.doBrowse();
            }
        });
        JButton loadButton = new JButton("Load");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2OWLS.this.doLoad();
            }
        });
        addressPanel.setLayout(new BoxLayout(addressPanel, 0));
        addressPanel.add(new JLabel("Enter URL: "));
        addressPanel.add(Box.createHorizontalStrut(2));
        addressPanel.add(this.urls);
        this.urls.setEditable(true);
        this.urls.setSelectedItem("");
        addressPanel.add(Box.createHorizontalStrut(2));
        addressPanel.add(browseButton);
        addressPanel.add(Box.createHorizontalStrut(2));
        addressPanel.add(loadButton);
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        middlePanel.add(operationsPanel);
        middlePanel.add(detailsPanel);
        operationsPanel.setBorder(BorderFactory.createTitledBorder("Operations"));
        operationsPanel.setLayout(new BoxLayout(operationsPanel, 0));
        operationsPanel.add(new JScrollPane(this.opList));
        this.opList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WSDL2OWLS.this.doSelect();
            }
        });
        JPanel servicePanel = new JPanel();
        JPanel inputsPanel = new JPanel();
        JPanel outputsPanel = new JPanel();
        JPanel nsPanel = new JPanel();
        JPanel nsButtons = new JPanel();
        JScrollPane js = new JScrollPane(this.textDescription);
        js.setPreferredSize(new Dimension(js.getPreferredSize().width, 50));
        js.setMinimumSize(new Dimension(js.getPreferredSize().width, 50));
        servicePanel = this.createTableLayout(new JLabel[]{new JLabel("File Name"), new JLabel("Service Name"), new JLabel("Text description")}, new JComponent[]{this.fileNameField, this.serviceNameField, js});
        servicePanel.setBorder(BorderFactory.createTitledBorder("Service information"));
        this.textDescription.setLineWrap(true);
        this.textDescription.setWrapStyleWord(true);
        JButton addNSButton = new JButton("Add");
        JButton removeNSButton = new JButton("Remove");
        addNSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2OWLS.this.addNS();
            }
        });
        nsButtons.setLayout(new BoxLayout(nsButtons, 0));
        nsButtons.add(Box.createHorizontalGlue());
        nsButtons.add(addNSButton);
        nsButtons.add(Box.createHorizontalStrut(5));
        nsButtons.add(removeNSButton);
        nsPanel.setLayout(new BoxLayout(nsPanel, 1));
        nsPanel.setBorder(BorderFactory.createTitledBorder("Namespaces"));
        nsPanel.add(new JScrollPane(this.nsTable));
        nsPanel.add(Box.createVerticalStrut(2));
        nsPanel.add(nsButtons);
        inputsPanel.setLayout(new BoxLayout(inputsPanel, 1));
        inputsPanel.setBorder(BorderFactory.createTitledBorder("Inputs"));
        inputsPanel.add(new JScrollPane(this.inputTable));
        outputsPanel.setLayout(new BoxLayout(outputsPanel, 1));
        outputsPanel.setBorder(BorderFactory.createTitledBorder("Outputs"));
        outputsPanel.add(new JScrollPane(this.outputTable));
        JButton generateButton = new JButton("Generate OWL-S");
        generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WSDL2OWLS.this.doGenerate();
            }
        });
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(generateButton);
        detailsPanel.setLayout(new BoxLayout(detailsPanel, 1));
        detailsPanel.add(servicePanel);
        detailsPanel.add(inputsPanel);
        detailsPanel.add(outputsPanel);
        detailsPanel.add(nsPanel);
        this.updateNS();
    }

    JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.0f);
        label.setVerticalAlignment(1);
        int labelWidth = 100;
        label.setPreferredSize(new Dimension(labelWidth, label.getPreferredSize().height));
        label.setMaximumSize(new Dimension(labelWidth, label.getMaximumSize().height));
        label.setMinimumSize(new Dimension(labelWidth, label.getMinimumSize().height));
        return label;
    }

    public void addNS() {
        JDialog info = new JDialog(null, "Add namespace", true);
        JTextField t1 = new JTextField(10);
        JTextField t2 = new JTextField(5);
        JComponent[] labels = new JLabel[]{new JLabel("Enter URL: "), new JLabel("Abbreviation:")};
        JComponent[] textFields = new JComponent[]{t1, t2};
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComponent c = (JComponent)e.getSource();
                Window w = (Window)c.getTopLevelAncestor();
                w.dispose();
            }
        });
        info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
        info.getContentPane().add(this.createTableLayout(labels, textFields));
        info.getContentPane().add(ok);
        ok.setAlignmentX(0.5f);
        info.pack();
        info.setResizable(false);
        Utils.centerFrame(info);
        info.show();
        System.out.println(String.valueOf(t1.getText()) + " " + t2.getText());
        String url = t1.getText();
        String abbr = t2.getText();
        Utils.addNS(url, abbr);
        this.updateNS();
    }

    private JPanel createTableLayout(JComponent[] labels, JComponent[] textFields) {
        JPanel textControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        textControlsPane.setLayout(gridbag);
        c.anchor = 17;
        int numLabels = labels.length;
        int i = 0;
        while (i < numLabels) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            c.insets = new Insets(2, 2, 2, 2);
            gridbag.setConstraints(labels[i], c);
            textControlsPane.add(labels[i]);
            c.gridwidth = 0;
            if (i == numLabels - 1) {
                c.gridheight = 0;
            }
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(2, 2, 2, 2);
            gridbag.setConstraints(textFields[i], c);
            textControlsPane.add(textFields[i]);
            ++i;
        }
        return textControlsPane;
    }

    void doLoad() {
        String url = this.urls.getSelectedItem().toString();
        WSDLService s = WSDLService.createService(url);
        Vector ops = s.getOperations();
        this.opList.setListData(ops);
    }

    void doBrowse() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, String.valueOf(file.getAbsolutePath()) + "does not exist!", "Error", 0);
        } else {
            try {
                this.urls.setSelectedItem(file.toURL().toExternalForm());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot find file " + file.getAbsolutePath() + "\n" + e, "Error", 0);
            }
        }
    }

    void doSelect() {
        WSDLOperation op = (WSDLOperation)this.opList.getSelectedValue();
        if (op == null) {
            this.fileNameField.setText("");
            this.serviceNameField.setText("");
            this.textDescription.setText("");
            this.addParams(new Vector(), this.inputTable);
            this.addParams(new Vector(), this.outputTable);
        } else {
            this.fileNameField.setText(op.getName());
            this.serviceNameField.setText(op.getName());
            if (op.getDocumentation() == null) {
                this.textDescription.setText("Auto generated from " + op.getService().getFileURI());
            } else {
                this.textDescription.setText(op.getDocumentation());
            }
            this.textDescription.setCaretPosition(0);
            this.addParams(op.getInputs(), this.inputTable);
            this.addParams(op.getOutputs(), this.outputTable);
        }
        this.updateNS();
    }

    private void addParams(Vector params, JTable table) {
        DefaultTableModel model = new DefaultTableModel(this.columnNames, 0);
        Iterator i = params.iterator();
        while (i.hasNext()) {
            Object[] row = new String[this.columnNames.length];
            WSDLParameter p = (WSDLParameter)i.next();
            QName wsdlType = p.getType() == null ? new QName("http://www.w3.org/2001/XMLSchema", "any") : p.getType();
            String type = Utils.getRDFAbbr(OWL.Thing.toString());
            if (wsdlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !wsdlType.getLocalPart().equals("any")) {
                type = Utils.getRDFAbbr(wsdlType);
            } else if (wsdlType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                type = "xsd:" + wsdlType.getLocalPart();
            }
            row[0] = p.getName();
            row[1] = Utils.getRDFAbbr(wsdlType);
            row[2] = row[0];
            row[3] = type;
            model.addRow(row);
        }
        table.setModel(model);
    }

    private String[] getColumn(JTable table, int column) {
        TableModel model = table.getModel();
        String[] paramTypes = new String[model.getRowCount()];
        int i = 0;
        while (i < model.getRowCount()) {
            paramTypes[i] = (String)model.getValueAt(i, column);
            System.out.println("value(" + i + ", " + column + " " + paramTypes[i]);
            ++i;
        }
        return paramTypes;
    }

    void doGenerate() {
        int option;
        WSDLTranslator t = new WSDLTranslator();
        WSDLOperation op = (WSDLOperation)this.opList.getSelectedValue();
        String serviceName = this.serviceNameField.getText();
        String fileName = this.fileNameField.getText();
        String description = t.createOWLS(op, fileName, serviceName, this.textDescription.getText(), this.getColumn(this.inputTable, 2), this.getColumn(this.inputTable, 3), this.getColumn(this.inputTable, 4), this.getColumn(this.outputTable, 2), this.getColumn(this.outputTable, 3), this.getColumn(this.outputTable, 4));
        if (description == null) {
            JOptionPane.showMessageDialog(null, "Cannot create OWL-S file!", "Error", 0);
            return;
        }
        File file = new File(fileName = String.valueOf(fileName) + ".owl");
        if (file.exists() && (option = JOptionPane.showConfirmDialog(null, String.valueOf(file.getAbsolutePath()) + " already exists.\n" + "Do you want to replace it?", "Save File", 0, 3)) == 1) {
            return;
        }
        String service = "";
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fileName));
            out.print(description);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (service == null) {
            JOptionPane.showMessageDialog(null, "Saved file " + file.getAbsolutePath() + " is not valid", "Error", 0);
        } else {
            JOptionPane.showMessageDialog(null, "Service " + file.getAbsolutePath() + " was saved succesfully", "Error", 1);
        }
    }

    void updateNS() {
        DefaultTableModel model = new DefaultTableModel(this.nsColumnNames, 0);
        Iterator e = Utils.getNamespaces().entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            String nsURI = (String)entry.getKey();
            String nsValue = (String)entry.getValue();
            model.addRow(new String[]{nsValue, nsURI});
        }
        this.nsTable.setModel(model);
        this.nsTable.getColumnModel().getColumn(0).setMaxWidth(75);
    }

    public static void main(String[] args) throws Exception {
        JFrame test = new JFrame();
        test.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        test.setSize(800, 600);
        Utils.centerFrame(test);
        test.getContentPane().add(new WSDL2OWLS());
        test.show();
    }

    public class DNDTable
    extends JTable
    implements DropTargetListener {
        DNDTable(Object[][] data, String[] columnNames) {
            super(data, columnNames);
        }

        public void drop(DropTargetDropEvent event) {
            System.out.println("this");
        }

        public void dragEnter(DropTargetDragEvent event) {
        }

        public void dragExit(DropTargetEvent event) {
        }

        public void dragOver(DropTargetDragEvent event) {
            System.out.println("here");
            Point p = event.getLocation();
            int row = this.rowAtPoint(p);
            this.setRowSelectionInterval(row, row);
        }

        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

