/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.EffectList;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.process.impl.ProcessComponentImpl;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;

public abstract class ProcessImpl
extends ProcessComponentImpl
implements Process {
    Service service;
    InputList inputs = OWLSFactory.createInputList();
    OutputList outputs = OWLSFactory.createOutputList();
    ConditionList preconditions = OWLSFactory.createConditionList();
    EffectList effects = OWLSFactory.createEffectList();
    ValueMap defaultValues = OWLSFactory.createValueMap();

    public ProcessImpl(Resource resource) {
        super(resource);
    }

    public Service getService() {
        return this.service;
    }

    public Profile getProfile() {
        return this.service.getProfile();
    }

    public InputList getInputs() {
        return this.inputs;
    }

    public OutputList getOutputs() {
        return this.outputs;
    }

    public Parameter getParameter(URI parameterURI) {
        Parameter p = this.inputs.getParameter(parameterURI);
        if (p == null) {
            p = this.outputs.getParameter(parameterURI);
        }
        return p;
    }

    public ConditionList getPreconditions() {
        return this.preconditions;
    }

    public ValueMap getDefaultValues() {
        return this.defaultValues;
    }

    public EffectList getEffects() {
        return this.effects;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String debugString() {
        String str = String.valueOf(this.getLabel()) + "  " + this.getURI() + "\n";
        int i = 0;
        while (i < this.inputs.size()) {
            str = String.valueOf(str) + this.inputs.inputAt(i).debugString() + "\n";
            ++i;
        }
        i = 0;
        while (i < this.outputs.size()) {
            str = String.valueOf(str) + this.outputs.outputAt(i).debugString() + "\n";
            ++i;
        }
        return str;
    }
}

