/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import org.mindswap.owl.OWLResource;
import org.mindswap.owl.Util;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.io.impl.OWLSWriterImpl;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponent;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS;
import org.mindswap.owls.vocabulary.OWLS_1_0;

public class OWLSWriter_1_0
extends OWLSWriterImpl {
    public static boolean DEBUG = false;
    private Model model = null;
    private URI base = null;
    private OWLS_1_0 OWLS = OWLS_1_0.instance;

    public OWLSWriter_1_0() {
        this.version = "1.0";
    }

    public void write(Service service, Writer out) {
        this.model = ModelFactory.createDefaultModel();
        this.model.setNsPrefix("service", this.OWLS.Service.URI);
        this.model.setNsPrefix("profile", this.OWLS.Profile.URI);
        this.model.setNsPrefix("process", this.OWLS.Process.URI);
        this.model.setNsPrefix("grounding", this.OWLS.Grounding.URI);
        this.base = service.getFileURI();
        RDFWriter writer = this.model.getWriter("RDF/XML-ABBREV");
        writer.setProperty("allowBadURIs", (Object)"true");
        writer.setProperty("blockRules", (Object)new Resource[]{RDFSyntax.propertyAttr});
        writer.setProperty("showXmlDeclaration", (Object)"true");
        this.writeService(service);
        writer.write(this.model, out, "");
    }

    private Resource toRDF(URI u) {
        if (this.base != null) {
            u = this.base.relativize(u);
        }
        return Util.toResource(u);
    }

    private Resource toRDF(OWLResource r) {
        return r.getJenaResource();
    }

    private RDFNode toRDF(String o) {
        return this.toRDF(o, false);
    }

    private RDFNode toRDF(String o, boolean wellFormed) {
        return this.model.createLiteral(o, wellFormed);
    }

    private void addStatement(Object s, Object p, Object o) {
        Resource subj = null;
        Property prop = null;
        RDFNode obj = null;
        if (s instanceof Resource) {
            subj = (Resource)s;
        } else if (s instanceof OWLResource) {
            subj = this.toRDF((OWLResource)s);
        } else if (s instanceof URI) {
            subj = this.toRDF((URI)s);
        } else {
            throw new RuntimeException("Invalid subject " + s + " " + s.getClass());
        }
        if (p instanceof Property) {
            prop = (Property)p;
        } else if (p instanceof URI) {
            prop = Util.toProperty((URI)p);
        } else {
            throw new RuntimeException("Invalid property " + p + " " + p.getClass());
        }
        if (o instanceof RDFNode) {
            obj = (RDFNode)o;
        } else if (o instanceof OWLResource) {
            obj = this.toRDF((OWLResource)o);
        } else if (o instanceof URI) {
            obj = this.toRDF((URI)o);
        } else if (o instanceof String) {
            obj = this.toRDF((String)o);
        } else {
            throw new RuntimeException("Invalid object " + o + " " + o.getClass());
        }
        this.model.add(subj, prop, obj);
    }

    private void writeService(Service service) {
        this.addStatement(service, RDF.type, this.OWLS.Service.Service);
        this.addStatement(service, this.OWLS.Service.presents, service.getProfile());
        this.addStatement(service, this.OWLS.Service.describedBy, service.getProcessModel());
        this.addStatement(service, this.OWLS.Service.supports, service.getGrounding());
        this.writeProfile(service.getProfile());
        this.writeProcessModel(service.getProcessModel());
        this.writeGrounding(service.getGrounding());
    }

    private void writeProfile(Profile profile) {
        URI profileType = profile.getType();
        int i = 0;
        while (i < OWLSFactory.supportedVersions.length) {
            String version = OWLSFactory.supportedVersions[i];
            OWLS vocabulary = OWLSFactory.getVocabulary(version);
            if (profileType.equals(vocabulary.getProfile().Profile)) {
                profileType = this.OWLS.Profile.Profile;
                break;
            }
            ++i;
        }
        this.addStatement(profile, RDF.type, profileType);
        this.addStatement(profile, this.OWLS.Service.presentedBy, profile.getService());
        if (profile.getLabel() != null) {
            this.addStatement(profile, this.OWLS.Profile.serviceName, profile.getLabel());
            this.addStatement(profile, RDFS.label, profile.getLabel());
        }
        if (profile.getTextDescription() != null) {
            this.addStatement(profile, this.OWLS.Profile.textDescription, profile.getTextDescription());
        }
        this.writeProfileParams(profile, profile.getInputs());
        this.writeProfileParams(profile, profile.getOutputs());
    }

    private void writeProfileParams(Profile profile, ParameterList params) {
        int i = 0;
        while (i < params.size()) {
            Parameter param = params.parameterAt(i);
            if (param instanceof Input) {
                this.addStatement(profile, this.OWLS.Profile.hasInput, param);
            } else {
                this.addStatement(profile, this.OWLS.Profile.hasOutput, param);
            }
            ++i;
        }
    }

    private void writeProcessModel(ProcessModel processModel) {
        this.addStatement(processModel, RDF.type, this.OWLS.Process.ProcessModel);
        this.addStatement(processModel, this.OWLS.Service.describes, this.OWLS.Process.AtomicProcess);
        this.addStatement(processModel, this.OWLS.Process.hasProcess, processModel.getProcess());
        this.writeProcess(processModel.getProcess());
    }

    private void writeProcess(Process process) {
        if (process instanceof AtomicProcess) {
            this.writeAtomicProcess((AtomicProcess)process);
        } else if (process instanceof CompositeProcess) {
            this.writeCompositeProcess((CompositeProcess)process);
        }
        this.writeProcessParams(process, process.getInputs());
        this.writeProcessParams(process, process.getOutputs());
        this.writeDefaultValues(process);
        this.writeDataFlow(process);
    }

    private void writeAtomicProcess(AtomicProcess process) {
        this.addStatement(process, RDF.type, this.OWLS.Process.AtomicProcess);
        this.writeProcessParams(process, process.getInputs());
        this.writeProcessParams(process, process.getOutputs());
    }

    private void writeProcessParams(Process process, ParameterList params) {
        int i = 0;
        while (i < params.size()) {
            Parameter param = params.parameterAt(i);
            if (param instanceof Input) {
                this.addStatement(process, this.OWLS.Process.hasInput, param);
                this.addStatement(param, RDF.type, this.OWLS.Process.Input);
            } else {
                this.addStatement(process, this.OWLS.Process.hasOutput, param);
                this.addStatement(param, RDF.type, this.OWLS.Process.Output);
            }
            this.addStatement(param, this.OWLS.Process.parameterType, param.getType());
            if (param.getLabel() != null) {
                this.addStatement(param, RDFS.label, param.getLabel());
            }
            ++i;
        }
    }

    private void writeCompositeProcess(CompositeProcess process) {
        this.addStatement(process, RDF.type, this.OWLS.Process.CompositeProcess);
        RDFNode cc = this.writeControlConstruct(process.getComposedOf());
        this.addStatement(process, this.OWLS.Process.composedOf, cc);
    }

    private RDFNode writeProcessComponent(ProcessComponent c) {
        if (c instanceof Process) {
            this.writeProcess((Process)c);
            return c.getJenaResource();
        }
        return this.writeControlConstruct((ControlConstruct)c);
    }

    private RDFNode writeControlConstruct(ControlConstruct construct) {
        RDFNode cc = null;
        if (construct instanceof Sequence) {
            cc = this.writeSequence((Sequence)construct);
        }
        return cc;
    }

    private RDFNode writeSequence(Sequence sequence) {
        RDFNode components = this.writeComponents(sequence.getComponents());
        this.addStatement(sequence, RDF.type, this.OWLS.Process.Sequence);
        this.addStatement(sequence, this.OWLS.Process.components, components);
        return sequence.getJenaResource();
    }

    private RDFNode writeComponents(ProcessComponentList list) {
        RDFNode[] elems = new RDFNode[list.size()];
        int i = 0;
        while (i < list.size()) {
            ProcessComponent c = list.processComponentAt(i);
            elems[i] = this.writeProcessComponent(c);
            ++i;
        }
        return this.model.createList(elems);
    }

    private void writeDataFlow(Process process) {
        DataFlow df = process.getDataFlow();
        int i = 0;
        while (i < df.size()) {
            DataFlowElement dfe = df.dfeAt(i);
            RDFNode[] elems = new RDFNode[dfe.size()];
            int j = 0;
            while (j < dfe.size()) {
                Parameter p = dfe.parameterAt(j);
                elems[j] = ResourceFactory.createResource();
                this.addStatement(elems[j], RDF.type, this.OWLS.Process.ValueOf);
                this.addStatement(elems[j], this.OWLS.Process.theProperty, p);
                if (p.getProcess() != null) {
                    this.addStatement(elems[j], this.OWLS.Process.atClass, p.getProcess());
                }
                ++j;
            }
            this.addStatement(process, this.OWLS.Process.sameValues, this.model.createList(elems));
            ++i;
        }
    }

    private void writeDefaultValues(Process process) {
    }

    private void writeGrounding(Grounding grounding) {
        boolean isWSDL = false;
        boolean isUPnP = false;
        this.addStatement(grounding, this.OWLS.Service.supportedBy, grounding.getService());
        Iterator i = grounding.getAtomicGroundings().iterator();
        while (i.hasNext()) {
            Object n = i.next();
            AtomicGrounding ag = (AtomicGrounding)n;
            isWSDL = isWSDL || ag instanceof WSDLAtomicGrounding;
            boolean bl = isUPnP = isUPnP && ag instanceof UPnPAtomicGrounding;
            if (ag instanceof WSDLAtomicGrounding) {
                this.addStatement(grounding, this.OWLS.Grounding.hasAtomicProcessGrounding, ag);
                this.writeWSDLGrounding((WSDLAtomicGrounding)ag);
                continue;
            }
            if (!(ag instanceof UPnPAtomicGrounding)) continue;
            this.addStatement(grounding, this.OWLS.Grounding.hasAtomicProcessGrounding, ag);
            this.writeUPnPGrounding((UPnPAtomicGrounding)ag);
        }
        this.addStatement(grounding, this.OWLS.Service.supportedBy, grounding.getService());
        if (isWSDL) {
            this.addStatement(grounding, RDF.type, this.OWLS.Grounding.WsdlGrounding);
        } else if (isUPnP) {
            this.addStatement(grounding, RDF.type, FLAServiceOnt.UPnPGrounding);
        }
    }

    private void writeWSDLGrounding(WSDLAtomicGrounding grounding) {
        this.addStatement(grounding, RDF.type, this.OWLS.Grounding.WsdlAtomicProcessGrounding);
        this.addStatement(grounding, this.OWLS.Grounding.wsdlDocument, grounding.getWSDL());
        this.addStatement(grounding, this.OWLS.Grounding.owlsProcess, grounding.getProcess());
        try {
            this.addStatement(grounding, this.OWLS.Grounding.wsdlInputMessage, grounding.getInputMessage());
            this.addStatement(grounding, this.OWLS.Grounding.wsdlOutputMessage, grounding.getOutputMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Resource opDesc = ResourceFactory.createResource();
        this.addStatement(grounding, this.OWLS.Grounding.wsdlOperation, opDesc);
        this.addStatement(opDesc, RDF.type, this.OWLS.Grounding.WsdlOperationRef);
        if (grounding.getPortType() != null) {
            this.addStatement(opDesc, this.OWLS.Grounding.portType, grounding.getPortType());
        }
        this.addStatement(opDesc, this.OWLS.Grounding.operation, grounding.getOperation());
        this.writeWSDLGroundingParams(grounding, true);
        this.writeWSDLGroundingParams(grounding, false);
    }

    private void writeWSDLGroundingParams(WSDLAtomicGrounding grounding, boolean writeInputs) {
        MessageMapList messageMapList = writeInputs ? grounding.getInputMap() : grounding.getOutputMap();
        if (messageMapList.size() == 0) {
            return;
        }
        RDFNode[] elements = new RDFNode[messageMapList.size()];
        int i = 0;
        while (i < messageMapList.size()) {
            MessageMap map = messageMapList.messageMapAt(i);
            Resource r = ResourceFactory.createResource();
            this.addStatement(r, RDF.type, this.OWLS.Grounding.wsdlMessageMap);
            this.addStatement(r, this.OWLS.Grounding.owlsParameter, map.getOWLSParameter());
            this.addStatement(r, this.OWLS.Grounding.wsdlMessagePart, map.getGroundingParameter());
            if (map.getTransformation() != null) {
                this.addStatement(r, this.OWLS.Grounding.xsltTransformation, this.toRDF(map.getTransformation(), true));
            }
            elements[i] = r;
            ++i;
        }
        RDFList list = this.model.createList(elements);
        if (writeInputs) {
            this.addStatement(grounding, this.OWLS.Grounding.wsdlInputMessageParts, list);
        } else {
            this.addStatement(grounding, this.OWLS.Grounding.wsdlOutputMessageParts, list);
        }
    }

    private void writeUPnPGrounding(UPnPAtomicGrounding grounding) {
        this.addStatement(grounding, RDF.type, FLAServiceOnt.UPnPAtomicProcessGrounding);
        this.addStatement(grounding, this.OWLS.Grounding.owlsProcess, grounding.getProcess());
        this.addStatement(grounding, FLAServiceOnt.upnpCommand, grounding.getUPnPAction());
        this.addStatement(grounding, FLAServiceOnt.upnpDeviceURL, grounding.getUPnPDescription());
        this.addStatement(grounding, FLAServiceOnt.upnpServiceID, grounding.getUPnPService());
        this.writeUPnPGroundingParams(grounding, true);
        this.writeUPnPGroundingParams(grounding, false);
    }

    private void writeUPnPGroundingParams(UPnPAtomicGrounding grounding, boolean writeInputs) {
        MessageMapList messageMapList = writeInputs ? grounding.getInputMap() : grounding.getOutputMap();
        if (messageMapList.size() == 0) {
            return;
        }
        RDFNode[] elements = new RDFNode[messageMapList.size()];
        int i = 0;
        while (i < messageMapList.size()) {
            MessageMap map = messageMapList.messageMapAt(i);
            Resource r = ResourceFactory.createResource();
            this.addStatement(r, RDF.type, FLAServiceOnt.UPnPMap);
            this.addStatement(r, this.OWLS.Grounding.owlsParameter, map.getOWLSParameter());
            this.addStatement(r, FLAServiceOnt.upnpParameter, map.getGroundingParameter());
            if (map.getTransformation() != null) {
                this.addStatement(r, this.OWLS.Grounding.xsltTransformation, this.toRDF(map.getTransformation(), true));
            }
            elements[i] = r;
            ++i;
        }
        RDFList list = this.model.createList(elements);
        if (writeInputs) {
            this.addStatement(grounding, FLAServiceOnt.UPnPInputMapping, list);
        } else {
            this.addStatement(grounding, FLAServiceOnt.UPnPOutputMapping, list);
        }
    }
}

