/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.Util;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.io.impl.OWLSReaderImpl;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Effect;
import org.mindswap.owls.process.EffectList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponent;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Unordered;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.jena.FLAServiceOnt;
import org.mindswap.owls.vocabulary.jena.OWLS_1_0;

public class OWLSReader_1_0
extends OWLSReaderImpl {
    public static boolean DEBUG = false;

    public OWLSReader_1_0() {
        this.version = "1.0";
    }

    protected List createService(URI fileURI, Model model) {
        StmtIterator si = model.listStatements(null, RDF.type, (RDFNode)OWLS_1_0.Service.Service);
        ArrayList<Service> list = new ArrayList<Service>();
        while (si.hasNext()) {
            Resource serviceInfo = si.nextStatement().getSubject();
            try {
                this.startService(serviceInfo.toString());
                Resource profileInfo = serviceInfo.getProperty(OWLS_1_0.Service.presents).getResource();
                Resource processModelInfo = serviceInfo.getProperty(OWLS_1_0.Service.describedBy).getResource();
                Resource groundingInfo = serviceInfo.getProperty(OWLS_1_0.Service.supports).getResource();
                Service service = OWLSFactory.createService(serviceInfo);
                service.setFileURI(fileURI);
                service.setOWLSVersion(this.version);
                this.createProcessModel(service, processModelInfo);
                this.createProfile(service, profileInfo);
                this.createGrounding(service, groundingInfo);
                if (!this.errorOccurred) {
                    list.add(service);
                }
                this.finishService(serviceInfo.toString());
            }
            catch (Exception e) {
                this.error("Invalid service description " + serviceInfo);
                e.printStackTrace();
            }
        }
        return list;
    }

    private void createProcessModel(Service service, Resource processModelInfo) {
        Resource processInfo = processModelInfo.getProperty(OWLS_1_0.Process.hasProcess).getResource();
        ProcessModel processModel = OWLSFactory.createProcessModel(processModelInfo);
        Process process = this.createProcess(service, processInfo);
        processModel.setProcess(process);
        processModel.setService(service);
    }

    private boolean isProcess(Resource processInfo) {
        return processInfo.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.AtomicProcess) || processInfo.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.CompositeProcess) || processInfo.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.SimpleProcess);
    }

    private Process createProcess(Service service, Resource processInfo) {
        if (!this.isProcess(processInfo)) {
            throw new RuntimeException("The process is neither atomic nor composite: " + processInfo.getURI());
        }
        Process process = null;
        if (processInfo.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.AtomicProcess)) {
            process = this.createAtomicProcess(service, processInfo);
        }
        if (processInfo.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Process.CompositeProcess)) {
            process = this.createCompositeProcess(service, processInfo);
        }
        if (process == null) {
            return null;
        }
        this.createProcessParams(process, true, processInfo);
        this.createProcessParams(process, false, processInfo);
        this.createConditions(process.getPreconditions(), processInfo.listProperties(OWLS_1_0.Profile.hasPrecondition));
        this.createEffects(process.getEffects(), processInfo.listProperties(OWLS_1_0.Profile.hasEffect));
        this.createDefaultValues(process.getDefaultValues(), processInfo);
        this.createDataFlow(process, processInfo);
        process.setService(service);
        return process;
    }

    private AtomicProcess createAtomicProcess(Service service, Resource processInfo) {
        AtomicProcess process = OWLSFactory.createAtomicProcess(processInfo);
        return process;
    }

    private CompositeProcess createCompositeProcess(Service service, Resource processInfo) {
        Statement stmt = processInfo.getProperty(OWLS_1_0.Process.composedOf);
        if (stmt == null) {
            this.error("Cannot find the components for composite process \n      process " + processInfo);
            return null;
        }
        Resource composedInfo = stmt.getResource();
        ControlConstruct controlConstruct = this.createControlConstruct(service, composedInfo);
        CompositeProcess process = OWLSFactory.createCompositeProcess(processInfo);
        process.setComposedOf(controlConstruct);
        return process;
    }

    private ProcessComponent createProcessComponent(Service service, Resource processComponentInfo) {
        ProcessComponent processComponent = null;
        processComponent = this.isProcess(processComponentInfo) ? this.createProcess(service, processComponentInfo) : this.createControlConstruct(service, processComponentInfo);
        return processComponent;
    }

    private ControlConstruct createControlConstruct(Service service, Resource controlConstructInfo) {
        Resource ccType = controlConstructInfo.getProperty(RDF.type).getResource();
        Resource componentsInfo = controlConstructInfo.getProperty(OWLS_1_0.Process.components).getResource();
        ControlConstruct cc = null;
        if (ccType.equals((Object)OWLS_1_0.Process.Sequence)) {
            cc = this.createSequence(service, componentsInfo);
        } else if (ccType.equals((Object)OWLS_1_0.Process.Choice)) {
            cc = this.createChoice(service, componentsInfo);
        } else if (ccType.equals((Object)OWLS_1_0.Process.Unordered)) {
            cc = this.createUnordered(service, componentsInfo);
        } else {
            this.error("Don't know how to read the control construct " + ccType);
        }
        return cc;
    }

    private Sequence createSequence(Service service, Resource sequenceInfo) {
        Sequence sequence = OWLSFactory.createSequence(sequenceInfo);
        this.createComponents(service, sequence, sequenceInfo);
        return sequence;
    }

    private Unordered createUnordered(Service service, Resource unorderedInfo) {
        Unordered unordered = OWLSFactory.createUnordered(unorderedInfo);
        this.createComponents(service, unordered, unorderedInfo);
        return unordered;
    }

    private Choice createChoice(Service service, Resource choiceInfo) {
        Choice choice = OWLSFactory.createChoice(choiceInfo);
        this.createComponents(service, choice, choiceInfo);
        return choice;
    }

    private void createComponents(Service service, ControlConstruct cc, Resource ccInfo) {
        List list = Util.createList(ccInfo);
        int i = 0;
        while (i < list.size()) {
            Resource processComponentInfo = (Resource)list.get(i);
            ProcessComponent processComponent = this.createProcessComponent(service, processComponentInfo);
            if (processComponent == null) {
                this.error("Invalid ProcessComponent description " + processComponentInfo);
            } else {
                cc.getComponents().add(processComponent);
            }
            ++i;
        }
    }

    private void createDefaultValues(ValueMap defaultValues, Resource processComponentInfo) {
    }

    private void createDataFlow(Process process, Resource processComponentInfo) {
        try {
            DataFlow dataFlow = process.getDataFlow();
            StmtIterator i = processComponentInfo.listProperties(OWLS_1_0.Process.sameValues);
            while (i.hasNext()) {
                Resource sameValuesList = i.nextStatement().getResource();
                Resource value1 = sameValuesList.getProperty(RDF.first).getResource();
                Resource value2 = sameValuesList.getProperty(RDF.rest).getResource().getProperty(RDF.first).getResource();
                Statement stmt = value1.getProperty(OWLS_1_0.Process.theProperty);
                Resource paramName1 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
                stmt = value1.getProperty(OWLS_1_0.Process.atClass);
                Resource processName1 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
                stmt = value2.getProperty(OWLS_1_0.Process.theProperty);
                Resource paramName2 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
                stmt = value2.getProperty(OWLS_1_0.Process.atClass);
                Resource processName2 = stmt.getObject() instanceof Resource ? stmt.getResource() : Util.toResource(stmt.getObject().toString());
                Process p1 = this.findProcess(process, Util.toURI(processName1));
                Process p2 = this.findProcess(process, Util.toURI(processName2));
                Parameter param1 = null;
                Parameter param2 = null;
                if (p1 == null) {
                    this.error("Cannot find the process data flow refers to \n      process " + processName1 + "\n    parameter " + paramName1 + "\n data flow in " + process.getURI());
                } else {
                    param1 = p1.getParameter(Util.toURI(paramName1));
                    if (param1 == null) {
                        this.error("Cannot find the parameter data flow refers to \n      process " + processName1 + "\n    parameter " + paramName1 + "\n data flow in " + process.getURI());
                    }
                }
                if (p2 == null) {
                    this.error("Cannot find the process data flow refers to \n      process " + processName2 + "\n    parameter " + paramName2 + "\n data flow in " + process.getURI());
                } else {
                    param2 = p2.getParameter(Util.toURI(paramName2));
                    if (param2 == null) {
                        this.error("Cannot find the parameter data flow refers to \n      process " + processName2 + "\n    parameter " + paramName2 + "\n data flow in " + process.getURI());
                    }
                }
                if (param1 == null || param2 == null) continue;
                DataFlowElement dfe = OWLSFactory.createDataFlowElement();
                dfe.add(param1);
                dfe.add(param2);
                dataFlow.add(dfe);
            }
        }
        catch (Exception e) {
            this.error("Invalid data flow specification");
        }
    }

    private void createProcessParams(Process process, boolean isInput, Resource processInfo) {
        Property prop = isInput ? OWLS_1_0.Process.hasInput : OWLS_1_0.Process.hasOutput;
        StmtIterator i = processInfo.listProperties(prop);
        while (i.hasNext()) {
            Resource p = i.nextStatement().getResource();
            Parameter param = null;
            if (isInput) {
                param = OWLSFactory.createInput(p);
                process.getInputs().add(param);
            } else {
                param = OWLSFactory.createOutput(p);
                process.getOutputs().add(param);
            }
            param.setProcess(process);
            if (p.hasProperty(OWLS_1_0.Process.parameterType)) {
                param.setType(OWLSFactory.createOWLResource(p.getProperty(OWLS_1_0.Process.parameterType).getResource()));
            } else {
                this.error("Cannot find the type for the process parameter \n      process " + process + "\n    parameter " + param);
            }
            if (!DEBUG) continue;
            System.out.println("  Process   " + process.getURI() + "\n" + (isInput ? "  Input     " : "  Output    ") + param.getLabel() + "\n" + "  Type      " + param.getType() + "\n");
        }
    }

    private void createProfile(Service service, Resource profileInfo) {
        try {
            Profile profile = OWLSFactory.createProfile(profileInfo);
            Process process = service.getProcess();
            this.createProfileParams(profile, process, true, profileInfo);
            this.createProfileParams(profile, process, false, profileInfo);
            this.createConditions(profile.getPreconditions(), profileInfo.listProperties(OWLS_1_0.Profile.hasPrecondition));
            this.createEffects(profile.getEffects(), profileInfo.listProperties(OWLS_1_0.Profile.hasEffect));
            profile.setType(Util.toURI(profileInfo.getProperty(RDF.type).getResource()));
            this.copyPropertyValues(profileInfo, OWLS_1_0.Profile.serviceName, RDFS.label);
            profile.setService(service);
        }
        catch (RuntimeException e) {
            this.error("Invalid profile description");
            e.printStackTrace();
        }
    }

    private void createProfileParams(Profile profile, Process process, boolean isInput, Resource profileInfo) {
        Property prop = isInput ? OWLS_1_0.Profile.hasInput : OWLS_1_0.Profile.hasOutput;
        StmtIterator i = profileInfo.getModel().listStatements(profileInfo, prop, null);
        while (i.hasNext()) {
            Resource p = (Resource)i.nextStatement().getObject();
            String paramURI = p.getURI();
            Parameter refersTo = process.getParameter(URI.create(paramURI));
            if (refersTo == null) {
                this.error("The parameter defined in profile does not exist in the process \n    parameter " + paramURI + "\n   in profile " + profile.getURI() + "\n      process " + process.getURI());
                continue;
            }
            if (isInput) {
                profile.getInputs().add(refersTo);
            } else {
                profile.getOutputs().add(refersTo);
            }
            if (!DEBUG) continue;
            System.out.println("  Profile   " + profile.getURI() + "\n" + (isInput ? "  Input     " : "  Output    ") + paramURI + "\n" + "  Refers to " + refersTo + "\n");
        }
    }

    private void createConditions(ConditionList conds, StmtIterator i) {
        while (i.hasNext()) {
            Resource p = (Resource)i.nextStatement().getObject();
            conds.add(this.createCondition(p));
        }
    }

    private void createEffects(EffectList effects, StmtIterator i) {
        while (i.hasNext()) {
            Resource p = (Resource)i.nextStatement().getObject();
            effects.add(this.createEffect(p));
        }
    }

    private Condition createCondition(Resource condition) {
        Condition cond = OWLSFactory.createCondition(condition);
        return cond;
    }

    private Effect createEffect(Resource effect) {
        Effect eff = OWLSFactory.createEffect(effect);
        return eff;
    }

    private void createGrounding(Service service, Resource groundingInfo) {
        AtomicGrounding apGrounding;
        Resource apGroundingInfo;
        Grounding grounding = OWLSFactory.createGrounding(groundingInfo);
        StmtIterator i = groundingInfo.listProperties(OWLS_1_0.Grounding.hasAtomicProcessGrounding);
        while (i.hasNext()) {
            apGroundingInfo = i.nextStatement().getResource();
            apGrounding = this.createAPGrounding(service, apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            this.error("Invalid AtomicProcess grounding " + apGroundingInfo);
        }
        i = groundingInfo.listProperties(FLAServiceOnt.hasUPnPAtomicProcessGrounding);
        while (i.hasNext()) {
            apGroundingInfo = i.nextStatement().getResource();
            apGrounding = this.createAPGrounding(service, apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            this.error("Invalid AtomicProcess grounding " + apGroundingInfo);
        }
        grounding.setService(service);
    }

    private AtomicGrounding createAPGrounding(Service service, Resource groundingInfo) {
        try {
            if (groundingInfo.hasProperty(RDF.type, (RDFNode)OWLS_1_0.Grounding.WsdlAtomicProcessGrounding)) {
                return this.createWSDLGrounding(service, groundingInfo);
            }
            if (groundingInfo.hasProperty(RDF.type, (RDFNode)FLAServiceOnt.UPnPAtomicProcessGrounding)) {
                return this.createUPnPGrounding(service, groundingInfo);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return null;
    }

    private AtomicGrounding createWSDLGrounding(Service service, Resource groundingInfo) {
        URI processURI = Util.toURI(groundingInfo.getProperty(OWLS_1_0.Grounding.damlsProcess).getResource());
        Resource operationInfo = groundingInfo.getProperty(OWLS_1_0.Grounding.wsdlOperation).getResource();
        String wsdlLoc = groundingInfo.getProperty(OWLS_1_0.Grounding.wsdlDocument).getObject().toString();
        String opName = operationInfo.getProperty(OWLS_1_0.Grounding.operation).getObject().toString();
        String portType = operationInfo.getProperty(OWLS_1_0.Grounding.portType).getObject().toString();
        AtomicProcess process = (AtomicProcess)this.findProcess(service.getProcess(), processURI);
        if (process == null) {
            this.error("The process specified in the grounding cannot be found \n    grounding " + groundingInfo + "\n      process " + processURI);
            return null;
        }
        WSDLAtomicGrounding g = OWLSFactory.createWSDLAtomicGrounding(groundingInfo);
        g.setProcess(process);
        g.setWSDL(wsdlLoc);
        g.setOperation(opName);
        g.setPortType(portType);
        if (groundingInfo.hasProperty(OWLS_1_0.Grounding.wsdlInputMessage)) {
            g.setInputMessage(groundingInfo.getProperty(OWLS_1_0.Grounding.wsdlInputMessage).getObject().toString());
        }
        if (groundingInfo.hasProperty(OWLS_1_0.Grounding.wsdlOutputMessage)) {
            g.setOutputMessage(groundingInfo.getProperty(OWLS_1_0.Grounding.wsdlOutputMessage).getObject().toString());
        }
        this.createMessageMapList(g, groundingInfo, true);
        this.createMessageMapList(g, groundingInfo, false);
        if (DEBUG) {
            System.out.println("  Process   " + process.getURI() + "\n" + "  WSDL file " + wsdlLoc + "\n" + "  Operation " + opName + "\n");
        }
        return g;
    }

    private AtomicGrounding createUPnPGrounding(Service service, Resource groundingInfo) {
        URI processURI = Util.toURI(groundingInfo.getProperty(OWLS_1_0.Grounding.damlsProcess).getResource());
        String upnpDevice = groundingInfo.getProperty(FLAServiceOnt.upnpDeviceURL).getObject().toString();
        String upnpService = groundingInfo.getProperty(FLAServiceOnt.upnpServiceID).getObject().toString();
        String upnpAction = groundingInfo.getProperty(FLAServiceOnt.upnpCommand).getObject().toString();
        AtomicProcess process = (AtomicProcess)this.findProcess(service.getProcess(), processURI);
        UPnPAtomicGrounding g = OWLSFactory.createUPnPAtomicGrounding(groundingInfo);
        g.setProcess(process);
        g.setUPnPDescription(upnpDevice);
        g.setUPnPService(upnpService);
        g.setUPnPAction(upnpAction);
        this.createMessageMapList(g, groundingInfo, true);
        this.createMessageMapList(g, groundingInfo, false);
        if (DEBUG) {
            System.out.println("  Process " + process.getURI() + "\n" + "  Device  " + upnpDevice + "\n" + "  Service " + upnpService + "\n" + "  Action  " + upnpAction + "\n");
        }
        return g;
    }

    private void createMessageMapList(AtomicGrounding g, Resource groundingInfo, boolean isInput) {
        AtomicProcess process = g.getProcess();
        Property messageParts = null;
        Property messagePart = null;
        if (g instanceof UPnPAtomicGrounding) {
            messageParts = isInput ? FLAServiceOnt.UPnPInputMapping : FLAServiceOnt.UPnPOutputMapping;
            messagePart = FLAServiceOnt.upnpParameter;
        } else if (g instanceof WSDLAtomicGrounding) {
            messageParts = isInput ? OWLS_1_0.Grounding.wsdlInputMessageParts : OWLS_1_0.Grounding.wsdlOutputMessageParts;
            messagePart = OWLS_1_0.Grounding.wsdlMessagePart;
        }
        if (!groundingInfo.hasProperty(messageParts)) {
            return;
        }
        Resource messageMapInfo = (Resource)groundingInfo.getProperty(messageParts).getObject();
        List messageMapList = Util.createList(messageMapInfo);
        MessageMapList mapList = isInput ? g.getInputMap() : g.getOutputMap();
        int i = 0;
        while (i < messageMapList.size()) {
            Resource messageMap = (Resource)messageMapList.get(i);
            MessageMap map = OWLSFactory.createMessageMap(messageMap);
            URI owlsParameterInfo = Util.toURI(messageMap.getProperty(OWLS_1_0.Grounding.damlsParameter).getResource());
            Parameter owlsParameter = isInput ? process.getInputs().getParameter(owlsParameterInfo) : process.getOutputs().getParameter(owlsParameterInfo);
            map.setOWLSParameter(owlsParameter);
            String wsdlMessagePartInfo = messageMap.getProperty(messagePart).getObject().toString();
            map.setGroundingParameter(wsdlMessagePartInfo);
            String transformation = null;
            if (messageMap.hasProperty(OWLS_1_0.Grounding.xsltTranformation)) {
                transformation = messageMap.getProperty(OWLS_1_0.Grounding.xsltTranformation).getString();
                map.setTransformation(transformation);
            }
            if (owlsParameter == null) {
                this.error("Cannot find the target of message map for \n   wsdl parameter " + wsdlMessagePartInfo + "\n       in process " + process.getURI() + "\n        mapped to " + owlsParameterInfo);
            }
            if (DEBUG) {
                System.out.println("  Process   " + process.getURI() + "\n" + "  Param     " + owlsParameterInfo + "\n" + "  Grounding " + wsdlMessagePartInfo + "\n" + "  Transform " + transformation + "\n");
            }
            mapList.add(map);
            ++i;
        }
    }

    private Process findProcess(ProcessComponent process, URI processURI) {
        if (process == null) {
            return null;
        }
        if (process.getURI() != null && process.getURI().equals(processURI)) {
            if (process instanceof Process) {
                return (Process)process;
            }
        } else {
            if (process instanceof CompositeProcess) {
                return this.findProcess(((CompositeProcess)process).getComposedOf(), processURI);
            }
            if (process instanceof ControlConstruct) {
                ProcessComponentList list = ((ControlConstruct)process).getComponents();
                int i = 0;
                while (i < list.size()) {
                    ProcessComponent pc = list.processComponentAt(i);
                    Process p = this.findProcess(pc, processURI);
                    if (p != null) {
                        return p;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private void copyPropertyValues(Resource subj, Property srcProp, Property targetProp) {
        ArrayList<RDFNode> values = new ArrayList<RDFNode>();
        StmtIterator si = subj.listProperties(srcProp);
        while (si.hasNext()) {
            values.add(si.nextStatement().getObject());
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            subj.addProperty(targetProp, (RDFNode)i.next());
        }
    }
}

