/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.grounding.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.owl.Util;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.impl.AtomicGroundingImpl;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;

public class WSDLAtomicGroundingImpl
extends AtomicGroundingImpl
implements WSDLAtomicGrounding {
    protected String wsdlLoc;
    protected String operation;
    protected String portType;
    protected String inputMessage;
    protected String outputMessage;

    public WSDLAtomicGroundingImpl(Resource resource) {
        super(resource);
    }

    public void setWSDL(String wsdlLoc) {
        this.wsdlLoc = wsdlLoc;
    }

    public String getWSDL() {
        return this.wsdlLoc;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setPortType(String port) {
        this.portType = port;
    }

    public String getPortType() {
        return this.portType;
    }

    public ValueMap invoke(ValueMap values) {
        ValueMap results = OWLSFactory.createValueMap();
        WSDLService s = WSDLService.createService(this.wsdlLoc);
        WSDLOperation op = s.getOperation(this.operation);
        if (op == null) {
            op = s.getOperation(Util.getLocalName(this.operation));
        }
        int i = 0;
        while (i < op.getInputs().size()) {
            Object value;
            WSDLParameter in = op.getInput(i);
            MessageMap mp = this.getInputMap().getMessageMap(in.getName());
            Parameter param = mp.getOWLSParameter();
            Object inputValue = value = values.getValue(param);
            if (mp.getTransformation() != null) {
                value = XSLTEngine.transform(value.toString(), mp.getTransformation());
                inputValue = Utils.getAsNode(value.toString());
            }
            in.setValue(value);
            ++i;
        }
        boolean success = op.invoke();
        int i2 = 0;
        while (i2 < op.getOutputs().size()) {
            WSDLParameter out = op.getOutput(i2);
            MessageMap mp = this.getOutputMap().getMessageMap(out.getName());
            Parameter param = mp.getOWLSParameter();
            Object outputValue = null;
            outputValue = mp.getTransformation() == null ? out.getValue() : XSLTEngine.transform(out.getValue().toString(), mp.getTransformation());
            results.setValue(param, outputValue);
            ++i2;
        }
        return results;
    }

    public String getDescriptionURL() {
        return this.getWSDL();
    }

    public String getInputMessage() {
        return this.inputMessage;
    }

    public void setInputMessage(String inputMessage) {
        this.inputMessage = inputMessage;
    }

    public String getOutputMessage() {
        return this.outputMessage;
    }

    public void setOutputMessage(String outputMessage) {
        this.outputMessage = outputMessage;
    }
}

