/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.examples;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.io.OWLSReader;
import org.mindswap.owls.io.OWLSWriter;
import org.mindswap.owls.service.Service;

public class OWLSVersionTranslator {
    public void translate(String fileURI, String version) throws Exception {
        this.translate(fileURI, version, new OutputStreamWriter(System.out));
    }

    public void translate(String fileURI, String version, Writer out) throws Exception {
        URI uri = new URI(fileURI);
        OWLSReader reader = OWLSFactory.createOWLSReader();
        OWLSWriter writer = OWLSFactory.createOWLSWriter(version);
        Service service = reader.read(uri);
        if (service != null) {
            writer.write(service, out);
        } else {
            out.write("ERROR: Invalid service description");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            if (args.length < 2) {
                System.err.println("Not enough parameters");
            }
            if (args.length > 2) {
                System.err.println("Too many parameters");
            }
            System.err.println("usage: java OWLSVersionTranslator <serviceURI> <outputVersion>");
            System.exit(0);
        }
        OWLSVersionTranslator translator = new OWLSVersionTranslator();
        translator.translate(args[0], args[1]);
    }
}

