/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLResource;
import org.mindswap.owl.Util;
import org.mindswap.owl.vocabulary.RDFS;

public class OWLResourceImpl
implements OWLResource {
    Resource resource;

    public OWLResourceImpl(Resource resource) {
        this.resource = resource == null ? ResourceFactory.createResource() : resource;
    }

    public boolean isAnon() {
        return this.resource.isAnon();
    }

    public URI getURI() {
        if (this.isAnon()) {
            return null;
        }
        return Util.toURI(this.resource);
    }

    public String getLabel() {
        return this.getProperty(RDFS.label);
    }

    public String getLabel(String lang) {
        return this.getProperty(RDFS.label, lang);
    }

    public String getProperty(URI propURI) {
        String value = null;
        int i = 0;
        while (value == null && i < OWLConfig.DEFAULT_LANGS.length) {
            value = this.getProperty(propURI, OWLConfig.DEFAULT_LANGS[i]);
            ++i;
        }
        return value;
    }

    public String getProperty(URI propURI, String lang) {
        try {
            Property prop = Util.toProperty(propURI);
            return this.getProperty(prop, lang).getLexicalForm();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Literal getProperty(Property prop, String lang) {
        try {
            StmtIterator i = this.resource.listProperties(prop);
            while (i.hasNext()) {
                RDFNode node = i.nextStatement().getObject();
                if (!(node instanceof Literal)) continue;
                Literal literal = (Literal)node;
                if (lang == null) {
                    return literal;
                }
                if (!lang.equals(literal.getLanguage())) continue;
                return literal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void removeProperty(Property prop, String lang) {
        try {
            StmtIterator i = this.resource.listProperties(prop);
            while (i.hasNext()) {
                RDFNode node = i.nextStatement().getObject();
                if (!(node instanceof Literal)) continue;
                Literal literal = (Literal)node;
                if (lang == null) {
                    i.remove();
                    continue;
                }
                if (!lang.equals(literal.getLanguage())) continue;
                i.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (o instanceof OWLResourceImpl) {
            return this.resource.equals((Object)((OWLResourceImpl)o).resource);
        }
        return false;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public String debugString() {
        return this.toString();
    }

    public void setLabel(String label) {
        this.setProperty(RDFS.label, label);
    }

    public void setLabel(String label, String lang) {
        this.setProperty(RDFS.label, label, lang);
    }

    public String toString() {
        String value = this.getLabel();
        if (value == null) {
            value = this.isAnon() ? "Anonymous (" + this.resource + ")" : this.getURI().getFragment();
        }
        return value;
    }

    public Resource getJenaResource() {
        return this.resource;
    }

    public void setProperty(URI propURI, String value) {
        this.setProperty(propURI, value, "");
    }

    public void setProperty(URI propURI, String value, String lang) {
        this.removeProperty(Util.toProperty(propURI), lang);
        Literal literal = this.resource.getModel().createLiteral(value, lang);
        this.resource.addProperty(Util.toProperty(propURI), (RDFNode)literal);
    }
}

