/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.mindswap.owl.OWLCache;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.Util;
import org.mindswap.owl.vocabulary.OWL;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owl.vocabulary.RDFS;

public class OWLReaderImpl
implements OWLReader {
    private static String UNKNOWN_URI = "http://unknown/uri";
    private static Hashtable modelCache = new Hashtable();
    private static Hashtable modelNames = new Hashtable();
    private static Set ignoreImports = new HashSet();

    public OWLReaderImpl() {
        this.addLoaded(ignoreImports, OWL.getURI());
        this.addLoaded(ignoreImports, RDF.getURI());
        this.addLoaded(ignoreImports, RDFS.getURI());
    }

    public URI standardURI(URI uri) {
        if (!uri.toString().endsWith("#")) {
            uri = URI.create(String.valueOf(uri.toString()) + "#");
        }
        return uri;
    }

    public void addLoaded(Set loadedFiles, URI file) {
        file = this.standardURI(file);
        loadedFiles.add(file);
    }

    public boolean isLoaded(Set loadedFiles, URI file) {
        return loadedFiles.contains(file = this.standardURI(file)) || ignoreImports.contains(file);
    }

    private void readFile(List models, Set loadedFiles, URI uri, boolean withImports) {
        if (this.isLoaded(loadedFiles, uri)) {
            return;
        }
        this.addLoaded(loadedFiles, uri);
        Model model = (Model)modelCache.get(uri);
        if (model == null) {
            model = ModelFactory.createDefaultModel();
            try {
                InputStream in = this.createInputStream(uri);
                model.read(in, uri.toString());
                in.close();
                modelNames.put(model, uri);
                modelCache.put(uri, model);
            }
            catch (Exception e) {
                System.err.println("WARNING: The import file " + uri + " cannot be parsed");
                System.err.println(e);
            }
        }
        models.add(model);
        if (withImports) {
            Vector imports = new Vector();
            StmtIterator i = model.listStatements(null, Util.toProperty(OWL.imports), null);
            while (i.hasNext()) {
                Statement stmt = i.nextStatement();
                String importFile = stmt.getResource().toString();
                try {
                    this.readFile(models, loadedFiles, new URI(importFile), withImports);
                }
                catch (URISyntaxException e) {
                    System.err.println("WARNING: The import file is not a valid URI: " + importFile);
                }
            }
        }
    }

    public Model[] readSeparate(URI url) throws Exception {
        ArrayList models = new ArrayList();
        HashSet loadedFiles = new HashSet();
        this.readFile(models, loadedFiles, url, true);
        return models.toArray(new Model[models.size()]);
    }

    private Model readSingle(URI url) throws Exception {
        ArrayList models = new ArrayList();
        HashSet loadedFiles = new HashSet();
        this.readFile(models, loadedFiles, url, false);
        return (Model)models.get(0);
    }

    public URI getModelURI(Model model) {
        return (URI)modelNames.get(model);
    }

    private Model mergeAll(Model[] models) {
        Model model = ModelFactory.createDefaultModel();
        int i = 0;
        while (i < models.length) {
            model.add(models[i], false);
            ++i;
        }
        return model;
    }

    private InputStream createInputStream(URI uri) throws Exception {
        InputStream in;
        block2: {
            in = null;
            try {
                in = uri.toURL().openConnection().getInputStream();
            }
            catch (Exception e) {
                System.out.println("WARNING: Cannot get file " + uri);
                File cachedFile = OWLCache.getCachedFile(uri.toString());
                if (cachedFile == null) break block2;
                System.out.println("WARNING: Try cached file " + cachedFile);
                in = new FileInputStream(cachedFile);
            }
        }
        return in;
    }

    public Model read(URI uri) throws Exception {
        return this.read(uri, true);
    }

    public Model read(URI uri, boolean withImports) throws Exception {
        Model model = null;
        model = withImports ? this.mergeAll(this.readSeparate(uri)) : this.readSingle(uri);
        return model;
    }

    public List getImports(URI uri) {
        ArrayList<URI> imports = new ArrayList<URI>();
        Model[] models = null;
        try {
            models = this.readSeparate(uri);
        }
        catch (Exception e) {
            return null;
        }
        int i = 0;
        while (i < models.length) {
            imports.add(this.getModelURI(models[i]));
            ++i;
        }
        return imports;
    }

    public Map getNameSpaces(URI uri) {
        Model model = null;
        try {
            model = this.read(uri, false);
        }
        catch (Exception e) {
            return null;
        }
        return model.getNsPrefixMap();
    }
}

