/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.util.HashMap;
import java.util.Map;

public class MathInstruction
extends Instruction {
    private static final Map _typeNames = new HashMap();
    private Class _type = null;
    private int _operation = -1;

    public MathInstruction setOperation(int n) {
        this._operation = n;
        this.calculateOpCode();
        return this;
    }

    public int getOperation() {
        return this._operation;
    }

    public Class getType() {
        return this._type;
    }

    public MathInstruction setType(Class clazz) {
        this._type = Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz) || Long.TYPE.equals(clazz) ? clazz : Integer.TYPE;
        this.calculateOpCode();
        return this;
    }

    public MathInstruction setTypeName(String string) {
        this._type = (Class)_typeNames.get(string);
        if (this._type == null && string != null) {
            this._type = Integer.TYPE;
        }
        this.calculateOpCode();
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MathInstruction)) {
            return false;
        }
        MathInstruction mathInstruction = (MathInstruction)object;
        boolean bl = this._operation == -1 || mathInstruction._operation == -1 || this._operation == mathInstruction._operation;
        boolean bl2 = this._type == null || mathInstruction._type == null || this._type.equals(mathInstruction._type);
        return bl && bl2;
    }

    public int getStackChange() {
        if (this._operation == 116) {
            return 0;
        }
        if (this._type.equals(Long.TYPE) || this._type.equals(Double.TYPE)) {
            return -2;
        }
        return -1;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        MathInstruction mathInstruction = (MathInstruction)instruction;
        this._type = mathInstruction._type;
        this._operation = mathInstruction._operation;
    }

    private void calculateOpCode() {
        this._opcode = this._operation + Instruction._opcodeTypes.indexOf(this._type);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterMathInstruction(this);
        bCVisitor.exitMathInstruction(this);
    }

    protected MathInstruction(Code code) {
        super(code);
    }

    protected MathInstruction(Code code, int n, int n2, Class clazz) {
        super(code);
        this._opcode = n;
        this._operation = n2;
        this._type = clazz;
    }

    static {
        _typeNames.put("long", Long.TYPE);
        _typeNames.put("float", Float.TYPE);
        _typeNames.put("double", Double.TYPE);
    }
}

