/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.BCHelper;
import com.techtrader.modules.tools.bytecode.LocalVariableTableAttribute;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariable {
    private int _startPc = 0;
    private int _length = 0;
    private int _nameIndex = 0;
    private int _descriptorIndex = 0;
    private int _index = 0;
    private LocalVariableTableAttribute _owner = null;

    protected void invalidate() {
        this._owner = null;
    }

    public LocalVariableTableAttribute getOwner() {
        return this._owner;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public int getStartPc() {
        return this._startPc;
    }

    public void setStartPc(int n) {
        this._startPc = n;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int n) {
        this._length = n;
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        this._nameIndex = n;
    }

    public String getName() {
        return this._owner.getPool().getUTF(this._nameIndex);
    }

    public void setName(String string) {
        this._nameIndex = this._owner.getPool().setUTF(0, string);
    }

    public int getDescriptorIndex() {
        return this._descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        this._descriptorIndex = n;
    }

    public String getTypeName() {
        return BCHelper.getExternalForm(this._owner.getPool().getUTF(this._descriptorIndex), true);
    }

    public void setTypeName(String string) {
        this._descriptorIndex = this._owner.getPool().setUTF(0, BCHelper.getInternalForm(string, true));
    }

    public Class getType() throws ClassNotFoundException {
        return BCHelper.classForName(this._owner.getPool().getUTF(this._descriptorIndex));
    }

    public void setType(Class clazz) {
        this.setTypeName(clazz.getName());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this.setStartPc(dataInput.readUnsignedShort());
        this.setLength(dataInput.readUnsignedShort());
        this.setNameIndex(dataInput.readUnsignedShort());
        this.setDescriptorIndex(dataInput.readUnsignedShort());
        this.setIndex(dataInput.readUnsignedShort());
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getStartPc());
        dataOutput.writeShort(this.getLength());
        dataOutput.writeShort(this.getNameIndex());
        dataOutput.writeShort(this.getDescriptorIndex());
        dataOutput.writeShort(this.getIndex());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLocalVariable(this);
        bCVisitor.exitLocalVariable(this);
    }

    protected LocalVariable(LocalVariableTableAttribute localVariableTableAttribute) {
        this._owner = localVariableTableAttribute;
    }
}

