/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.InheritanceTree;
import ix.util.xml.LiteralDocument;
import ix.util.xml.XML;
import ix.util.xml.XMLSchemaSyntax;
import ix.util.xml.XMLSyntax;
import ix.util.xml.XMLTranslator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class RelaxNGSyntax
extends XMLSyntax {
    Schema theSchema = null;
    public static final Namespace relaxNGNamespace = Namespace.getNamespace((String)"", (String)"http://relaxng.org/ns/structure/1.0");

    public RelaxNGSyntax() {
    }

    public RelaxNGSyntax(XMLTranslator xMLTranslator) {
        super(xMLTranslator);
    }

    public Schema makeSchema(Class clazz) {
        return this.makeSchema(clazz, XML.config().xmlSyntaxClasses(this.classSyntax, clazz));
    }

    Schema makeSchema(Class clazz, List list) {
        Schema schema;
        this.theSchema = schema = new Schema();
        this.inheritance = new InheritanceTree(list);
        schema.addContent((Content)this.makeRngElement("start").addContent((Content)this.makeRef(clazz)));
        schema.addContent((Content)this.objectPatternDefinition(list));
        schema.addContent((Content)this.listPatternDefinition());
        schema.addContent((Content)this.mapPatternDefinition());
        for (Class clazz2 : list) {
            this.addClassSyntax(schema, clazz2);
        }
        return schema;
    }

    Element objectPatternDefinition(List list) {
        Debug.expect(!list.contains(Object.class));
        LinkedList<Class> linkedList = new LinkedList<Class>(list);
        linkedList.add(0, List.class);
        linkedList.add(1, Map.class);
        return this.makeDef(Object.class).addContent((Content)this.makeRngElement("choice").setContent((Collection)this.classRefs(linkedList)));
    }

    Element listPatternDefinition() {
        return this.makeDef(List.class).addContent((Content)this.listofPattern(Object.class));
    }

    Element mapPatternDefinition() {
        return this.makeDef(Map.class).addContent((Content)this.makeElementElement("map").addContent((Content)this.makeRngElement("zeroOrMore").addContent((Content)this.mapEntryPattern())));
    }

    Element mapEntryPattern() {
        return this.makeElementElement("map-entry").addContent((Content)this.makeElementElement("key").addContent((Content)this.makeRef(Object.class))).addContent((Content)this.makeElementElement("value").addContent((Content)this.makeRef(Object.class)));
    }

    void addClassSyntax(Schema schema, Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        schema.addComment(classDescr.getExternalName());
        if (classDescr.isStruct()) {
            this.addStructSyntax(schema, clazz);
        } else if (classDescr.isEnumeration()) {
            this.addEnumerationSyntax(schema, clazz);
        } else if (classDescr.isPrimitive()) {
            this.addPrimitiveSyntax(schema, clazz);
        } else if (classDescr.isXML()) {
            this.addLiteralDocumentSyntax(schema, clazz);
        } else {
            schema.addContent((Content)new Comment("No syntax for " + clazz));
        }
    }

    String valueName(Class clazz) {
        return this.getElementName(clazz) + "-value";
    }

    String patternName(Class clazz) {
        return this.getElementName(clazz);
    }

    void addStructSyntax(Schema schema, Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        if (classDescr.isAbstract()) {
            schema.addContent((Content)this.inheritancePatternDefinition(clazz));
        } else {
            schema.addContent((Content)this.structPatternDefinition(clazz));
        }
    }

    Element inheritancePatternDefinition(Class clazz) {
        List list = this.inheritance.getSubclasses(clazz);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Abstract class without subclasses: " + clazz.getName());
        }
        return this.makeDef(clazz).addContent((Content)this.makeRngElement("choice").setContent((Collection)this.classRefs(list)));
    }

    List classRefs(List list) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (Class clazz : list) {
            linkedList.add(this.makeRef(clazz));
        }
        return linkedList;
    }

    Element structPatternDefinition(Class clazz) {
        return this.makeDef(clazz).addContent((Content)this.makeElementElement(this.getElementName(clazz)).setContent((Collection)this.structContent(clazz)));
    }

    List structContent(Class clazz) {
        LinkedList<Element> linkedList3;
        ClassDescr classDescr = this.getClassDescr(clazz);
        List list = classDescr.getFieldDescrs();
        List list2 = this.attributeFields(list);
        List list3 = this.elementFields(list);
        Debug.expect(list.size() == list2.size() + list3.size());
        LinkedList<Element> linkedList2 = new LinkedList<Element>();
        for (LinkedList<Element> linkedList3 : list2) {
            linkedList2.add(this.optionalPattern(this.attributeFieldPattern((FieldDescr)((Object)linkedList3))));
        }
        LinkedList linkedList4 = new LinkedList();
        for (FieldDescr fieldDescr : list3) {
            linkedList4.add(this.optionalPattern(this.elementFieldPattern(fieldDescr)));
        }
        linkedList3 = new LinkedList<Element>();
        if (!linkedList2.isEmpty()) {
            linkedList3.addAll(linkedList2);
        }
        if (!linkedList4.isEmpty()) {
            linkedList3.add(this.makeRngElement("interleave").setContent((Collection)linkedList4));
        }
        return linkedList3;
    }

    Element optionalPattern(Element element) {
        return this.makeRngElement("optional").addContent((Content)element);
    }

    Element attributeFieldPattern(FieldDescr fieldDescr) {
        return this.makeAttributeElement(this.getElementName(fieldDescr)).addContent((Content)this.makeRef(this.valueName(fieldDescr.getType())));
    }

    Element elementFieldPattern(FieldDescr fieldDescr) {
        return this.makeElementElement(this.getElementName(fieldDescr)).addContent((Content)this.fieldValuePattern(fieldDescr));
    }

    Element fieldValuePattern(FieldDescr fieldDescr) {
        Class clazz = fieldDescr.getType();
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        if (classDescr.isList()) {
            ClassDescr classDescr2 = classDescr.getEltType();
            if (classDescr2 == null) {
                return this.makeRef(List.class);
            }
            return this.listofPattern(classDescr2.theClass);
        }
        if (classDescr.isSet()) {
            Debug.expect(false, "Can't handle Set values");
            return null;
        }
        if (classDescr.isMap()) {
            return this.makeRef(Map.class);
        }
        return this.makeRef(clazz);
    }

    Element listofPattern(Class clazz) {
        return this.makeElementElement("list").addContent((Content)this.makeRngElement("zeroOrMore").addContent((Content)this.makeRef(clazz)));
    }

    void addEnumerationSyntax(Schema schema, Class clazz) {
        schema.addContent((Content)this.elementRefDefinition(clazz, this.valueName(clazz)));
        schema.addContent((Content)this.enumValueDefinition(clazz));
    }

    Element elementRefDefinition(Class clazz, String string) {
        return this.makeDef(clazz).addContent((Content)this.makeElementElement(this.getElementName(clazz)).addContent((Content)this.makeRef(string)));
    }

    Element enumValueDefinition(Class clazz) {
        return this.makeDef(this.valueName(clazz)).addContent((Content)this.makeRngElement("choice").setContent((Collection)this.enumValueElements(clazz)));
    }

    List enumValueElements(Class clazz) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        Iterator iterator = this.getEnumerationValues(clazz).iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.makeRngElement("value").setText(iterator.next().toString()));
        }
        return linkedList;
    }

    void addPrimitiveSyntax(Schema schema, Class clazz) {
        schema.addContent((Content)this.elementRefDefinition(clazz, this.valueName(clazz)));
        if (clazz == String.class) {
            schema.addContent((Content)this.textValueDefinition(clazz));
        } else {
            schema.addContent((Content)this.dataValueDefinition(clazz));
        }
    }

    Element textValueDefinition(Class clazz) {
        return this.makeDef(this.valueName(clazz)).addContent((Content)this.makeRngElement("text"));
    }

    Element dataValueDefinition(Class clazz) {
        String string = XMLSchemaSyntax.getSimpleType(clazz);
        return this.makeDef(this.valueName(clazz)).addContent((Content)this.makeRngElement("data").setAttribute("type", string));
    }

    void addLiteralDocumentSyntax(Schema schema, Class clazz) {
        schema.addContent((Content)this.literalDocumentPatternDefinition());
        schema.addContent((Content)this.anyXMLPatternDefinition());
    }

    Element literalDocumentPatternDefinition() {
        String string = this.getElementName(LiteralDocument.class);
        return this.makeDef(LiteralDocument.class).addContent((Content)this.makeElementElement(string).addContent((Content)this.makeRef("anyXML")));
    }

    Element anyXMLPatternDefinition() {
        return this.makeDef("anyXML").addContent((Content)this.anyXMLPattern());
    }

    Element anyXMLPattern() {
        return this.makeRngElement("element").addContent((Content)this.makeRngElement("anyName")).addContent((Content)this.makeRngElement("zeroOrMore").addContent((Content)this.makeRngElement("choice").addContent((Content)this.makeRngElement("attribute").addContent((Content)this.makeRngElement("anyName"))).addContent((Content)this.makeRngElement("text")).addContent((Content)this.makeRef("anyXML"))));
    }

    Element makeElement(String string, Namespace namespace, String[][] stringArray) {
        Element element = new Element(string, namespace);
        XML.setAttributes(element, stringArray);
        return element;
    }

    Element makeRngElement(String string, String[][] stringArray) {
        return this.makeElement(string, relaxNGNamespace, stringArray);
    }

    Element makeRngElement(String string) {
        return new Element(string, relaxNGNamespace);
    }

    Element makeRef(String string) {
        return this.makeRngElement("ref").setAttribute("name", string);
    }

    Element makeRef(Class clazz) {
        return this.makeRef(this.patternName(clazz));
    }

    Element makeDef(String string) {
        return this.makeRngElement("define").setAttribute("name", string);
    }

    Element makeDef(Class clazz) {
        return this.makeDef(this.patternName(clazz));
    }

    Element makeElementElement(String string) {
        return this.makeRngElement("element").setAttribute("name", string);
    }

    Element makeAttributeElement(String string) {
        return this.makeRngElement("attribute").setAttribute("name", string);
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        RelaxNGSyntax relaxNGSyntax = new RelaxNGSyntax();
        Class clazz = relaxNGSyntax.classSyntax.classForExternalName(Parameters.getParameter("root", "object"));
        Schema schema = relaxNGSyntax.makeSchema(clazz);
        Document document = new Document((Element)schema);
        XML.printXMLWithWhitespace(document, 2);
    }

    class Schema
    extends Element {
        public Schema() {
            super("grammar", relaxNGNamespace);
            this.setAttribute("ns", RelaxNGSyntax.this.xmlt.getHomeNamespace().getURI());
            this.setAttribute("datatypeLibrary", "http://www.w3.org/2001/XMLSchema-datatypes");
        }

        void addComment(String string) {
            this.addContent((Content)new Comment(string));
        }
    }
}

