/*
 * Decompiled with CFR 0.152.
 */
package ix.util.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.rdf.Morphology;
import java.util.HashMap;
import java.util.Map;

class Vocabulary {
    Model model;
    String base;
    String hash;
    Morphology morph = new Morphology();
    Map resourceCache = new HashMap();
    Map propertyCache = new HashMap();

    Vocabulary(String string) {
        this(string, ModelFactory.createDefaultModel());
    }

    Vocabulary(String string, Model model) {
        this.base = string;
        this.hash = this.base + "#";
        this.model = model;
    }

    String getBaseURI() {
        return this.base;
    }

    String getHashURI() {
        return this.hash;
    }

    Resource resource(String string) {
        Resource resource = (Resource)this.resourceCache.get(string);
        if (resource == null) {
            resource = this.model.createResource(this.hash + string);
            this.resourceCache.put(string, resource);
        }
        return resource;
    }

    Property property(String string) {
        Property property = (Property)this.propertyCache.get(string);
        if (property == null) {
            property = this.model.createProperty(this.hash, "has-" + string);
            this.propertyCache.put(string, property);
        }
        return property;
    }

    Property singular(String string) {
        return this.property(this.morph.singular(string));
    }

    boolean contains(Resource resource) {
        return resource.getNameSpace().equals(this.hash);
    }

    boolean contains(Property property) {
        return property.getNameSpace().equals(this.hash);
    }

    String name(Resource resource) {
        return resource.getLocalName();
    }

    String name(Property property) {
        String string = property.getLocalName();
        Debug.expect(string.startsWith("has-"));
        return Strings.afterFirst("has-", string);
    }

    private String pluralName(Property property) {
        throw new UnsupportedOperationException("Plurals are too hard");
    }
}

