/*
 * Decompiled with CFR 0.152.
 */
package ix.util.match;

import ix.icore.Variable;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.context.Context;
import ix.util.context.ContextBoolean;
import ix.util.context.LLQueue;
import ix.util.lisp.Lisp;
import ix.util.match.MatchChoice;
import ix.util.match.MatchEnv;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MatchChoiceManager {
    public static boolean traceDetails = false;
    protected LLQueue matchChoices = new LLQueue();
    protected ContextBoolean changedSinceRecalc = new ContextBoolean(false);

    public void reset() {
        this.matchChoices.clearCompletely();
        this.changedSinceRecalc = new ContextBoolean(false);
    }

    public void clear() {
        this.matchChoices.clear();
        this.changedSinceRecalc.set(false);
    }

    public void add(MatchChoice matchChoice) {
        Debug.expect(!this.matchChoices.contains(matchChoice));
        this.matchChoices.add(matchChoice);
        this.changedSinceRecalc.set(true);
    }

    public void remove(MatchChoice matchChoice) {
        if (!this.matchChoices.remove(matchChoice)) {
            throw new ConsistencyException("Can't remove if not present.");
        }
        this.changedSinceRecalc.set(true);
    }

    public Set getVariables() {
        TreeSet treeSet = new TreeSet();
        for (MatchChoice matchChoice : this.matchChoices) {
            treeSet.addAll(matchChoice.getVariables());
        }
        return treeSet;
    }

    public Map getPossibleValues() {
        return this.getPossibleValues(this.getVariables());
    }

    public Map getPossibleValues(Set set) {
        Debug.expect(!this.changedSinceRecalc.isTrue());
        TreeMap<Variable, Set> treeMap = new TreeMap<Variable, Set>();
        for (Variable variable : set) {
            Set set2 = this.getPossibleValues(variable);
            treeMap.put(variable, set2);
        }
        return treeMap;
    }

    public Set getPossibleValues(Variable variable) {
        Debug.expect(!this.changedSinceRecalc.isTrue());
        Set set = null;
        for (MatchChoice matchChoice : this.matchChoices) {
            if (!matchChoice.getVariables().contains(variable)) continue;
            Set set2 = matchChoice.getPossibleValues(variable);
            if (set == null) {
                set = set2;
                continue;
            }
            Debug.expect(((Object)set2).equals(set), "Values " + set2 + " !equals " + set);
        }
        return set;
    }

    public void recalculate() {
        LinkedList<MatchChoice> linkedList;
        Object object = this.matchChoices.listIterator();
        while (object.hasNext()) {
            linkedList = (MatchChoice)object.next();
            ((MatchChoice)((Object)linkedList)).resetForChecks();
        }
        object = new ArrayList(this.matchChoices);
        linkedList = new LinkedList();
        while (!object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                MatchChoice matchChoice = (MatchChoice)iterator.next();
                for (MatchChoice matchChoice2 : this.matchChoices) {
                    if (matchChoice == matchChoice2 || !Collect.haveCommonElements(matchChoice.getVariables(), matchChoice2.getVariables()) || !matchChoice2.shrinkToFit(matchChoice)) continue;
                    linkedList.add(matchChoice2);
                }
            }
            object = linkedList;
            linkedList = new LinkedList<MatchChoice>();
        }
        this.changedSinceRecalc.set(false);
        this.noticeForcedBindings();
    }

    protected MatchEnv noticeForcedBindings() {
        MatchEnv matchEnv = new MatchEnv();
        Map map = this.getPossibleValues();
        for (Map.Entry entry : map.entrySet()) {
            Variable variable = (Variable)entry.getKey();
            Set set = (Set)entry.getValue();
            if (variable.isBound() || set.size() != 1) continue;
            matchEnv.put(variable, set.iterator().next());
        }
        if (!matchEnv.isEmpty()) {
            Debug.noteln("Forced bindings", (Object)matchEnv);
        }
        return matchEnv;
    }

    public void showState() {
        Debug.noteln("MatchChoiceManager state in", (Object)Context.getContext());
        for (MatchChoice matchChoice : this.matchChoices) {
            Debug.noteln(Lisp.hashName(matchChoice));
            Debug.noteln("  variables", (Object)matchChoice.getVariables());
            Debug.noteln("  branches", (Object)matchChoice.getBranches());
            Debug.noteln("  live    ", (Object)matchChoice.getLiveBranches());
            Debug.noteln("");
        }
    }
}

