/*
 * Decompiled with CFR 0.152.
 */
package ix.util.match;

import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.context.ContextValue;
import ix.util.context.TypedContextValue;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.Bindings;
import ix.util.match.MatchChoiceManager;
import ix.util.match.MatchEnv;
import ix.util.match.SortedValueSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MatchChoice {
    public static final Symbol S_VARIABLE = Symbol.intern("variable");
    public static final Symbol S_MATCH_CHOICE = Symbol.intern("match-choice");
    protected List branches = new ArrayList();
    protected Set variables = new TreeSet();
    protected ContextValue __liveBranches = new TypedContextValue<Object>(List.class, null);

    public MatchChoice() {
    }

    public MatchChoice(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Debug.expect(iterator.next() instanceof Bindings);
        }
        this.branches.addAll(list);
        this.computeVariableSet();
    }

    public MatchChoice(Constraint constraint) {
        if (constraint.getType() != S_VARIABLE || constraint.getRelation() != S_MATCH_CHOICE) {
            throw new IllegalArgumentException("Not a varibale match-choice constraint");
        }
        if (constraint.getParameter(0) instanceof Map) {
            throw new IllegalArgumentException("Obsolete constraint format");
        }
        final List list = (List)constraint.getParameter(0);
        List list2 = (List)constraint.getParameter(1);
        List list3 = (List)Collect.map(list2, new Function1(){

            public Object funcall(Object object) {
                return Collect.extendMap(new MatchEnv(), list, (List)object);
            }
        });
        this.branches.addAll(Bindings.mapsToBindings(list3));
        this.computeVariableSet();
    }

    public Constraint toConstraint() {
        TreeSet treeSet = new TreeSet(Variable.unboundVarsIn(this.variables));
        final LinkedList linkedList = new LinkedList(treeSet);
        List list = Bindings.bindingsToMaps(this.branches);
        List list2 = (List)Collect.map(list, new Function1(){

            public Object funcall(Object object) {
                return Collect.map(linkedList, Collect.toFunction((Map)object));
            }
        });
        return new Constraint(S_VARIABLE, S_MATCH_CHOICE, (List)Lisp.list(linkedList, list2));
    }

    List getBranches() {
        return this.branches;
    }

    public Set getVariables() {
        return this.variables;
    }

    Set getPossibleValues(Variable variable) {
        SortedValueSet sortedValueSet = new SortedValueSet();
        for (Bindings bindings : this.getLiveBranches()) {
            Object object = bindings.valueOf(variable);
            if (object == null) continue;
            sortedValueSet.add(object);
        }
        return sortedValueSet;
    }

    public List getLiveBranches() {
        return (List)this.__liveBranches.get();
    }

    protected void computeVariableSet() {
        this.variables.clear();
        for (Bindings bindings : this.branches) {
            this.variables.addAll(bindings.getVariables());
        }
    }

    void resetForChecks() {
        this.__liveBranches.set(new LinkedList(this.branches));
    }

    boolean shrinkToFit(MatchChoice matchChoice) {
        if (MatchChoiceManager.traceDetails) {
            Debug.noteln(Lisp.hashName(this) + " shrinking to fit " + Lisp.hashName(matchChoice));
        }
        boolean bl = false;
        Iterator iterator = this.getLiveBranches().iterator();
        while (iterator.hasNext()) {
            Bindings bindings = (Bindings)iterator.next();
            if (bindings.isConsistentWith(matchChoice)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }
}

