/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.icore.Variable;
import ix.util.SimpleStringBuffer;
import ix.util.lisp.Cons;
import ix.util.lisp.DelimitedSymbol;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Null;
import ix.util.lisp.Symbol;
import java.util.Iterator;
import java.util.List;

public class LispPrinter {
    private boolean printUnprintablesUsingToString = false;
    private String stringForNil = "nil";

    public void setPrintUnprintablesUsingToString(boolean bl) {
        this.printUnprintablesUsingToString = bl;
    }

    public void setStringForNil(String string) {
        this.stringForNil = string;
    }

    public String printToString(Object object) {
        if (object == null) {
            return "#<null>";
        }
        if (object instanceof DelimitedSymbol) {
            return this.quotedAndEscaped('|', object.toString());
        }
        if (object instanceof Symbol) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof String) {
            return this.quotedAndEscaped('\"', (String)object);
        }
        if (object instanceof Null) {
            return this.stringForNil;
        }
        if (object instanceof Cons) {
            LList lList = (Cons)object;
            String string = "(" + this.printToString(((LList)lList).car());
            while (((LList)lList).cdr() instanceof Cons) {
                string = string + " " + this.printToString(((LList)lList).cdr().car());
                lList = ((LList)lList).cdr();
            }
            return string + ")";
        }
        if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.printToString(iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return this.unprintableToString(object);
    }

    protected String unprintableToString(Object object) {
        if (this.printUnprintablesUsingToString) {
            return object.toString();
        }
        if (object instanceof Variable) {
            return object.toString();
        }
        return Lisp.hashName(object);
    }

    public boolean isFullyPrintable(Object object) {
        return object instanceof Symbol || object instanceof String || object instanceof Cons && this.isFullyPrintableCons((Cons)object) || object instanceof Null || object instanceof Long || object instanceof Double || object instanceof Integer || object instanceof Float;
    }

    private boolean isFullyPrintableCons(Cons cons) {
        for (LList lList = cons; lList != Lisp.NIL; lList = ((LList)lList).cdr()) {
            if (this.isFullyPrintable(((LList)lList).car())) continue;
            return false;
        }
        return true;
    }

    public String elementsToString(Object object) {
        if (!(object instanceof List)) {
            return this.printToString(object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((List)object).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.printToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String quotedAndEscaped(char c, String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            n3 = string.charAt(i);
            if (n3 == c || n3 == 92 || n3 == 10) {
                ++n5;
                continue;
            }
            if (n3 != 13) continue;
            ++n5;
            n2 = i + 1;
            if (n2 >= n4 || (n = string.charAt(n2)) != 10) continue;
            i = n2;
        }
        SimpleStringBuffer simpleStringBuffer = new SimpleStringBuffer(n4 + n5 + 2);
        simpleStringBuffer.append(c);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = string.charAt(n3);
            if (n2 == c || n2 == 92 || n2 == 10) {
                simpleStringBuffer.append('\\');
            } else if (n2 == 13) {
                int n6;
                simpleStringBuffer.append('\\');
                n = n3 + 1;
                if (n < n4 && (n6 = string.charAt(n)) == 10) {
                    simpleStringBuffer.append((char)n2);
                    n3 = n;
                    n2 = n6;
                }
            }
            simpleStringBuffer.append((char)n2);
        }
        simpleStringBuffer.append(c);
        return simpleStringBuffer.toString();
    }

    public int printLength(Object object) {
        if (object == null) {
            return this.printedLen(object);
        }
        if (object instanceof DelimitedSymbol) {
            return object.toString().length() + 2;
        }
        if (object instanceof Symbol) {
            return object.toString().length();
        }
        if (object instanceof Long) {
            Long l = (long)((Long)object);
            int n = 0;
            if (l < 0L) {
                ++n;
                l = -l.longValue();
            }
            while (l > 0L) {
                ++n;
                l = l / 10L;
            }
            return n;
        }
        if (object instanceof Number) {
            return this.printedLen(object);
        }
        if (object instanceof String) {
            return ((String)object).length() + 2;
        }
        if (object instanceof Null) {
            return this.printedLen(object);
        }
        if (object instanceof List) {
            int n = 1;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                n += this.printLength(iterator.next());
                if (!iterator.hasNext()) continue;
                ++n;
            }
            return n + 1;
        }
        return this.printedLen(object);
    }

    private int printedLen(Object object) {
        return this.printToString(object).length();
    }
}

