/*
 * Decompiled with CFR 0.152.
 */
package ix.util.ipc;

import ix.util.Strings;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.io.Serializable;

public class ServiceAddress
implements Serializable {
    public String host;
    public int port;

    public ServiceAddress() {
    }

    public ServiceAddress(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public ServiceAddress(String string) {
        String[] stringArray = Strings.breakAtFirst(":", string);
        if (stringArray[0].equals("") || stringArray[1].equals("")) {
            throw new IllegalArgumentException("service address \"" + string + "\" -- syntax is host:port.");
        }
        this.host = stringArray[0];
        Object object = Lisp.readFromString(stringArray[1]);
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException("service address \"" + string + "\" -- syntax is host:port, " + " and port must be a positive integer.");
        }
        this.port = ((Long)object).intValue();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String toString() {
        return "addr[" + this.host + ":" + this.port + "]";
    }

    static {
        XML.addImport("ix.util.ipc.ServiceAddress");
    }
}

