/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.context.Context;
import ix.util.context.ContextHolder;
import ix.util.context.ContextValue;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListListIterator;
import ix.util.lisp.Lisp;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLQueue<E>
extends AbstractSequentialList<E> {
    static final int IN = 0;
    static final int OUT = 1;
    ContextValue<LList[]> __state;

    public LLQueue() {
        this(Context.getContextHolder(), Lisp.NIL);
    }

    public LLQueue(Collection<? extends E> collection) {
        this(Context.getContextHolder(), collection);
    }

    public LLQueue(ContextHolder contextHolder) {
        this(contextHolder, Lisp.NIL);
    }

    public LLQueue(ContextHolder contextHolder, Collection<? extends E> collection) {
        this.__state = new ContextValue<LList[]>(contextHolder, new LList[]{Lisp.NIL, LList.newLList(collection)});
    }

    public LList contents() {
        LList[] lListArray = this.__state.get();
        if (lListArray[0] != Lisp.NIL) {
            lListArray[1] = lListArray[1].append(lListArray[0].reverse());
            lListArray[0] = Lisp.NIL;
        }
        return lListArray[1];
    }

    public void setContents(List list) {
        this.setLLContents(LList.newLList(list));
    }

    protected LList setLLContents(LList lList) {
        this.__state.set(new LList[]{Lisp.NIL, lList});
        return lList;
    }

    public void push(E e) {
        this.setLLContents(new Cons(e, this.contents()));
    }

    public E pop() {
        LList lList = this.contents();
        if (lList == Lisp.NIL) {
            throw new IndexOutOfBoundsException("LLQueue pop() when empty");
        }
        this.setLLContents(lList.cdr());
        return (E)lList.car();
    }

    public void clearCompletely() {
        this.__state = new ContextValue<LList[]>(this.__state.holder, new LList[]{Lisp.NIL, Lisp.NIL});
    }

    @Override
    public int size() {
        return this.contents().size();
    }

    @Override
    public ListIterator listIterator(int n) {
        return new LLQueueListIterator(this.contents(), n);
    }

    @Override
    public boolean add(E e) {
        LList[] lListArray = this.__state.get();
        this.__state.set(new LList[]{new Cons(e, lListArray[0]), lListArray[1]});
        return true;
    }

    @Override
    public void clear() {
        this.setLLContents(Lisp.NIL);
    }

    @Override
    public boolean remove(Object object) {
        LList lList = this.contents();
        LList lList2 = lList.withoutFirstEqual(object);
        this.setLLContents(lList2);
        return lList2 != lList;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        LList lList = this.contents();
        LList lList2 = this.contents().withoutAll(collection);
        this.setLLContents(lList2);
        return lList2 != lList;
    }

    @Override
    public Iterator iterator() {
        return this.contents().iterator();
    }

    @Override
    public boolean isEmpty() {
        LList[] lListArray = this.__state.get();
        return lListArray[0] == Lisp.NIL && lListArray[1] == Lisp.NIL;
    }

    @Override
    public E get(int n) {
        return (E)this.contents().elementAt(n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.contents().lastIndexOf(object);
    }

    protected static class LLQueueListIterator
    extends LListListIterator {
        public LLQueueListIterator(LList lList, int n) {
            super(lList, n);
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("Cannot set using an LLQueue ListIterator");
        }
    }
}

