/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.RethrownException;

public abstract class WithCleanup
implements Runnable {
    public void run() {
        Throwable throwable = null;
        try {
            this.body();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw new RethrownException(throwable2);
        }
        finally {
            try {
                this.cleanup();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throw new RethrownException(throwable3);
                }
                Debug.noteln("Exception during cleanup after " + Debug.describeException(throwable));
                Debug.noteException(throwable3);
                throw new RethrownException(throwable, Debug.describeException(throwable) + ". \n\n" + "Second exception during cleanup: " + Debug.describeException(throwable3));
            }
        }
    }

    public abstract void body() throws Exception;

    public abstract void cleanup() throws Exception;
}

