/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.ToolController;
import ix.iface.util.ToolFrame;
import ix.iface.util.ToolManager;
import ix.iface.util.TranscriptTextArea;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TextAreaFrame
extends TranscriptTextArea {
    protected TFrame frame;
    protected List listeners = new LinkedList();

    public TextAreaFrame(String string) {
        this(string, new String[0]);
    }

    public TextAreaFrame(String string, String[] stringArray) {
        this(10, 60, string, stringArray);
    }

    public TextAreaFrame(int n, int n2, String string, String[] stringArray) {
        super(n, n2);
        this.frame = this.makeTFrame(string, stringArray);
        this.finishFrame();
    }

    protected void finishFrame() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public TFrame getFrame() {
        return this.frame;
    }

    protected TFrame makeTFrame(String string, String[] stringArray) {
        return new TFrame(string, stringArray);
    }

    protected double getEffectiveWidth() {
        double d = super.getEffectiveWidth();
        double d2 = this.frame.getSize().getWidth();
        return Math.min(d, d2);
    }

    public void addListener(TListener tListener) {
        this.listeners.add(tListener);
    }

    public void fireButtonPressed(String string) {
        for (TListener tListener : this.listeners) {
            tListener.buttonPressed(string);
        }
    }

    public void whenClosed() {
        this.setVisible(false);
    }

    public void setText(String string) {
        super.setText(string);
        this.frame.validate();
    }

    public void append(String string) {
        super.append(string);
        this.frame.validate();
    }

    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void addToolManager() {
        this.frame.toolManager = new ToolManager();
        this.frame.getJMenuBar().add(this.frame.toolManager.getToolsMenu());
    }

    public void addTool(ToolController toolController) {
        this.frame.toolManager.addTool(toolController);
    }

    public class TFrame
    extends ToolFrame {
        protected Container contentPane;
        protected ToolManager toolManager;
        protected ActionListener buttonListener;

        protected TFrame(String string, String[] stringArray) {
            super(string);
            this.buttonListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    TextAreaFrame.this.fireButtonPressed(string);
                    if (string.equals("Close") || string.equals("Cancel")) {
                        TextAreaFrame.this.whenClosed();
                    }
                }
            };
            this.setIconImage(IconImage.getIconImage(this));
            this.setJMenuBar(this.makeMenuBar());
            this.contentPane = this.getContentPane();
            this.contentPane.add((Component)new JScrollPane(TextAreaFrame.this), "Center");
            if (stringArray.length > 0) {
                this.contentPane.add((Component)this.makeButtonPanel(stringArray), "South");
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Debug.noteln(TFrame.this.getTitle() + " windowClosing event");
                    TextAreaFrame.this.whenClosed();
                }
            });
        }

        protected JMenuBar makeMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            jMenu.add(this.makeMenuItem("Close"));
            return jMenuBar;
        }

        public JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this.buttonListener));
            return jMenuItem;
        }

        protected JPanel makeButtonPanel(String[] stringArray) {
            JPanel jPanel = new JPanel();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                jPanel.add(this.makeButton(string));
            }
            return jPanel;
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this.buttonListener));
            return jButton;
        }
    }

    public static interface TListener {
        public void buttonPressed(String var1);
    }
}

