/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Util;
import ix.util.WithCleanup;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IO {
    private IO() {
    }

    public static void withReader(Reader reader, Runnable runnable) {
        IO.withClosable(reader, runnable);
    }

    public static void withWriter(Writer writer, Runnable runnable) {
        IO.withClosable(writer, runnable);
    }

    public static void withInputStream(InputStream inputStream, Runnable runnable) {
        IO.withClosable(inputStream, runnable);
    }

    public static void withOutputStream(OutputStream outputStream, Runnable runnable) {
        IO.withClosable(outputStream, runnable);
    }

    public static void withClosable(final Object object, final Runnable runnable) {
        Util.run(new WithCleanup(){

            public void body() {
                runnable.run();
            }

            public void cleanup() throws IOException {
                IO.close(object);
            }
        });
    }

    private static void close(Object object) throws IOException {
        Debug.noteln("Trying to close", object);
        if (object instanceof Reader) {
            ((Reader)object).close();
        } else if (object instanceof Writer) {
            ((Writer)object).close();
        } else if (object instanceof InputStream) {
            ((InputStream)object).close();
        } else if (object instanceof OutputStream) {
            ((OutputStream)object).close();
        } else {
            throw new IllegalArgumentException("Cannot close " + object + " because it is not a Reader, Writer, or stream");
        }
    }
}

