/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Variable;
import ix.util.Debug;
import ix.util.ObjectCopier;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LispReader;
import ix.util.lisp.Symbol;
import ix.util.match.Bindings;
import ix.util.match.MatchChoice;
import ix.util.match.MatchChoiceManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class MatchChoiceTest {
    LispReader lin = new LispReader(System.in);
    VarMaker varMaker = new VarMaker();
    Symbol BYE = Symbol.intern("bye");
    MatchChoiceManager choiceManager = new MatchChoiceManager();

    public static void main(String[] stringArray) {
        new MatchChoiceTest().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        while (true) {
            try {
                this.runTest();
                continue;
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                continue;
            }
            finally {
                System.out.println("");
                continue;
            }
            break;
        }
    }

    void runTest() throws Exception {
        System.out.println("Enter a MatchChoice as alist of a-lists:");
        Object object = this.lin.readObject();
        if (object == this.BYE) {
            System.exit(0);
        } else if (object instanceof LList) {
            MatchChoice matchChoice = this.makeMatchChoice((LList)object);
            this.choiceManager.add(matchChoice);
            this.choiceManager.recalculate();
            this.choiceManager.showState();
            Map map = this.choiceManager.getPossibleValues();
            System.out.println("Values " + map);
        } else {
            System.out.println("Invalid input");
        }
    }

    MatchChoice makeMatchChoice(LList lList) {
        LinkedList<Bindings> linkedList = new LinkedList<Bindings>();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            LList lList2 = (LList)this.varMaker.copy(iterator.next());
            Map map = lList2.alistToMap(new TreeMap());
            Bindings bindings = new Bindings(map);
            linkedList.add(bindings);
        }
        return new MatchChoice(linkedList);
    }

    static class VarMaker
    extends ObjectCopier {
        Map toVarMap = new HashMap();

        VarMaker() {
        }

        public Object mapElement(Object object) {
            return object instanceof ItemVar ? this.mapItemVar((ItemVar)object) : this.copy(object);
        }

        Variable mapItemVar(ItemVar itemVar) {
            Variable variable = (Variable)this.toVarMap.get(itemVar);
            if (variable == null) {
                variable = new Variable(itemVar);
                this.toVarMap.put(itemVar, variable);
            }
            return variable;
        }
    }
}

