/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.util;

import ix.Release;
import ix.icore.Issue;
import ix.icore.TaskItem;
import ix.icore.domain.Constraint;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.tree.IXTrees;
import ix.iface.ui.util.UIUtil;
import ix.ip2.ObjectView;
import ix.iview.IDERelease;
import ix.iview.VarSpecifier;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.UIRefinement;
import ix.iview.tree.ObjectClassTreeModel;
import ix.iview.tree.ObjectClassTreeNode;
import ix.util.Debug;
import ix.util.Name;
import ix.util.StableHashMap;
import ix.util.Strings;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;

public class IVUtil {
    public static String TYPE_STRING_a = "type";
    public static String TYPE_STRING_b = "class";

    public static String ideReleaseToString() {
        return IDERelease.name + " version " + IDERelease.version + ", " + IDERelease.date;
    }

    public static String releaseToString() {
        return "I-X version " + Release.version + ", " + Release.date;
    }

    public static void printIDEReleaseGreeting() {
        System.out.println(IVUtil.ideReleaseToString());
        System.out.println("");
    }

    public static int findString(String string, String string2) {
        Pattern pattern = Pattern.compile(string, 2);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            Debug.noteln("I found the text starting at ", matcher.start());
            return matcher.start();
        }
        Debug.noteln("No match found.");
        return -1;
    }

    public static Set findNameMatches(String string, List list) {
        if (list == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(string, 2);
        TreeMap treeMap = new TreeMap();
        for (Named named : list) {
            Matcher matcher = pattern.matcher(named.getName());
            if (!matcher.find(0)) continue;
            Object v = treeMap.get(new Integer(matcher.start()));
            LinkedList<Named> linkedList = v == null ? new LinkedList<Named>() : (LinkedList<Named>)v;
            linkedList.add(named);
            treeMap.put(new Integer(matcher.start()), linkedList);
        }
        if (treeMap.isEmpty()) {
            return null;
        }
        List list2 = UIUtil.getFlatValues(treeMap);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return new LinkedHashSet(list2);
    }

    public static Collection sortNamedCollection(Collection collection) {
        if (collection == null) {
            return null;
        }
        TreeMap<String, Named> treeMap = new TreeMap<String, Named>();
        ArrayList<Named> arrayList = new ArrayList<Named>();
        for (Named named : collection) {
            if (named == null) continue;
            String string = named.getName();
            if (string == null || string.equals("")) {
                arrayList.add(named);
                continue;
            }
            treeMap.put(string, named);
        }
        ArrayList arrayList2 = new ArrayList(treeMap.values());
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    public static List sortNodeCollection(Collection collection) {
        if (collection == null) {
            return null;
        }
        try {
            TreeMap<Integer, NodeSpec> treeMap = new TreeMap<Integer, NodeSpec>();
            ArrayList<NodeSpec> arrayList = new ArrayList<NodeSpec>();
            for (NodeSpec nodeSpec : collection) {
                if (nodeSpec == null) continue;
                Name name = nodeSpec.getId();
                try {
                    Integer n = new Integer(name.toString());
                    treeMap.put(n, nodeSpec);
                }
                catch (Exception exception) {
                    arrayList.add(nodeSpec);
                }
            }
            if (treeMap.values() == null) {
                return new ArrayList(collection);
            }
            ArrayList arrayList2 = new ArrayList(treeMap.values());
            arrayList2.addAll(arrayList);
            return arrayList2;
        }
        catch (Exception exception) {
            Debug.noteln("Warning: sorting nodes failed - using un-sorted list", (Object)UIUtil.show(collection));
            return new ArrayList(collection);
        }
    }

    public static List sortConstraintCollection(Collection collection) {
        if (collection == null) {
            return null;
        }
        TreeMap<String, Constraint> treeMap = new TreeMap<String, Constraint>();
        for (Constraint constraint : collection) {
            if (constraint == null) continue;
            String string = constraint.toString();
            if (constraint.getType() != null && constraint.getType().toString().equals("compute")) {
                string = "xxxx" + string;
            }
            treeMap.put(string, constraint);
        }
        ArrayList arrayList = new ArrayList(treeMap.values());
        return arrayList;
    }

    public static List sortTICollection(Collection collection) {
        return new ArrayList(collection);
    }

    public static boolean sameList(List list, List list2) {
        if (IVUtil.bothEmpty(list, list2)) {
            return true;
        }
        return list != null && ((Object)list).equals(list2);
    }

    public static boolean sameMap(Map map, Map map2) {
        if (IVUtil.bothEmpty(map, map2)) {
            return true;
        }
        return map != null && ((Object)map).equals(map2);
    }

    public static boolean sameStableMap(StableHashMap stableHashMap, StableHashMap stableHashMap2) {
        if (IVUtil.bothEmpty(stableHashMap, stableHashMap2)) {
            return true;
        }
        return stableHashMap != null && stableHashMap.equals(stableHashMap2);
    }

    public static boolean sameSet(Collection collection, Collection collection2) {
        if (IVUtil.bothEmpty(collection, collection2)) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.isEmpty() || collection2.isEmpty()) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (collection2.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean sameObject(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean sameString(String string, String string2) {
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean sameSymbol(Object object, Object object2) {
        return IVUtil.sameString(object.toString(), object2.toString());
    }

    public static boolean bothEmpty(Collection collection, Collection collection2) {
        return !(collection2 != null && collection2.size() != 0 || collection != null && collection.size() != 0);
    }

    public static boolean bothEmpty(Map map, Map map2) {
        return UIUtil.isEmptyThing(map) && UIUtil.isEmptyThing(map2);
    }

    public static boolean checkCopyObject(String string, UIObject uIObject, String string2) {
        if (uIObject == null || uIObject.isEmpty()) {
            return false;
        }
        String string3 = uIObject.getName();
        if (string3 != null && !string3.equals("") && !string3.equals("undefined") && !string3.equals("Undefined") && uIObject.nameHasChanged(string2)) {
            String[] stringArray = new String[]{"You have changed the name of the " + string + ".", "Do you want to overwrite the original", "or define a new one?"};
            Object[] objectArray = new Object[]{"Overwrite", "New"};
            int n = JOptionPane.showOptionDialog(null, stringArray, "Confirm", -1, 3, null, objectArray, objectArray[0]);
            Debug.noteln("IVUt: chose option", n);
            if (n == 1) {
                return true;
            }
        }
        return false;
    }

    public static List makeObjectClassTree(UIDomain uIDomain, List list) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ObjectClassTreeNode objectClassTreeNode = new ObjectClassTreeNode(new UIObjectClass(uIDomain, "Dummy Root"));
        ObjectClassTreeModel objectClassTreeModel = new ObjectClassTreeModel(uIDomain, objectClassTreeNode);
        objectClassTreeModel.clearModel();
        IXTrees.setupTreeModel(objectClassTreeModel, list);
        Object object = objectClassTreeModel.getRoot();
        if (object != null && object instanceof ObjectClassTreeNode) {
            ObjectClassTreeNode objectClassTreeNode2 = (ObjectClassTreeNode)object;
            Enumeration<TreeNode> enumeration = objectClassTreeNode2.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                linkedList.add(0, ((ObjectClassTreeNode)treeNode).getUserObject());
            }
        }
        return linkedList;
    }

    public static String getRelativeName(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof UIObjectClass) {
            return ((UIObjectClass)object).getName();
        }
        if (object instanceof ObjectClass) {
            return ((ObjectClass)object).getName();
        }
        return null;
    }

    public static boolean isEmptyConstraint(Constraint constraint) {
        if (constraint == null) {
            return true;
        }
        List list = constraint.getParameters();
        return list == null || list.isEmpty();
    }

    public static Constraint setConstraintValue(Constraint constraint, Object object) {
        if (IVUtil.isEmptyConstraint(constraint)) {
            return constraint;
        }
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        if (patternAssignment != null) {
            patternAssignment.setValue(object);
        }
        return constraint;
    }

    public static Constraint setConstraintValue(UIObjectClass uIObjectClass, Constraint constraint, Object object) {
        if (IVUtil.isEmptyConstraint(constraint)) {
            return constraint;
        }
        ObjectProperty objectProperty = IVUtil.propertyFromConstraint(uIObjectClass, constraint);
        if (objectProperty != null) {
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            Object object2 = patternAssignment.getValue();
            try {
                Symbol symbol = Symbol.intern(object.toString());
                if (symbol instanceof ItemVar) {
                    patternAssignment.setValue(symbol);
                } else {
                    ObjectView.ValueParser valueParser = new ObjectView.ValueParser();
                    Object object3 = valueParser.read(objectProperty, object.toString(), object2);
                    patternAssignment.setValue(object3);
                }
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                patternAssignment.setValue(object);
            }
        }
        return constraint;
    }

    public static Object getConstraintValue(Constraint constraint) {
        if (IVUtil.isEmptyConstraint(constraint)) {
            return null;
        }
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        if (patternAssignment != null) {
            return patternAssignment.getValue();
        }
        return null;
    }

    public static Object findVariableClass(ItemVar itemVar, List list) {
        if (itemVar == null || list == null) {
            return null;
        }
        List list2 = IVUtil.filterVariableProperty(itemVar, TYPE_STRING_a, list);
        if (list2 == null) {
            list2 = IVUtil.filterVariableProperty(itemVar, TYPE_STRING_b, list);
        }
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        Constraint constraint = (Constraint)list2.get(0);
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        Object object = patternAssignment.getValue();
        return object;
    }

    public static Set removeConstraint(Set set, Constraint constraint) {
        HashSet hashSet = new HashSet();
        if (set == null || set.isEmpty()) {
            return set;
        }
        if (constraint == null) {
            set.remove(constraint);
            return set;
        }
        for (Object e : set) {
            if (!(e instanceof Constraint)) {
                Debug.noteln(" found non-constraint in constraint set", e);
                continue;
            }
            if (IVUtil.sameConstraint(constraint, (Constraint)e)) continue;
            hashSet.add(e);
        }
        set.clear();
        set.addAll(hashSet);
        return set;
    }

    public static List filterClassConstraints(List list) {
        if (list == null) {
            return null;
        }
        List list2 = IVUtil.filterProperty(TYPE_STRING_a, list);
        if (list2 == null) {
            list2 = IVUtil.filterProperty(TYPE_STRING_b, list);
        }
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return list2;
    }

    public static boolean isClassConstraint(ItemVar itemVar, Constraint constraint) {
        if (itemVar == null || constraint == null) {
            return false;
        }
        if (IVUtil.isClassConstraint(constraint)) {
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            if (patternAssignment == null) {
                return false;
            }
            LList lList = patternAssignment.getPattern();
            if (lList == null) {
                return false;
            }
            return IVUtil.isInPattern(itemVar, lList);
        }
        return false;
    }

    public static boolean isClassConstraint(Constraint constraint) {
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        if (patternAssignment == null) {
            return false;
        }
        LList lList = patternAssignment.getPattern();
        if (lList == null) {
            return false;
        }
        String string = UIUtil.toCapitalised(TYPE_STRING_a);
        String string2 = UIUtil.toCapitalised(TYPE_STRING_b);
        return lList.contains(Symbol.intern(TYPE_STRING_a)) || lList.contains(Symbol.intern(string)) || lList.contains(Symbol.intern(TYPE_STRING_b)) || lList.contains(Symbol.intern(string2));
    }

    public static Constraint findClassConstraint(ItemVar itemVar, List list) {
        if (itemVar == null || list == null) {
            return null;
        }
        List list2 = IVUtil.filterVariableProperty(itemVar, TYPE_STRING_a, list);
        if (list2 == null) {
            list2 = IVUtil.filterVariableProperty(itemVar, TYPE_STRING_b, list);
        }
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return (Constraint)list2.get(0);
    }

    public static Object extractType(Constraint constraint) {
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        Object object = patternAssignment.getValue();
        return object;
    }

    public static Object extractType(Constraint constraint, UIDomain uIDomain) {
        Object object = IVUtil.extractType(constraint);
        Object object2 = null;
        if (object instanceof String) {
            object2 = uIDomain.getNamedObjectClass((String)object);
        }
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public static String propertyFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return "";
        }
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        if (patternAssignment == null) {
            return "";
        }
        LList lList = patternAssignment.getPattern();
        return IVUtil.getPropertyFromPattern(lList);
    }

    public static ObjectProperty propertyFromConstraint(UIObjectClass uIObjectClass, Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        if (patternAssignment == null) {
            return null;
        }
        LList lList = patternAssignment.getPattern();
        return IVUtil.propertyFromPattern((List)lList, uIObjectClass);
    }

    public static ItemVar variableFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        if (patternAssignment == null) {
            return null;
        }
        LList lList = patternAssignment.getPattern();
        String string = IVUtil.getSubjectInPattern(lList);
        if (string == null || string.equals("")) {
            return null;
        }
        Symbol symbol = Symbol.intern(string);
        if (symbol instanceof ItemVar) {
            return (ItemVar)symbol;
        }
        return null;
    }

    public static ObjectProperty propertyFromPattern(List list, UIObjectClass uIObjectClass) {
        if (list == null || uIObjectClass == null) {
            return null;
        }
        HashSet hashSet = uIObjectClass.getAllProperties();
        return IVUtil.propertyFromPattern(list, hashSet);
    }

    private static ObjectProperty propertyFromPattern(List list, Collection collection) {
        if (collection == null) {
            return null;
        }
        for (ObjectProperty objectProperty : collection) {
            if (!list.contains(objectProperty.getName().toString()) && !list.contains(objectProperty.getName())) continue;
            return objectProperty;
        }
        return null;
    }

    public static ObjectProperty propertyFromString(String string, UIObjectClass uIObjectClass) {
        if (string == null || string.equals("") || uIObjectClass == null) {
            return null;
        }
        HashSet hashSet = uIObjectClass.getAllProperties();
        for (ObjectProperty objectProperty : hashSet) {
            if (!string.equals(objectProperty.getName().toString())) continue;
            return objectProperty;
        }
        return null;
    }

    public static List filterProperty(String string, List list) {
        if (list == null || string == "") {
            return null;
        }
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        String string2 = UIUtil.toCapitalised(string);
        Symbol symbol = Symbol.intern(string2);
        Symbol symbol2 = Symbol.intern(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                LList lList;
                Constraint constraint = (Constraint)iterator.next();
                PatternAssignment patternAssignment = constraint.getPatternAssignment();
                if (patternAssignment == null || (lList = patternAssignment.getPattern()) == null || !lList.contains(symbol2) && !lList.contains(symbol)) continue;
                arrayList.add(constraint);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public static List filterVariableProperty(ItemVar itemVar, String string, List list) {
        if (itemVar == null || list == null || string == "") {
            return null;
        }
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        String string2 = UIUtil.toCapitalised(string);
        Symbol symbol = Symbol.intern(string2);
        Symbol symbol2 = Symbol.intern(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                LList lList;
                Constraint constraint = (Constraint)iterator.next();
                PatternAssignment patternAssignment = constraint.getPatternAssignment();
                if (patternAssignment == null || (lList = patternAssignment.getPattern()) == null || !lList.contains(symbol2) && !lList.contains(symbol) || !IVUtil.isInPattern(itemVar, lList)) continue;
                arrayList.add(constraint);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public static LList replaceInPattern(ItemVar itemVar, ItemVar itemVar2, LList lList) {
        if (lList == null || lList.isNull() || !IVUtil.isInPattern(itemVar, lList)) {
            return lList;
        }
        if (itemVar == null || itemVar2 == null) {
            return lList;
        }
        if (itemVar.equals(lList.car())) {
            return new Cons(itemVar2, IVUtil.replaceInPattern(itemVar, itemVar2, lList.cdr()));
        }
        if (lList.car() != null && itemVar.toString().equals(lList.car().toString())) {
            return new Cons(itemVar2, IVUtil.replaceInPattern(itemVar, itemVar2, lList.cdr()));
        }
        return new Cons(lList.car(), IVUtil.replaceInPattern(itemVar, itemVar2, lList.cdr()));
    }

    public static HashMap replaceVarInConstraints(ItemVar itemVar, ItemVar itemVar2, HashMap hashMap) {
        if (itemVar2 == null) {
            return new HashMap();
        }
        if (itemVar2.equals(itemVar)) {
            return hashMap;
        }
        if (hashMap.values() == null) {
            return hashMap;
        }
        for (Set set : hashMap.values()) {
            if (set == null) continue;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    Constraint constraint = (Constraint)iterator.next();
                    PatternAssignment patternAssignment = constraint.getPatternAssignment();
                    if (patternAssignment == null) continue;
                    LList lList = IVUtil.replaceInPattern(itemVar, itemVar2, patternAssignment.getPattern());
                    patternAssignment.setPattern(lList);
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                }
            }
        }
        return hashMap;
    }

    public static boolean isInPattern(ItemVar itemVar, LList lList) {
        if (lList == null) {
            return false;
        }
        if (itemVar == null) {
            return false;
        }
        if (lList.contains(itemVar)) {
            return true;
        }
        if (lList.contains(itemVar.toString())) {
            return true;
        }
        String string = itemVar.toString();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubjectInPattern(ItemVar itemVar, LList lList) {
        if (lList == null || lList.size() < 2) {
            return false;
        }
        if (itemVar == null) {
            return false;
        }
        Object object = lList.get(1);
        if (object == null) {
            return false;
        }
        return itemVar.equals(object) || itemVar.toString().equals(object.toString());
    }

    public static String getSubjectInPattern(LList lList) {
        if (lList == null || lList.size() < 2) {
            return "";
        }
        Object object = lList.get(1);
        return object.toString();
    }

    public static boolean isPropertyPattern(ObjectProperty objectProperty, LList lList) {
        if (lList == null || lList.size() < 1) {
            return false;
        }
        if (objectProperty == null) {
            return false;
        }
        Object object = lList.get(0);
        if (object == null) {
            return false;
        }
        return objectProperty.equals(object) || objectProperty.toString().equals(object.toString()) || objectProperty.getName().toString().equals(object.toString());
    }

    public static String getPropertyFromPattern(LList lList) {
        if (lList == null || lList.size() < 1) {
            return "";
        }
        Object object = lList.get(0);
        return object.toString();
    }

    public static boolean isSimplePropertyAssignment(PatternAssignment patternAssignment, ObjectProperty objectProperty, ItemVar itemVar) {
        LList lList = patternAssignment.getPattern();
        return IVUtil.isPropertyPattern(objectProperty, lList) && IVUtil.isSubjectInPattern(itemVar, lList) && lList.size() == 2;
    }

    public static boolean sameConstraint(Constraint constraint, Constraint constraint2) {
        if (constraint == null) {
            return constraint2 == null;
        }
        if (constraint2 == null) {
            return false;
        }
        if (!IVUtil.sameObjectConstraint(constraint, constraint2)) {
            return false;
        }
        String string = IVUtil.printConstraintParameters(constraint);
        if (string != null) {
            return string.equals(IVUtil.printConstraintParameters(constraint2));
        }
        return IVUtil.printConstraintParameters(constraint2) == null;
    }

    public static boolean sameObjectConstraint(Constraint constraint, Constraint constraint2) {
        return constraint.getType() == constraint2.getType() && constraint.getRelation() == constraint2.getRelation();
    }

    public static Constraint readCondition(Symbol symbol, Symbol symbol2, String string) throws SyntaxException {
        String[] stringArray = Strings.breakAtFirst("=", string);
        String string2 = UIUtil.ensureParenthesized(stringArray[0].trim());
        String string3 = stringArray[1].trim();
        if (string3.equals("")) {
            string3 = "true";
        }
        String string4 = "(" + symbol.toString() + " " + symbol2.toString() + " " + string2 + " = " + string3 + ")";
        Constraint constraint = null;
        try {
            LList lList = (LList)Lisp.readFromString(string4);
            LTF_Parser lTF_Parser = new LTF_Parser();
            constraint = lTF_Parser.parseConstraint(lList);
        }
        catch (Exception exception) {
            throw new SyntaxException("Invalid constraint: " + Debug.foldException(exception));
        }
        if (constraint == null) {
            throw new SyntaxException("Invalid constraint: " + symbol + "-" + symbol2 + ": " + string);
        }
        return constraint;
    }

    public static boolean checkNodeRefConsistency(UIRefinement uIRefinement, Ordering ordering) {
        if (ordering == null) {
            return true;
        }
        if (uIRefinement == null) {
            return true;
        }
        NodeEndRef nodeEndRef = ordering.getFrom();
        if (nodeEndRef == null) {
            return false;
        }
        NodeSpec nodeSpec = uIRefinement.findNode(nodeEndRef.getNode());
        if (nodeSpec == null) {
            return false;
        }
        nodeEndRef = ordering.getTo();
        if (nodeEndRef == null) {
            return false;
        }
        nodeSpec = uIRefinement.findNode(nodeEndRef.getNode());
        return nodeSpec != null;
    }

    public static String namedListToDisplay(Collection collection) {
        String string = "";
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    string = string + ((Named)iterator.next()).getName() + " ";
                }
                catch (Exception exception) {
                    string = string + iterator.next().toString() + " ";
                }
            }
        }
        return string;
    }

    public static String textRenderPatterns(Collection collection) {
        if (collection == null) {
            return "";
        }
        String string = "";
        for (Object e : collection) {
            LList lList;
            if (e instanceof NodeSpec) {
                lList = ((NodeSpec)e).getPattern();
            } else if (e instanceof Issue) {
                lList = ((TaskItem)e).getPattern();
            } else {
                Debug.noteln("WARNING: Cannot get patterns from", e.getClass());
                lList = Lisp.NIL;
            }
            string = string + Lisp.elementsToString(lList) + UIUtil.lineSeparator;
        }
        return string;
    }

    public String textDerenderPatterns(List list) {
        if (list == null) {
            return "";
        }
        String string = "";
        for (Object e : list) {
            LList lList;
            if (e instanceof NodeSpec) {
                lList = ((NodeSpec)e).getPattern();
            } else if (e instanceof Issue) {
                lList = ((TaskItem)e).getPattern();
            } else {
                Debug.noteln("WARNING: Cannot get patterns from", e.getClass());
                lList = Lisp.NIL;
            }
            string = string + Lisp.elementsToString(lList) + UIUtil.lineSeparator;
        }
        return string;
    }

    public static String printNodes(Collection collection) {
        if (collection == null) {
            return "";
        }
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + ", " + IVUtil.printNode((NodeSpec)iterator.next());
        }
        return string;
    }

    public static String printOrderings(Collection collection) {
        if (collection == null) {
            return "";
        }
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + ", " + IVUtil.printOrdering((Ordering)iterator.next());
        }
        return string;
    }

    public static String printVarDecs(Collection collection) {
        if (collection == null) {
            return "";
        }
        String string = "";
        if (collection == null) {
            string = "any";
        } else if (collection.size() == 0) {
            string = "none";
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = string + ", " + IVUtil.printVarDec((VariableDeclaration)iterator.next());
            }
        }
        return string;
    }

    public static String printNode(NodeSpec nodeSpec) {
        return nodeSpec.getPattern().toString();
    }

    public static String printVarDec(VariableDeclaration variableDeclaration) {
        return variableDeclaration.getName().toString();
    }

    public static String printOrdering(Ordering ordering) {
        if (ordering == null) {
            return "";
        }
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (nodeEndRef != null && nodeEndRef.getNode() != null) {
            string = nodeEndRef.getNode().toString();
        }
        if (nodeEndRef != null && nodeEndRef.getEnd() != null) {
            string2 = nodeEndRef.getEnd().toString();
        }
        if (nodeEndRef2 != null && nodeEndRef2.getNode() != null) {
            string3 = nodeEndRef2.getNode().toString();
        }
        if (nodeEndRef2 != null && nodeEndRef2.getEnd() != null) {
            string4 = nodeEndRef2.getEnd().toString();
        }
        return string + "-" + string2 + " -> " + string3 + "-" + string4;
    }

    public static String printCondition(Constraint constraint) {
        if (constraint == null) {
            return "";
        }
        String string = "E: ";
        if (constraint.getRelation() == Refinement.S_CONDITION) {
            string = "C: ";
        }
        String string2 = IVUtil.printConstraintParameters(constraint);
        return string + string2;
    }

    public static String printConstraints(Collection collection) {
        if (collection == null) {
            return "";
        }
        String string = "";
        for (Object e : collection) {
            if (e instanceof Constraint) {
                string = string + ", " + IVUtil.printConstraint((Constraint)e);
                continue;
            }
            Debug.noteln("IVUtil: this is not a constraint:", e);
        }
        return string;
    }

    public static String printConstraint(Constraint constraint) {
        if (constraint == null) {
            return "";
        }
        String string = "";
        try {
            string = constraint.getType().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "";
        try {
            string2 = constraint.getRelation().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = IVUtil.printConstraintParameters(constraint);
        return string + " - " + string2 + ": " + string3;
    }

    public static String printConstraintParameters(Constraint constraint) {
        if (constraint == null) {
            return "";
        }
        List list = constraint.getParameters();
        if (list == null) {
            return "";
        }
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                PatternAssignment patternAssignment = (PatternAssignment)iterator.next();
                string = string + patternAssignment.getPattern() + " = " + patternAssignment.getValue().toString() + " ";
            }
            catch (Exception exception) {}
        }
        return string.trim();
    }

    public static String printUIObjects(Collection collection) {
        if (collection == null) {
            return "";
        }
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + ", " + UIUtil.lineSeparator + " " + ((UIObject)iterator.next()).print();
        }
        return string;
    }

    public static void useVar(JTextComponent jTextComponent, int n, String string) {
        String string2 = jTextComponent.getText();
        String string3 = "";
        string3 = string == null || string == "" ? "" : (string.equals("?") ? string : string + " ");
        String string4 = string2;
        if (n >= string2.length()) {
            string4 = string2 + string3;
        } else {
            string4 = string2.substring(0, n) + string3;
            if (n + 1 <= string2.length()) {
                string4 = string4 + string2.substring(n, string2.length());
            }
        }
        jTextComponent.setText(string4);
        jTextComponent.setCaretPosition(Math.min(string4.length(), n + string3.length()));
    }

    public static void enableVars(VarSpecifier varSpecifier, JTextComponent jTextComponent) {
        Action action = IVUtil.makeVarAction(varSpecifier, jTextComponent);
        IVUtil.enableVarAction(jTextComponent, action);
    }

    private static Action makeVarAction(final VarSpecifier varSpecifier, final JTextComponent jTextComponent) {
        return new AbstractAction("startVar"){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTextComponent.getCaretPosition();
                Point point = jTextComponent.getCaret().getMagicCaretPosition();
                List list = varSpecifier.getVarsToOffer();
                try {
                    IVUtil.offerVars(varSpecifier, jTextComponent, list, point, n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private static void enableVarAction(JTextComponent jTextComponent, Action action) {
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        actionMap.put("startVar", action);
        inputMap.put(KeyStroke.getKeyStroke('?'), "startVar");
    }

    public static void offerVars(final VarSpecifier varSpecifier, final JTextComponent jTextComponent, List list, Point point, final int n) {
        final Component component = varSpecifier instanceof Component ? (Component)((Object)varSpecifier) : null;
        if (list == null) {
            IVUtil.useVar(jTextComponent, n, "?");
            return;
        }
        if (list.size() == 0) {
            String[] stringArray = new String[]{"Declarations say that no variables are allowed", "To change declarations use the Edit menu"};
            JOptionPane.showMessageDialog(component, stringArray);
        } else {
            final JPopupMenu jPopupMenu = new JPopupMenu();
            for (VariableDeclaration variableDeclaration : list) {
                final String string = variableDeclaration.getName().toString();
                jPopupMenu.add(new AbstractAction(string){

                    public void actionPerformed(ActionEvent actionEvent) {
                        IVUtil.useVar(jTextComponent, n, string);
                        jPopupMenu.setVisible(false);
                    }
                });
            }
            jPopupMenu.addSeparator();
            jPopupMenu.add(new AbstractAction("New..."){

                public void actionPerformed(ActionEvent actionEvent) {
                    jPopupMenu.setVisible(false);
                    String string = "Please enter the variable name";
                    String string2 = JOptionPane.showInputDialog(component, (Object)string);
                    string2 = varSpecifier.addVariableDeclaration(string2);
                    if (string2 != "") {
                        IVUtil.useVar(jTextComponent, n, string2);
                        jPopupMenu.setVisible(false);
                    }
                    jTextComponent.validate();
                }
            });
            jPopupMenu.show(jTextComponent, (int)point.getX(), (int)point.getY());
        }
    }

    public static String ensureVarName(String string) {
        if (string == "") {
            return "";
        }
        if (string.startsWith("?")) {
            return string;
        }
        return "?" + string;
    }

    public static List makeVariableDeclarations(Collection collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        for (Object e : collection) {
            if (e instanceof ItemVar) {
                arrayList.add(new VariableDeclaration((ItemVar)e));
                continue;
            }
            if (e instanceof String) {
                VariableDeclaration variableDeclaration = IVUtil.makeVariableDeclaration((String)e);
                if (variableDeclaration == null) continue;
                arrayList.add(variableDeclaration);
                continue;
            }
            Debug.noteln("UIR: cannot deal with variable specifications of class", e.getClass());
        }
        return arrayList;
    }

    public static VariableDeclaration makeVariableDeclaration(String string) {
        Symbol symbol;
        String string2 = IVUtil.ensureVarName(string);
        if (string2 != "" && (symbol = Symbol.intern(string2)) != null) {
            return new VariableDeclaration((ItemVar)symbol);
        }
        return null;
    }

    private static void removeVarStart(JTextComponent jTextComponent, int n) {
        String string = jTextComponent.getText();
        String string2 = string.substring(0, n);
        if (n + 1 <= string.length()) {
            string2 = string2 + string.substring(n + 1, string.length());
        }
        jTextComponent.setText(string2);
    }
}

