/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.tree;

import ix.icore.domain.event.DomainEvent;
import ix.iface.ui.tree.EditableTreeModel;
import ix.iface.ui.tree.IXTreeNode;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.util.Debug;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class DomainTreeModel
extends EditableTreeModel
implements UIDomainListener {
    UIDomain uiDomain;

    public DomainTreeModel(UIDomain uIDomain, IXTreeNode iXTreeNode) {
        super(iXTreeNode);
        this.uiDomain = uIDomain;
        this.uiDomain.addUIDomainListener(this);
    }

    public DomainTreeModel(UIDomain uIDomain, IXTreeNode iXTreeNode, HashSet hashSet, HashMap hashMap) {
        super(iXTreeNode, hashSet, hashMap);
        this.uiDomain = uIDomain;
        this.uiDomain.addUIDomainListener(this);
    }

    public IXTreeNode newTreeChild(IXTreeNode iXTreeNode) {
        IXTreeNode iXTreeNode2 = super.newTreeChild(iXTreeNode);
        this.uiDomain.addConstruct((UIObject)iXTreeNode2.getUserObject());
        return iXTreeNode2;
    }

    public UIDomain getUIDomain() {
        return this.uiDomain;
    }

    public void constructAdded(DomainEvent domainEvent) {
        Debug.noteln("DomTreeM: construct added to domain - nothing done");
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        if (this.isOwnUserObject(uIDomainEvent.getObject())) {
            this.userNodeAdded(uIDomainEvent.getObject(), uIDomainEvent);
        }
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        if (this.isOwnUserObject(uIDomainEvent.getObject())) {
            this.userNodeChanged(uIDomainEvent);
        }
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        if (this.isOwnUserObject(uIDomainEvent.getObject())) {
            this.userNodeRemoved(uIDomainEvent.getObject());
        }
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.reloadData();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.reloadData();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.reloadData();
    }

    public abstract IXTreeNode newIXTreeNode(Object var1);

    public abstract List findUserObjects();

    public abstract Object makeUserObject(String var1);

    public abstract Object makeUserObject(String var1, List var2);

    public abstract List getUserChildren(Object var1);

    public abstract void addUserChild(Object var1, Object var2);

    public abstract void removeUserChild(Object var1, Object var2);
}

