/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iface.ui.IXButPanel;
import ix.iface.ui.ListEditorPanel;
import ix.iview.AConstructFramePanel;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class PanelSearcher
extends JDialog
implements ActionListener {
    protected JTextField patternField = new JTextField();
    protected ListEditorPanel searchResults;
    protected JButton searchBut = new JButton("Search");
    protected JButton goToBut = new JButton("Edit Selection");
    protected JButton closeBut = new JButton("Close");
    protected JComboBox searchField;
    protected AConstructFramePanel constructPanel;

    public PanelSearcher(AConstructFramePanel aConstructFramePanel, ListCellRenderer listCellRenderer) {
        this(aConstructFramePanel);
        this.searchResults.setRenderer(listCellRenderer);
    }

    public PanelSearcher(AConstructFramePanel aConstructFramePanel) {
        super(aConstructFramePanel.parent, "Search", false);
        this.constructPanel = aConstructFramePanel;
        String string = aConstructFramePanel.getName();
        this.searchResults = new ListEditorPanel((EventListener)this, "Results", new JList());
        this.patternField.addActionListener(this);
        this.searchBut.addActionListener(this);
        Object[] objectArray = new Object[]{this.goToBut, this.closeBut};
        IXButPanel iXButPanel = new IXButPanel(this, 0, objectArray);
        this.setSize(405, 175);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBounds(0, 0, 500, 300);
        this.getContentPane().add(jPanel);
        int n = 0;
        JLabel jLabel = new JLabel("Search names");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 4, 0, 0), 0, 0);
        jPanel.add((Component)this.searchBut, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 4, 0, 0), 0, 0);
        jPanel.add((Component)this.patternField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 0, 3, 1.0, 2.0, 17, 1, new Insets(0, 4, 0, 0), 0, 0);
        jPanel.add((Component)this.searchResults, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n += 3, 0, 1, 1.0, 0.0, 15, 2, new Insets(0, 4, 0, 0), 0, 0);
        jPanel.add((Component)iXButPanel, gridBagConstraints);
        this.patternField.requestFocus();
        this.invalidate();
        this.pack();
    }

    public PanelSearcher(AConstructFramePanel aConstructFramePanel, List list) {
        this(aConstructFramePanel);
    }

    public boolean hasResults() {
        if (this.searchResults == null) {
            return false;
        }
        Object object = this.searchResults.getData();
        if (object == null) {
            return false;
        }
        if (object instanceof Object[]) {
            int n = ((Object[])object).length;
            return n > 0;
        }
        Debug.noteln("PS:Got odd list data class", object.getClass());
        return false;
    }

    protected void search() {
        this.searchBut.setText("Cancel");
        String string = this.patternField.getText();
        if (string == "") {
            this.stopSearch();
        } else {
            Set set = this.doSearch(string);
            this.finishSearch(set);
        }
    }

    private Set doSearch(String string) {
        List list = this.constructPanel.getAllConstructs();
        Set set = IVUtil.findNameMatches(string, list);
        return set;
    }

    private void finishSearch(Set set) {
        this.searchResults.setData(set);
        this.stopSearch();
    }

    protected void stopSearch() {
        this.searchBut.setText("Search");
    }

    public void close() {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.closeBut) {
            this.close();
            return;
        }
        if (actionEvent.getSource() == this.goToBut && (object = this.searchResults.getSelectedObject()) == null) {
            JOptionPane.showMessageDialog(null, "No result selected - nothing done");
        }
        if (actionEvent.getSource() == this.patternField || actionEvent.getSource() == this.searchBut) {
            this.search();
        }
    }
}

