/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.VariableDeclaration;
import ix.iface.ui.JConstraintEditor;
import ix.iface.ui.JConstraintListener;
import ix.iview.VarSpecifier;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.UISpec;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;

public abstract class ConstraintEditor
extends JConstraintEditor
implements VarSpecifier {
    protected List varDecs = new ArrayList();
    private String field = "";

    public ConstraintEditor(Frame frame, String string, String string2, Object object) {
        super(frame, string, string2, object);
    }

    public ConstraintEditor(Frame frame, String string, String string2) {
        super(frame, string, string2);
    }

    public ConstraintEditor(Frame frame, String string) {
        super(frame, string);
    }

    public void start() {
        if (this.varDecs == null) {
            this.varDecs = new ArrayList();
        } else {
            this.varDecs.clear();
        }
        super.start();
    }

    public List getVarsToOffer() {
        try {
            UIRefinement uIRefinement = (UIRefinement)this.currentObject;
            return uIRefinement.getVariableDeclarations();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String addVariableDeclaration(String string) {
        VariableDeclaration variableDeclaration = IVUtil.makeVariableDeclaration(string);
        if (variableDeclaration != null) {
            this.varDecs.add(variableDeclaration);
            return variableDeclaration.getName().toString();
        }
        return "";
    }

    protected boolean processConstraint() {
        Object object = this.collectConstraint();
        if (object == null) {
            return false;
        }
        this.handleVariables();
        Object object2 = this.noteNewValue(object);
        if (this.constraintListeners == null) {
            return true;
        }
        for (int i = 0; i < this.constraintListeners.size(); ++i) {
            JConstraintListener jConstraintListener = (JConstraintListener)this.constraintListeners.get(i);
            jConstraintListener.gotConstraint(this, this.currentObject, object2);
        }
        return true;
    }

    protected void handleVariables() {
        if (this.varDecs != null && this.varDecs.size() > 0) {
            try {
                UIRefinement uIRefinement = (UIRefinement)this.currentObject;
                ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
                List list = uIRefinement.getVariableDeclarations();
                if (list != null) {
                    arrayList.addAll(list);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                for (VariableDeclaration variableDeclaration : this.varDecs) {
                    arrayList.add(variableDeclaration);
                }
                uIRefinement.setVariableDeclarations(arrayList);
                this.varDecs.clear();
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
    }

    protected String getField(Object object) {
        return this.field;
    }

    protected List getPreviousList(Object object) {
        if (object instanceof Ordering) {
            this.field = "orderings";
            return new ArrayList(((UIRefinement)this.currentObject).getOrderings());
        }
        if (object instanceof Constraint) {
            this.field = "constraints";
            return new ArrayList(((UIRefinement)this.currentObject).getConstraints());
        }
        if (object instanceof UISpec) {
            this.field = "issues";
            return new ArrayList(((UIRefinement)this.currentObject).getIssues());
        }
        if (object instanceof Issue) {
            this.field = "issues";
            return new ArrayList(((UIRefinement)this.currentObject).getIssues());
        }
        if (object instanceof NodeSpec) {
            this.field = "nodes";
            return new ArrayList(((UIRefinement)this.currentObject).getNodes());
        }
        this.field = "";
        return null;
    }

    protected Component makeBits() {
        return this.makeRels();
    }

    protected abstract Component makeRels();

    protected abstract void initFromObject();

    protected abstract void setFromObject(Object var1);

    protected abstract Object collectConstraint();
}

