/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.Activity;
import ix.isim.SimulationException;
import ix.util.Duration;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.text.ParseException;
import java.util.Iterator;

public class TimedEvent {
    public static final int WAITING = 0;
    public static final int EXECUTING = 1;
    public static final int COMPLETED = 2;
    public static final int FAILED = 3;
    public static final String[] statusString = new String[]{"WAITING", "EXECUTING", "COMPLETED", "FAILED"};
    private static final Symbol atTimeSy = Symbol.intern("at-time");
    protected long timeInMillis;
    protected Activity event;
    protected String thread = null;
    protected int status = 0;

    private TimedEvent(long l, Activity activity) throws SimulationException {
        this.timeInMillis = l;
        this.event = activity;
        if (!activity.isGround()) {
            throw new SimulationException("Timed event action must be ground.");
        }
    }

    public long getRelativeTime() {
        return this.timeInMillis;
    }

    protected void setRelativeTime(long l) {
        this.timeInMillis = l;
    }

    public Activity getActivity() {
        return this.event;
    }

    protected void setThread(String string) {
        this.thread = string;
    }

    public String getThread() {
        return this.thread;
    }

    protected void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public String toString() {
        return "(" + atTimeSy + " " + new Duration(this.timeInMillis).toISOString() + " " + this.event.toString() + ")";
    }

    public static TimedEvent getTimedEvent(LList lList) throws ParseException {
        Iterator iterator = lList.iterator();
        if (!iterator.next().equals(atTimeSy)) {
            throw new ParseException("Timed event spec must start with \"" + atTimeSy + "\"!", 0);
        }
        Duration duration = new Duration(iterator.next().toString());
        Activity activity = new Activity((LList)iterator.next());
        if (iterator.hasNext()) {
            throw new ParseException("Too many elements in TimedEvent.", 0);
        }
        try {
            return new TimedEvent(duration.asMilliseconds(), activity);
        }
        catch (SimulationException simulationException) {
            throw new ParseException(simulationException.getMessage(), 0);
        }
    }
}

