/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.isim.ISimTimer;
import ix.isim.ISimTimerException;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;

public class ISimTimerClient
extends ISimTimer {
    private String ISIM_AGENT_NAME;

    protected ISimTimerClient(IXAgent iXAgent) {
        super(iXAgent);
        if (!Parameters.haveParameter("isim-agent-name")) {
            Debug.noteln("Cannot create ISimTimerClient. Parameter \"isim-agent-name\" undefined.");
        } else {
            this.ISIM_AGENT_NAME = Parameters.getParameter("isim-agent-name");
            this.register();
        }
    }

    private void register() {
        Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "register", this.owner.getAgentSymbolName()));
        IPC.sendObject(this.ISIM_AGENT_NAME, activity);
    }

    public void handleSynchronizeActivity(Activity activity) {
        Symbol symbol = (Symbol)activity.getVerb();
        Debug.expectSame(this.SYNCHRONIZE_LABEL, symbol);
        LList lList = activity.getParameters();
        String string = (String)lList.get(0);
        if (string.equalsIgnoreCase("start")) {
            this.handleStartActivity(lList);
        } else if (string.equalsIgnoreCase("pause")) {
            this.handlePauseActivity(lList);
        } else if (string.equalsIgnoreCase("resume")) {
            this.handleResumeActivity(lList);
        } else if (string.equalsIgnoreCase("accelerate")) {
            this.handleAccelerateActivity(lList);
        } else if (string.equalsIgnoreCase("stop")) {
            this.handleStopActivity(lList);
        } else {
            Debug.noteln("Unrecognised synchronization activity: " + string + ". Ignoring.");
        }
    }

    private void handleStartActivity(LList lList) {
        String string = (String)lList.get(1);
        String string2 = (String)lList.get(2);
        try {
            super.start(Long.parseLong(string), Double.parseDouble(string2));
        }
        catch (ISimTimerException iSimTimerException) {
            Debug.noteln(iSimTimerException.getMessage());
        }
    }

    private void handlePauseActivity(LList lList) {
        String string = (String)lList.get(1);
        this.setCurrentSimTime(Long.parseLong(string));
        super.pause();
    }

    private void handleResumeActivity(LList lList) {
        String string = (String)lList.get(1);
        this.setCurrentSimTime(Long.parseLong(string));
        super.resume();
    }

    private void handleAccelerateActivity(LList lList) {
        String string = (String)lList.get(1);
        super.changeAccelerationFactor(Double.parseDouble(string));
    }

    private void handleStopActivity(LList lList) {
        super.terminateTimer();
    }
}

