/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.icore.IXAgent;
import ix.iface.util.ToolController;
import ix.iserve.ipc.IServeCommunicationStrategy;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import ix.util.Util;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IServeCommunicationTool {
    IServeCommunicationStrategy strategy;
    ToolFrame frame;

    public IServeCommunicationTool(IServeCommunicationStrategy iServeCommunicationStrategy) {
        this.strategy = iServeCommunicationStrategy;
        iServeCommunicationStrategy.setTool(this);
        this.frame = new ToolFrame(iServeCommunicationStrategy.agent.getAgentDisplayName() + " I-Serve Communications");
        this.transcript("Communications base URL: " + iServeCommunicationStrategy.getMessageUrl());
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    void register() {
        this.frame.registerButton.setEnabled(false);
        while (!this.strategy.isAbleToSend()) {
            String string = IXAgent.getAgent().getAgentSymbolName();
            String string2 = this.showInputDialog(this.frame, "Enter the agent name", string);
            if (string2 == null) {
                this.frame.registerButton.setEnabled(true);
                return;
            }
            try {
                this.strategy.registerAs(string2);
            }
            catch (Exception exception) {
                Debug.displayException(exception);
            }
        }
        Debug.expect(this.strategy.isAbleToSend());
    }

    String showInputDialog(Component component, Object object, Object object2) {
        return (String)JOptionPane.showInputDialog(component, object, "Question", 3, null, null, object2);
    }

    void needToReregister() {
        Util.displayAndWait(this.frame, new String[]{"This agent is unable to connect to the server needed", "for applet communications, probably because the server", "has exited.  You will need to re-register when a server", "is again available.  Some messages may have been lost."});
        this.frame.registerButton.setEnabled(true);
    }

    void transcript(String string) {
        this.frame.appendLine(string);
    }

    public static class Controller
    extends ToolController {
        IServeCommunicationStrategy strategy;

        public Controller(IServeCommunicationStrategy iServeCommunicationStrategy) {
            super("I-Serve Communications");
            this.strategy = iServeCommunicationStrategy;
        }

        protected Object createTool() {
            return new IServeCommunicationTool(this.strategy);
        }
    }

    protected class ToolFrame
    extends TextAreaFrame {
        JButton registerButton;

        ToolFrame(String string) {
            super(0, 0, string, new String[0]);
            this.setEditable(false);
            this.addListener(new ToolTListener());
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 200);
            this.frame.validate();
        }

        protected TextAreaFrame.TFrame makeTFrame(String string, String[] stringArray) {
            return new ToolTFrame(string, stringArray);
        }

        class ToolTListener
        implements TextAreaFrame.TListener {
            ToolTListener() {
            }

            public void buttonPressed(String string) {
                if (string.equals("Register")) {
                    IServeCommunicationTool.this.register();
                } else {
                    Debug.noteln("ToolTListener ignores", (Object)string);
                }
            }
        }

        class ToolTFrame
        extends TextAreaFrame.TFrame {
            ToolTFrame(String string, String[] stringArray) {
                super(string, stringArray);
                this.contentPane.add((Component)this.makeButtonPanel(), "South");
            }

            protected JPanel makeButtonPanel() {
                JPanel jPanel = new JPanel();
                ToolFrame.this.registerButton = this.makeButton("Register");
                jPanel.add(ToolFrame.this.registerButton);
                return jPanel;
            }
        }
    }
}

