/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.ip2.Ip2;
import ix.iplan.IPlanOptionManager;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.PlanStats;
import ix.iplan.event.AbstractOptionListener;
import ix.iplan.event.OptionEvent;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import ix.util.Util;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class IPlanTool {
    Ip2 ip2;
    PlanStats stats;
    ToolFrame frame;
    private SimFrame simFrame = null;

    public IPlanTool(Ip2 ip2) {
        this.ip2 = ip2;
        this.frame = new ToolFrame(ip2.getAgentDisplayName() + " I-Plan Tool");
        ip2.addResetHook(new ResetHook());
        ip2.getOptionManager().addOptionListener(new OptListener());
        this.frame.noteCurrentOption(ip2.getOptionManager().getOption());
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public ToolFrame getFrame() {
        return this.frame;
    }

    void checkPlan() {
        this.checkPlan(new PlanCheckingSimulator(this.ip2));
    }

    void checkPlan(PlanCheckingSimulator planCheckingSimulator) {
        this.ensureSimFrame();
        this.simFrame.setText("");
        this.simFrame.setVisible(true);
        TraceStream traceStream = new TraceStream(this.simFrame);
        planCheckingSimulator.setTraceOutput(traceStream);
        planCheckingSimulator.run();
        traceStream.println("");
        planCheckingSimulator.report();
        traceStream.println("");
        planCheckingSimulator.describeChangedWorldState();
    }

    private void ensureSimFrame() {
        if (this.simFrame == null) {
            String string = this.ip2.getAgentDisplayName() + " Plan Check";
            this.simFrame = new SimFrame(string);
        }
    }

    SimFrame getSimFrame() {
        return this.simFrame;
    }

    class ToolFrame
    extends TextAreaFrame {
        JButton planButton;
        JButton replanButton;
        TitledBorder border;

        ToolFrame(String string) {
            super(0, 0, string, new String[0]);
            this.setEditable(false);
            this.addListener(new ToolTListener());
            this.border = BorderFactory.createTitledBorder("Plan");
            this.setBorder(this.border);
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 300);
            this.frame.validate();
        }

        void setBorderTitle(String string) {
            this.border = BorderFactory.createTitledBorder(string);
            this.setBorder(this.border);
        }

        void reset() {
            this.setText("");
            this.planButton.setEnabled(true);
            this.replanButton.setEnabled(false);
            this.border.setTitle("Plan");
        }

        void noteCurrentOption(IPlanOptionManager.Opt opt) {
            Debug.noteln("IPlanTool notices", (Object)opt);
            this.setBorderTitle(opt.getName());
            this.setText("");
            this.replanButton.setEnabled(opt.allowsReplan());
        }

        void planStats(PlanStats planStats) {
            planStats.report(new TraceStream(this));
        }

        protected TextAreaFrame.TFrame makeTFrame(String string, String[] stringArray) {
            Debug.expect(stringArray.length == 0);
            return new PlanFrame(string, stringArray);
        }

        class ToolTListener
        implements TextAreaFrame.TListener {
            ToolTListener() {
            }

            public void buttonPressed(String string) {
                IPlanOptionManager iPlanOptionManager = IPlanTool.this.ip2.getOptionManager();
                if (string.equals("Plan")) {
                    if (!ToolFrame.this.replanButton.isEnabled() || this.planIsIntended()) {
                        ToolFrame.this.setText("");
                        iPlanOptionManager.plan();
                        ToolFrame.this.planStats(iPlanOptionManager.getStats());
                    }
                } else if (string.equals("Replan")) {
                    ToolFrame.this.setText("");
                    iPlanOptionManager.replan();
                    ToolFrame.this.planStats(iPlanOptionManager.getStats());
                } else if (string.equals("Check Plan")) {
                    IPlanTool.this.checkPlan();
                }
            }

            private boolean planIsIntended() {
                return Util.dialogConfirms(ToolFrame.this.frame, "Are you sure you want to plan instead of replan?");
            }
        }

        class PlanFrame
        extends TextAreaFrame.TFrame {
            PlanFrame(String string, String[] stringArray) {
                super(ToolFrame.this, string, stringArray);
                this.contentPane.add((Component)this.makeButtonPanel(), "South");
            }

            protected JPanel makeButtonPanel() {
                JPanel jPanel = new JPanel();
                ToolFrame.this.planButton = this.makeButton("Plan");
                jPanel.add(ToolFrame.this.planButton);
                ToolFrame.this.replanButton = this.makeButton("Replan");
                jPanel.add(ToolFrame.this.replanButton);
                jPanel.add(this.makeButton("Check Plan"));
                ToolFrame.this.replanButton.setEnabled(false);
                return jPanel;
            }
        }
    }

    private class RefusingOutputStream
    extends OutputStream {
        private RefusingOutputStream() {
        }

        public void write(int n) throws IOException {
            throw new UnsupportedOperationException("Attempt to write to a RefusingOutputStream");
        }
    }

    private class TraceStream
    extends PrintStream {
        TextAreaFrame textFrame;

        TraceStream(TextAreaFrame textAreaFrame) {
            super(new RefusingOutputStream());
            this.textFrame = textAreaFrame;
        }

        public void println(String string) {
            this.textFrame.appendLine(string);
        }
    }

    static class SimFrame
    extends TextAreaFrame {
        SimFrame(String string) {
            super(0, 0, string, new String[]{"Cancel"});
            this.setEditable(false);
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 300);
            this.frame.validate();
        }
    }

    class OptListener
    extends AbstractOptionListener {
        OptListener() {
        }

        public void optionSet(OptionEvent optionEvent) {
            IPlanTool.this.frame.noteCurrentOption(optionEvent.getOption());
        }

        public void optionRenamed(OptionEvent optionEvent, String string) {
            if (optionEvent.getOption() == IPlanTool.this.ip2.getOptionManager().getOption()) {
                IPlanTool.this.frame.noteCurrentOption(optionEvent.getOption());
            }
        }

        public void optionContentsChanged(OptionEvent optionEvent, EventObject eventObject) {
            if (optionEvent.getOption() == IPlanTool.this.ip2.getOptionManager().getOption()) {
                IPlanTool.this.frame.noteCurrentOption(optionEvent.getOption());
            }
        }
    }

    protected class ResetHook
    implements Runnable {
        protected ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", (Object)IPlanTool.this);
            IPlanTool.this.frame.reset();
        }
    }
}

