/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Status;
import ix.icore.domain.End;
import ix.icore.process.PNodeEnd;
import ix.ip2.ActivityItem;
import ix.iplan.Slip;
import ix.util.context.Context;

public abstract class Alternative
implements Slip.Step {
    protected Context context = Context.getContext();
    protected double cost = 0.0;

    public Context getContext() {
        return this.context;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(Slip slip) {
        this.cost = this.calcCost(slip);
    }

    protected double calcCost(Slip slip) {
        return slip.MM().getNodes().size();
    }

    private double fancy_calcCost(Slip slip) {
        double d = 0.0;
        for (PNodeEnd pNodeEnd : slip.MM().getNodeEnds()) {
            if (pNodeEnd.getEnd() == End.END) continue;
            ActivityItem activityItem = (ActivityItem)pNodeEnd.getNode();
            Status status = slip.getStatus(pNodeEnd);
            if (status != Status.BLANK && status != Status.POSSIBLE) {
                d += 0.0;
                continue;
            }
            if (pNodeEnd.getNode().isExpanded()) {
                d += 0.0;
                continue;
            }
            if (slip.isGoalNode(pNodeEnd)) {
                d += 1.0;
                continue;
            }
            d += (double)(1L + slip.analysis.getMinFullExpandSize(activityItem.getPattern()));
        }
        return d;
    }

    public boolean isLocalChoice() {
        return false;
    }

    public void whenPicked() {
    }

    public String toString() {
        return this.getClass().getName() + "[" + "in " + this.context + " cost " + this.cost + this.extraToStringContents() + "]";
    }

    protected String extraToStringContents() {
        return "";
    }
}

