/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.process.PNodeEnd;
import ix.ip2.Ip2;
import ix.util.Debug;
import ix.util.Duration;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineViewer {
    Ip2 ip2;
    TimelineFrame frame;

    public TimelineViewer(Ip2 ip2) {
        this.ip2 = ip2;
        this.frame = new TimelineFrame(ip2);
        ip2.addResetHook(new ResetHook());
        this.frame.addListener(new TimelineFrameListener());
        this.frame.reload();
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    protected String makeTimelineText() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("Timeline using earliest start times");
        linkedList.add("");
        long l = 0L;
        for (PNodeEnd pNodeEnd : this.getSortedEnds()) {
            long l2 = pNodeEnd.getMinTime();
            if (l2 != l) {
                l = l2;
                linkedList.add(new Duration(l).toString());
            }
            linkedList.add("   " + pNodeEnd);
        }
        return Strings.joinLines(linkedList);
    }

    List<PNodeEnd> getSortedEnds() {
        this.ip2.getIp2ModelManager().getTPNManager().describeTPN(Debug.out);
        List<PNodeEnd> list = this.ip2.getIp2ModelManager().getNodeEnds();
        Collections.sort(list, new Comparator<PNodeEnd>(){

            @Override
            public int compare(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
                return Long.signum(pNodeEnd.getMinTime() - pNodeEnd2.getMinTime());
            }
        });
        return list;
    }

    private class TimelineFrameListener
    implements TextAreaFrame.TListener {
        TimelineFrameListener() {
        }

        public void buttonPressed(String string) {
            if (string.equals("Reload")) {
                TimelineViewer.this.frame.reload();
            }
        }
    }

    protected class TimelineFrame
    extends TextAreaFrame {
        public TimelineFrame(Ip2 ip2) {
            this(ip2.getAgentDisplayName() + " Timeline");
        }

        public TimelineFrame(String string) {
            super(0, 0, string, new String[]{"Reload", "Cancel"});
            this.setEditable(false);
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 300);
            this.frame.validate();
        }

        public void reload() {
            this.setText(TimelineViewer.this.makeTimelineText());
        }

        public void setText(String string) {
            Debug.noteln("Timeline text", (Object)string);
            super.setText(string);
            this.setCaretPosition(0);
        }
    }

    protected class ResetHook
    implements Runnable {
        protected ResetHook() {
        }

        public void run() {
            Debug.noteln("Resetting", (Object)TimelineViewer.this);
        }
    }
}

