/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Status;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.ItemHandler;
import ix.ispace.AgentData;
import ix.ispace.AgentRelationship;
import ix.ispace.ContactManager;
import ix.ispace.VerbCapability;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ForwardingHandler
extends ItemHandler
implements ContactListener {
    protected IXAgent agent;
    protected String action;
    protected AgentRelationship rel;
    protected boolean reportBack;
    protected boolean capabilityDefault = true;
    protected ContactManager contactManager;

    public ForwardingHandler(IXAgent iXAgent, String string, AgentRelationship agentRelationship, boolean bl) {
        super(string + " to " + agentRelationship + " agents");
        this.agent = iXAgent;
        this.action = string;
        this.rel = agentRelationship;
        this.reportBack = bl;
        this.contactManager = iXAgent.getContactManager();
        this.contactManager.addContactListener(this);
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        List list = this.getToNames(agendaItem);
        Debug.noteln(this + " adding actions for agents " + list);
        for (String string : list) {
            agendaItem.addAction(this.makeForwardingAction(string, agendaItem));
        }
    }

    public ForwardingAction makeForwardingAction(String string, AgendaItem agendaItem) {
        return new ForwardingAction(string, agendaItem);
    }

    protected List getToNames(AgendaItem agendaItem) {
        return (List)Collect.map(new LinkedList(), this.getToAgents(agendaItem), Fn.accessor(AgentData.class, "getName"));
    }

    public List getToAgents(AgendaItem agendaItem) {
        VerbCapability verbCapability = VerbCapability.from(agendaItem.getPattern());
        List list = this.contactManager.getAgentData(this.rel);
        List list2 = this.contactManager.getAgentData(verbCapability, this.capabilityDefault);
        Debug.noteln("Agents with " + this.rel, (Object)list);
        Debug.noteln("Agents with " + verbCapability, (Object)list2);
        if (list == null || list2 == null) {
            return Collections.EMPTY_LIST;
        }
        return (List)Collect.intersection(list, list2);
    }

    public void handle(AgendaItem agendaItem) {
        throw new Error(this + " called directly");
    }

    public void contactChange(ContactEvent contactEvent) {
        AgentData agentData;
        AgentRelationship agentRelationship;
        ((Ip2)this.agent).getController().checkActionValidity(this, contactEvent);
        if ((contactEvent.isNewContact() || contactEvent.isRelationshipChange() || contactEvent.isCapabilityChange()) && (agentRelationship = (agentData = contactEvent.getNewData()).getRelationship()) == this.rel) {
            Debug.noteln("Possible new forwarding target", (Object)agentData);
            ((Ip2)this.agent).getController().reconsiderHandler(this, contactEvent);
        }
    }

    public void reviseHandlerActions(AgendaItem agendaItem, Object object) {
        String string;
        ForwardingAction forwardingAction;
        ContactEvent contactEvent = (ContactEvent)object;
        AgentData agentData = contactEvent.getNewData();
        Debug.expect(agentData.getRelationship() == this.rel);
        if (agentData.hasCapability(VerbCapability.from(agendaItem.getPattern()), this.capabilityDefault) && agendaItem.findAction((forwardingAction = this.makeForwardingAction(string = agentData.getName(), agendaItem)).getActionDescription()) == null) {
            agendaItem.insertAction(forwardingAction);
        }
    }

    public String toString() {
        return "ForwardingHandler[" + this.getActionDescription() + "]";
    }

    class ForwardingAction
    extends HandlerAction {
        String toName;
        AgendaItem item;
        VerbCapability requiredCapability;

        ForwardingAction(String string, AgendaItem agendaItem) {
            this.toName = string;
            this.shortDescription = ForwardingHandler.this.action + " to " + string;
            this.item = agendaItem;
            this.requiredCapability = VerbCapability.from(agendaItem.getPattern());
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            agendaItem.getAbout().forwardTo(this.toName, ForwardingHandler.this.reportBack);
            agendaItem.setStatus(ForwardingHandler.this.reportBack ? Status.EXECUTING : Status.COMPLETE);
        }

        public boolean isStillValid() {
            AgentData agentData = ForwardingHandler.this.contactManager.getAgentData(this.toName);
            return agentData != null && agentData.getRelationship() == ForwardingHandler.this.rel && agentData.hasCapability(this.requiredCapability, ForwardingHandler.this.capabilityDefault);
        }
    }
}

