/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Variable;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.ToolFrame;
import ix.ip2.Ip2;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class BindingViewer
implements ActionListener {
    protected Ip2 ip2;
    protected Set vars;
    protected Map possibleValues;
    protected JFrame frame;
    protected Container contentPane;
    protected VarPanel varPanel;

    public BindingViewer(Ip2 ip2, Set set) {
        this.ip2 = ip2;
        this.vars = set;
        this.possibleValues = this.getPossibleValues(set);
        this.setUpFrame();
    }

    public Set getVars() {
        return this.vars;
    }

    protected void setUpFrame() {
        this.frame = new ToolFrame(this.ip2.getAgentDisplayName() + " Variable Binder");
        this.contentPane = this.frame.getContentPane();
        this.varPanel = new VarPanel(this.vars);
        this.contentPane.add((Component)this.varPanel, "Center");
        this.contentPane.add((Component)this.makeButtonPanel(), "South");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    protected ButtonPanel makeButtonPanel() {
        return new ButtonPanel("Bind", "Finished");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("BindingViewer action:", (Object)string);
        if (string.equals("Bind")) {
            this.bindCommand();
        } else if (string.equals("Finished")) {
            this.closeCommand();
        } else {
            throw new ConsistencyException("Nothing to do for", string);
        }
    }

    protected void bindCommand() {
        this.handleBindings(this.varPanel.getBindings());
        this.resetPossibleValues();
    }

    protected void closeCommand() {
        this.frame.setVisible(false);
    }

    public abstract void handleBindings(Map var1);

    protected Map getPossibleValues(Set set) {
        return this.ip2.getIp2ModelManager().getVariableManager().getPossibleValues(set);
    }

    protected void resetPossibleValues() {
        this.resetPossibleValues(this.getPossibleValues(this.vars));
    }

    protected void resetPossibleValues(Map map) {
        this.possibleValues = map;
        this.varPanel.resetPossibles(map);
        this.frame.validate();
    }

    protected void reloadView(Set set) {
        this.vars = set;
        this.possibleValues = this.getPossibleValues(set);
        this.varPanel.reloadTable();
        this.frame.validate();
    }

    static class Value {
        Object v;

        Value(Object object) {
            this.v = object;
        }

        Object get() {
            return this.v;
        }

        public String toString() {
            return Lisp.printToString(this.v);
        }
    }

    class ValComboBox
    extends JComboBox {
        public ValComboBox(Variable variable) {
            if (variable.isBound()) {
                Value value = new Value(variable.getValue());
                this.addItem(value);
                this.setSelectedItem(value);
                this.setEnabled(false);
                return;
            }
            this.addItem(" ");
            Set set = (Set)BindingViewer.this.possibleValues.get(variable);
            for (Object e : set) {
                this.addItem(new Value(e));
            }
            this.setSelectedItem(" ");
        }
    }

    class VarPanel
    extends JPanel {
        GridColumn varColumn = new GridColumn("Variable");
        GridColumn valColumn = new GridColumn("Value");
        Map varFields = new HashMap();
        List varList;

        VarPanel(Set set) {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.add(this.varColumn);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.valColumn);
            this.loadTable();
        }

        void loadTable() {
            this.varList = new LinkedList(BindingViewer.this.vars);
            Collections.sort(this.varList);
            for (Variable variable : this.varList) {
                JTextField jTextField = new JTextField(variable.getName().toString());
                jTextField.setEditable(false);
                this.varColumn.add(jTextField);
                JComponent jComponent = this.makeValField(variable);
                this.varFields.put(variable, jComponent);
                this.valColumn.add(jComponent);
            }
        }

        void reloadTable() {
            this.varColumn.reset();
            this.valColumn.reset();
            this.loadTable();
            this.invalidate();
        }

        JComponent makeValField(Variable variable) {
            Set set = variable.isBound() ? Collections.singleton(variable.getValue()) : (Set)BindingViewer.this.possibleValues.get(variable);
            return set == null ? new JTextField(20) : new ValComboBox(variable);
        }

        void resetPossibles(Map map) {
            for (Variable variable : map.keySet()) {
                JComponent jComponent = (JComponent)this.varFields.get(variable);
                JComponent jComponent2 = this.makeValField(variable);
                this.valColumn.replace(jComponent, jComponent2);
                this.varFields.put(variable, jComponent2);
            }
        }

        Map getBindings() {
            HashMap<Variable, Object> hashMap = new HashMap<Variable, Object>();
            for (Variable variable : this.varList) {
                JComponent jComponent = (JComponent)this.varFields.get(variable);
                Object object = null;
                if (jComponent.isEnabled()) {
                    Object object2;
                    JComponent jComponent2;
                    if (jComponent instanceof JTextField) {
                        jComponent2 = (JTextField)jComponent;
                        object2 = ((JTextComponent)jComponent2).getText();
                        if (!((String)(object2 = ((String)object2).trim())).equals("")) {
                            object = Lisp.readFromString((String)object2);
                            jComponent2.setEnabled(false);
                        }
                    } else {
                        jComponent2 = (ValComboBox)jComponent;
                        object2 = ((JComboBox)jComponent2).getSelectedItem();
                        if (object2 instanceof Value) {
                            object = ((Value)object2).get();
                            ((JComboBox)jComponent2).setEnabled(false);
                        }
                    }
                }
                if (object == null) continue;
                hashMap.put(variable, object);
            }
            return hashMap;
        }
    }

    class ButtonPanel
    extends JPanel {
        ButtonPanel(String ... stringArray) {
            for (String string : stringArray) {
                this.add(this.makeButton(string));
            }
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(BindingViewer.this));
            return jButton;
        }
    }
}

