/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgent;
import ix.icore.Status;
import ix.icore.domain.ListOfNodeSpec;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaViewer;
import ix.ip2.Ip2;
import ix.ip2.ItemEditor;
import ix.ip2.event.AgendaItemEvent;
import ix.iview.SimpleDomainEditor;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Null;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ActivityEditor
extends ItemEditor {
    protected JMenuItem saveAsRefinementItem;

    ActivityEditor(AgendaViewer agendaViewer, String string) {
        super(agendaViewer, string);
        this.itemType = "Activity";
    }

    protected ItemEditor.EditPanel makeEditPanel() {
        return new ActivityEditPanel();
    }

    protected JMenuBar makeMenuBar() {
        this.saveAsRefinementItem = this.makeMenuItem("Save As Refinement");
        this.saveAsRefinementItem.setEnabled(false);
        this.fileMenu.add(this.saveAsRefinementItem);
        this.fileMenu.addSeparator();
        return super.makeMenuBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("ActivityEditor action:", (Object)string);
        if (string.equals("Save As Refinement")) {
            Refinement refinement = ((ActivityEditPanel)this.editPanel).expansionPanel.makePartialRefinement();
            this.agendaViewer.saveExpansion(refinement);
        } else if (!this.handleViewCommand(actionEvent)) {
            if (string.equals("Close")) {
                this.frame.setVisible(false);
            } else {
                Debug.noteln("Nothing to do for", (Object)string);
            }
        }
    }

    class ActivityEditPanel
    extends ItemEditor.EditPanel {
        JButton expansionButton;
        ExpansionPanel expansionPanel;
        SyntaxComboBox syntaxChoice;

        ActivityEditPanel() {
            super(ActivityEditor.this);
            this.expansionPanel = new ExpansionPanel();
            this.modifyButton = this.makeButton("Modify Activity");
            this.expansionButton = this.makeButton("Specify Subactivities");
            this.expansionButton.setForeground(Color.blue);
            this.syntaxChoice = new SyntaxComboBox();
            this.setUp();
        }

        protected void setUp() {
            this.setBorder(BorderFactory.createTitledBorder("Activity"));
            this.syntaxChoice.addActionListener(new SyntaxChoiceListener());
            this.add(this.makeLeftLabel("Activity Pattern"));
            this.add(this.syntaxChoice);
            this.add(new JScrollPane(this.itemText));
            this.add(this.makeLeftLabel("Annotations"));
            this.add(new JScrollPane(this.commentText));
            this.newItemButtons.add(this.makeButton("Add Activity"));
            this.newItemButtons.add(this.makeButton("Clear"));
            this.newItemButtons.add(this.makeButton("Cancel"));
            this.editItemButtons.add(this.modifyButton);
            this.editItemButtons.add(this.makeButton("Copy Activity"));
            this.editItemButtons.add(this.expansionButton);
            this.editItemButtons.add(this.makeButton("Clear"));
            this.editItemButtons.add(this.makeButton("Cancel"));
            this.add(this.newItemButtons);
        }

        void showItem(AgendaItem agendaItem) {
            this.ensureNoExpansionPanel();
            this.syntaxChoice.off();
            Status status = agendaItem.getStatus();
            this.expansionButton.setEnabled(status == Status.BLANK || status == Status.POSSIBLE);
            super.showItem(agendaItem);
        }

        void showNewItem() {
            this.ensureNoExpansionPanel();
            this.syntaxChoice.on();
            super.showNewItem();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Activity action:", (Object)string);
            if (string.equals("Add Activity")) {
                this.addItem();
            } else if (string.equals("Modify Activity")) {
                this.modifyItem();
            } else if (string.equals("Copy Activity")) {
                this.copyItem();
            } else if (string.equals("Specify Subactivities")) {
                this.addExpansionPanel();
            } else if (string.equals("Install Subactivities")) {
                this.addSubitems();
            } else {
                if (string.equals("Modify Subactivities")) {
                    throw new ConsistencyException("Modify Subactivities button should be disabled");
                }
                if (string.equals("Clear")) {
                    this.showNewItem();
                } else if (string.equals("Cancel")) {
                    ActivityEditor.this.frame.setVisible(false);
                    this.showNewItem();
                } else {
                    throw new UnsupportedOperationException("Nothing to do for " + string);
                }
            }
        }

        AgendaItem getItem() {
            AgendaItem agendaItem = super.getItem();
            if (agendaItem == null || this.hasValidSyntax(agendaItem.getPattern()) || Util.dialogConfirms(ActivityEditor.this.frame, new String[]{"The pattern doesn't match the selected syntax", "Do you still want to add the activity?"})) {
                return agendaItem;
            }
            return null;
        }

        boolean hasValidSyntax(LList lList) {
            String string = (String)this.syntaxChoice.getSelectedItem();
            if (string.equals("")) {
                return true;
            }
            LListCollector lListCollector = new LListCollector(lList);
            List<String> list = Strings.breakAt(" ", string);
            Debug.noteln("Words", list);
            for (String string2 : list) {
                if (string2.equals("")) {
                    return true;
                }
                if (Character.isLetterOrDigit(string2.charAt(0))) {
                    if (!lListCollector.isEmpty() && string2.equals(lListCollector.popElement().toString())) continue;
                    return false;
                }
                if (string2.startsWith("?")) {
                    if (lListCollector.isEmpty()) {
                        return false;
                    }
                    lListCollector.popElement();
                    continue;
                }
                if (string2.equals("...")) {
                    return lListCollector.size() >= 0;
                }
                if (string2.equals("&rest")) {
                    return true;
                }
                return true;
            }
            return lListCollector.isEmpty();
        }

        void copyItem() {
            this.ensureNoExpansionPanel();
            this.syntaxChoice.on();
            super.copyItem();
        }

        void addSubitems() {
            Refinement refinement = this.expansionPanel.makePartialRefinement();
            ActivityEditor.this.agendaViewer.expandItem(this.editingItem, refinement);
            this.expansionPanel.setControlsEnabled(false);
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            if (agendaItem != this.editingItem) {
                return;
            }
            Debug.noteln("Status change while editing item", (Object)agendaItem);
            Status status = agendaItem.getStatus();
            if (status != Status.BLANK && status != Status.POSSIBLE) {
                this.expansionButton.setEnabled(false);
            }
        }

        String[] getSyntaxes() {
            Ip2 ip2 = (Ip2)IXAgent.getAgent();
            SortedSet sortedSet = ip2.getActivityPatternSyntaxes();
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("");
            for (LList lList : sortedSet) {
                linkedList.add(PatternParser.unparse(lList));
            }
            return Strings.toArray(linkedList);
        }

        void addExpansionPanel() {
            Debug.expect(!this.expansionPanelIsShown());
            Debug.expect(this.editingItem != null, "can't edit new item subitems");
            this.expansionPanel.loadFromItem(this.editingItem);
            ActivityEditor.this.saveAsRefinementItem.setEnabled(true);
            if (this.editingItem.getChildren().isEmpty()) {
                this.expansionButton.setText("Install Subactivities");
                Status status = this.editingItem.getStatus();
                if (status == Status.BLANK || status == Status.POSSIBLE) {
                    this.expansionButton.setEnabled(true);
                    this.expansionPanel.setControlsEnabled(true);
                } else {
                    this.expansionButton.setEnabled(false);
                    this.expansionPanel.setControlsEnabled(false);
                }
            } else {
                this.expansionButton.setText("Modify Subactivities");
                this.expansionButton.setEnabled(false);
                this.expansionPanel.setControlsEnabled(false);
            }
            this.add((Component)this.expansionPanel, this.getComponentCount() - 3);
            ActivityEditor.this.frame.pack();
        }

        void ensureNoExpansionPanel() {
            if (this.expansionPanelIsShown()) {
                ActivityEditor.this.saveAsRefinementItem.setEnabled(false);
                this.expansionButton.setText("Specify Subactivities");
                this.expansionButton.setEnabled(true);
                this.remove(this.expansionPanel);
                ActivityEditor.this.frame.pack();
            }
        }

        boolean expansionPanelIsShown() {
            return this.getComponent(this.getComponentCount() - 4) == this.expansionPanel;
        }

        class ExpansionPanel
        extends JPanel {
            JTextArea subitemText;
            SimpleDomainEditor.TemporalConstraintPanel constraintPanel;

            ExpansionPanel() {
                this.subitemText = new JTextArea(5, ActivityEditPanel.this.textCols);
                this.constraintPanel = new SimpleDomainEditor.TemporalConstraintPanel();
                this.setLayout(new BoxLayout(this, 1));
                this.setUp();
            }

            void setUp() {
                JLabel jLabel = new JLabel("Subactivities");
                jLabel.setForeground(Color.blue);
                this.add(ActivityEditPanel.this.makeLeftLabel(jLabel));
                this.add(new JScrollPane(this.subitemText));
                this.subitemText.setForeground(Color.blue);
                this.add(ActivityEditPanel.this.makeLeftLabel("Constraints"));
                this.add(this.constraintPanel);
            }

            void setControlsEnabled(boolean bl) {
                this.subitemText.setEnabled(bl);
            }

            Refinement makePartialRefinement() {
                Null nullVal = Lisp.NIL;
                String string = this.subitemText.getText().trim();
                ListOfNodeSpec listOfNodeSpec = SimpleDomainEditor.parseNodes(string);
                if (listOfNodeSpec.isEmpty()) {
                    throw new IllegalArgumentException("There are no subactivities");
                }
                String string2 = this.constraintPanel.getOrderingChoice();
                ListOfOrdering listOfOrdering = string2.equals("Sequential") ? SimpleDomainEditor.sequentialOrderings(listOfNodeSpec) : null;
                Refinement refinement = new Refinement();
                refinement.setPattern(nullVal);
                refinement.setNodes(listOfNodeSpec);
                refinement.setOrderings(listOfOrdering);
                refinement.setComments(ActivityEditPanel.this.commentText.getText());
                return refinement;
            }

            void loadFromItem(AgendaItem agendaItem) {
                Debug.noteln("Editing orderings of", (Object)agendaItem);
                List<PNode> list = agendaItem.getChildren();
                List list2 = this.itemOrderings(agendaItem);
                Debug.noteln("Orderings = ", (Object)list2);
                this.subitemText.setText(this.subitemsToText(list));
                this.constraintPanel.loadFromOrderings(list, list2);
            }

            String subitemsToText(List list) {
                String string = System.getProperty("line.separator");
                StringBuffer stringBuffer = new StringBuffer();
                for (AgendaItem agendaItem : list) {
                    stringBuffer.append(PatternParser.unparse(agendaItem.getPattern()));
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }

            List itemOrderings(AgendaItem agendaItem) {
                return Lisp.NIL;
            }
        }

        class SyntaxChoiceListener
        implements ActionListener {
            SyntaxChoiceListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxComboBox syntaxComboBox = (SyntaxComboBox)actionEvent.getSource();
                String string = (String)syntaxComboBox.getSelectedItem();
                if (string != null) {
                    Debug.noteln("Selected syntax:", (Object)string);
                    ActivityEditPanel.this.itemText.setText(this.constantPart(string));
                }
            }

            String constantPart(String string) {
                List<String> list = Strings.breakAt(" ", string);
                String string2 = "";
                for (String string3 : list) {
                    if (!Character.isLetterOrDigit(string3.charAt(0))) continue;
                    string2 = string2 + string3 + " ";
                }
                return string2;
            }
        }

        class SyntaxComboBox
        extends JComboBox {
            SyntaxComboBox() {
                super(ActivityEditPanel.this.getSyntaxes());
            }

            void off() {
                this.setSelectedItem("");
                this.setEnabled(false);
            }

            void on() {
                this.setModel(new DefaultComboBoxModel<String>(ActivityEditPanel.this.getSyntaxes()));
                this.setEnabled(true);
            }
        }
    }
}

