/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.util;

import ix.iface.util.CatchingActionListener;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.ObjectComparator;
import ix.util.lisp.Lisp;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class KeyValueTable {
    protected Map viewedMap = new HashMap();
    protected List keyList = new LinkedList();
    protected Map keyTimestamps = new HashMap();
    protected int timestamp = 0;
    protected Comparator keySortComparator = new MostRecentLastComparator();
    protected ViewJTable table;
    protected ViewTableModel model;
    protected ViewTableMouseListener mouseListener;

    public KeyValueTable(String string, String string2) {
        this(null, string, string2);
    }

    public KeyValueTable(Map map, String string, String string2) {
        this.model = new ViewTableModel(string, string2);
        this.table = new ViewJTable(this.model);
        if (map != null) {
            this.recordNewValues(map);
        }
        this.mouseListener = new ViewTableMouseListener();
        this.table.addMouseListener(this.mouseListener);
    }

    public JTable getJTable() {
        return this.table;
    }

    public Object getValue(Object object) {
        return this.viewedMap.get(object);
    }

    public Map getViewedMap() {
        return Collections.unmodifiableMap(this.viewedMap);
    }

    protected String keyToString(Object object) {
        return Lisp.printToString(object);
    }

    protected String valueToString(Object object) {
        return Lisp.printToString(object);
    }

    public Comparator getKeySortComparator() {
        return this.keySortComparator;
    }

    public void setKeySortComparator(Comparator comparator) {
        this.keySortComparator = comparator;
        Collections.sort(this.keyList, this.keySortComparator);
        this.model.fireTableDataChanged();
    }

    public void reset() {
        this.viewedMap.clear();
        this.keyList.clear();
        this.keyTimestamps.clear();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.table.invalidate();
    }

    public void recordNewValues(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.recordNewValue(entry.getKey(), entry.getValue());
        }
    }

    public void recordNewValue(Object object, Object object2) {
        int n = this.keyList.indexOf(object);
        if (n == -1) {
            this.viewedMap.put(object, object2);
            int n2 = this.insertKey(object);
            this.model.fireTableRowsInserted(n2, n2);
        } else {
            this.viewedMap.put(object, object2);
            this.model.fireTableCellUpdated(n, this.model.VAL_COL);
        }
    }

    protected int insertKey(Object object) {
        Debug.expect(!this.keyList.contains(object), "Old key", object);
        this.timestampKey(object);
        int n = 0;
        ListIterator<Object> listIterator = this.keyList.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (this.keySortComparator.compare(object, e) < 0) {
                listIterator.previous();
                listIterator.add(object);
                Debug.expect(this.keyList.indexOf(object) == n);
                return n;
            }
            ++n;
        }
        Debug.expect(n == this.keyList.size());
        this.keyList.add(object);
        return n;
    }

    protected void timestampKey(Object object) {
        Debug.expect(!this.keyTimestamps.containsKey(object), "Old key", object);
        this.keyTimestamps.put(object, new Integer(this.timestamp++));
    }

    protected int keyTimestamp(Object object) {
        Integer n = (Integer)this.keyTimestamps.get(object);
        Debug.expect(n != null, "No timestamp for key", object);
        return n;
    }

    public void deleteEntry(Object object, Object object2) {
        Object object3 = this.getValue(object);
        Debug.expect(object3 != null, "No value for key", object);
        if (!object3.equals(object2)) {
            throw new IllegalArgumentException("Wrong value when deleting key " + object + ":" + " found " + object3 + " but expected " + object2);
        }
        this.deleteEntry(object);
    }

    public void deleteEntry(Object object) {
        int n = this.keyList.indexOf(object);
        Debug.expect(n >= 0, "Can't find key to delete", object);
        this.keyList.remove(object);
        this.keyTimestamps.remove(object);
        this.viewedMap.remove(object);
        this.model.fireTableRowsDeleted(n, n);
    }

    protected abstract RowPopupMenu makePopupMenu();

    protected abstract void doPopupAction(ActionEvent var1, int var2, Object var3);

    protected abstract class RowPopupMenu
    extends JPopupMenu
    implements ActionListener {
        protected int row = -1;

        protected JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            return jMenuItem;
        }

        public void setRow(int n) {
            this.row = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Row popup command", (Object)string);
            Debug.expect(this.row >= 0, "bad row", new Integer(this.row));
            Object e = KeyValueTable.this.keyList.get(this.row);
            Debug.expect(e != null, "no key for row", new Integer(this.row));
            KeyValueTable.this.doPopupAction(actionEvent, this.row, e);
        }
    }

    protected class ViewTableMouseListener
    extends MouseAdapter {
        RowPopupMenu popup;

        public ViewTableMouseListener() {
            this.popup = KeyValueTable.this.makePopupMenu();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.popup != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n = KeyValueTable.this.table.rowAtPoint(mouseEvent.getPoint());
                Debug.noteln("Table right press in row", n);
                this.popup.setRow(n);
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = KeyValueTable.this.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = KeyValueTable.this.table.columnAtPoint(mouseEvent.getPoint());
            }
        }
    }

    protected class ViewTableModel
    extends AbstractTableModel {
        final int KEY_COL = 0;
        final int VAL_COL = 1;
        final String[] columnName;

        public ViewTableModel(String string, String string2) {
            this.columnName = new String[]{string, string2};
        }

        public String getColumnName(int n) {
            return this.columnName[n];
        }

        public int getColumnCount() {
            return this.columnName.length;
        }

        public int getRowCount() {
            return KeyValueTable.this.keyList.size();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return KeyValueTable.this.keyToString(KeyValueTable.this.keyList.get(n));
                }
                case 1: {
                    return KeyValueTable.this.valueToString(KeyValueTable.this.viewedMap.get(KeyValueTable.this.keyList.get(n)));
                }
            }
            throw new ConsistencyException("Bogus column " + n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            Debug.noteln("Asked to set table value to", object);
        }
    }

    protected class ViewJTable
    extends JTable {
        public ViewJTable(TableModel tableModel) {
            super(tableModel);
            this.getTableHeader().setReorderingAllowed(false);
            this.setCellSelectionEnabled(false);
            this.makeCellsMouseable();
            this.setPreferredColumnWidths();
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
        }

        private void makeCellsMouseable() {
            JTextField jTextField = new JTextField();
            jTextField.setEditable(false);
            jTextField.setBackground(Color.white);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
            this.setDefaultEditor(Object.class, defaultCellEditor);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        KeyValueTable.this.mouseListener.mousePressed(new MouseEvent(KeyValueTable.this.table, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getComponent().getX() + mouseEvent.getX(), mouseEvent.getComponent().getY() + mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    }
                }
            };
            jTextField.addMouseListener(mouseAdapter);
        }

        protected void setPreferredColumnWidths() {
            this.getColumnModel().getColumn(KeyValueTable.this.model.KEY_COL).setPreferredWidth(200);
            this.getColumnModel().getColumn(KeyValueTable.this.model.VAL_COL).setPreferredWidth(200);
        }
    }

    public static class PatternObjectComparator
    extends ObjectComparator {
        protected int compareLists(List list, List list2) {
            Object e;
            int n = list.size();
            int n2 = list2.size();
            if (n < 2) {
                if (n2 < 2) {
                    return super.compareLists(list, list2);
                }
                return -1;
            }
            if (n2 < 2) {
                return 1;
            }
            Object e2 = list.get(1);
            int n3 = this.compare(e2, e = list2.get(1));
            if (n3 != 0) {
                return n3;
            }
            return super.compareLists(list, list2);
        }
    }

    public static class LexicographicComparator
    extends ObjectComparator {
    }

    public class MostRecentFirstComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return -(KeyValueTable.this.keyTimestamp(object) - KeyValueTable.this.keyTimestamp(object2));
        }
    }

    public class MostRecentLastComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return KeyValueTable.this.keyTimestamp(object) - KeyValueTable.this.keyTimestamp(object2);
        }
    }
}

