/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.AbstractIXObject;
import ix.icore.Issue;
import ix.icore.LinkedListOfIssue;
import ix.icore.ListOfIssue;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.LinkedListOfNodeSpec;
import ix.icore.domain.LinkedListOfObjectProperty;
import ix.icore.domain.LinkedListOfOrdering;
import ix.icore.domain.LinkedListOfVariableDeclaration;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ListOfNodeSpec;
import ix.icore.domain.ListOfObjectProperty;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.ListOfVariableDeclaration;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.TimeWindow;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.DomainParser;
import ix.iface.domain.LTF_Symbols;
import ix.iface.domain.SyntaxException;
import ix.util.Debug;
import ix.util.Duration;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.StableHashMap;
import ix.util.Strings;
import ix.util.Util;
import ix.util.WithCleanup;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.LinkedListOfSymbol;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispFileReader;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispReader;
import ix.util.lisp.ListOfSymbol;
import ix.util.lisp.Symbol;
import ix.util.match.MatchCase;
import ix.util.match.MatchEnv;
import ix.util.match.MatchTable;
import ix.util.match.SimpleMatcher;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LTF_Parser
extends DomainParser
implements LTF_Symbols {
    protected String sourceName;
    protected LispReader lin;
    protected Object lastRead = "Start of file";
    protected boolean forceNumericNodeIds = Parameters.getBoolean("force-numeric-node-ids", false);
    protected boolean badAnnotationsAreErrors = false;
    protected Set badAnnotations;
    protected Set otherConstraints;
    protected MatchTable parsers = new MatchTable();
    private LList annotationSyntax = (LList)Lisp.readFromString("(?key = ?value)");

    public LTF_Parser(String string) throws FileNotFoundException {
        this.sourceName = string;
        this.lin = new LispFileReader(string);
        this.addConstraintParsers();
    }

    public LTF_Parser(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public LTF_Parser(URL uRL) throws IOException {
        this.sourceName = uRL.toString();
        Reader reader = Util.openURLReader(uRL);
        this.lin = new LispReader(new BufferedReader(reader));
        this.addConstraintParsers();
    }

    public LTF_Parser() {
        this.addConstraintParsers();
    }

    public Domain readDomain() {
        return this.readDomain(new Domain());
    }

    public Domain readDomain(final Domain domain) {
        Util.run(new WithCleanup(){

            public void body() {
                LTF_Parser.this.do_readDomain(domain);
            }

            public void cleanup() throws IOException {
                LTF_Parser.this.lin.close();
            }
        });
        return domain;
    }

    protected void do_readDomain(Domain domain) {
        Debug.noteln("Reading definitions from", (Object)this.sourceName);
        this.badAnnotations = new TreeSet();
        this.otherConstraints = new TreeSet();
        try {
            Object object;
            while ((object = this.lin.readObject()) != Lisp.EOF) {
                AbstractIXObject abstractIXObject;
                if (!(object instanceof Cons)) {
                    throw this.syntaxError("Found " + object + " when expecting a definition");
                }
                LList lList = LTF_Parser.theLList(object);
                this.lastRead = object;
                Symbol symbol = (Symbol)lList.elementAt(0);
                if (symbol == S_DOMAIN) {
                    this.processDomainHeader(domain, lList);
                    continue;
                }
                if (symbol == S_REFINEMENT) {
                    abstractIXObject = this.makeRefinement(lList);
                    domain.addRefinement((Refinement)abstractIXObject);
                    continue;
                }
                if (symbol == S_OBJECT_CLASS) {
                    abstractIXObject = this.makeObjectClass(lList);
                    domain.addObjectClass((ObjectClass)abstractIXObject);
                    continue;
                }
                if (symbol == S_ANNOTATIONS) {
                    domain.takeAnnotations(this.makeAnnotations(lList));
                    continue;
                }
                if (symbol == S_INCLUDE) {
                    this.doInclude((Cons)object);
                    continue;
                }
                throw this.syntaxError("Illegal definition type " + symbol);
            }
            if (!this.otherConstraints.isEmpty()) {
                Debug.warn("Constraints of unfamiliar types: " + this.otherConstraints);
            }
            if (!this.badAnnotations.isEmpty()) {
                Debug.warn("Some annotations were not (key = value); the keys were: " + Strings.conjunction(this.badAnnotations));
            }
        }
        catch (SyntaxException syntaxException) {
            Debug.noteln("Rethrowing syntax exception.");
            throw syntaxException;
        }
        catch (LispReadException lispReadException) {
            Debug.noteException(lispReadException, false);
            throw this.syntaxError(Debug.describeException(lispReadException));
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw this.syntaxError(Debug.describeException(exception));
        }
    }

    protected SyntaxException syntaxError(String string) {
        return new SyntaxException(string + (this.lin instanceof IncludeReader ? " while parsing included " + Util.quote(this.sourceName) : "") + " in or after " + this.lastRead);
    }

    protected static Cons theCons(Object object) {
        return Util.mustBe(Cons.class, object);
    }

    protected static LList theLList(Object object) {
        return Util.mustBe(LList.class, object);
    }

    protected static Symbol theSymbol(Object object) {
        return Util.mustBe(Symbol.class, object);
    }

    protected static String theString(Object object) {
        return Util.mustBe(String.class, object);
    }

    protected static String theName(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return LTF_Parser.theSymbol(object).toString();
    }

    protected static Name theNodeId(Object object) {
        if (object instanceof Number || object instanceof Symbol || object instanceof String) {
            return Name.valueOf(object);
        }
        throw new ClassCastException("Attempt to use " + Util.aClass(object.getClass()) + " " + object + " as a node-id.");
    }

    protected static NodeEndRef theNodeEndRef(Name name, End end) {
        String string = name.toString();
        if (string.startsWith("b/")) {
            return new NodeEndRef(End.BEGIN, LTF_Parser.theNodeId(string.substring(2)));
        }
        if (string.startsWith("e/")) {
            return new NodeEndRef(End.END, LTF_Parser.theNodeId(string.substring(2)));
        }
        return new NodeEndRef(end, name);
    }

    void processDomainHeader(Domain domain, LList lList) {
        Debug.expectSame(S_DOMAIN, lList.get(0));
        LList lList2 = lList.cdr();
        while (!lList2.isEmpty()) {
            LList lList3 = LTF_Parser.theLList(lList2.car());
            Symbol symbol = LTF_Parser.theSymbol(lList3.car());
            if (symbol != S_NAME) {
                throw this.syntaxError("Invalid domain header clause " + lList3);
            }
            String string = LTF_Parser.theString(lList3.get(1));
            domain.setName(string);
            lList2 = lList2.cdr();
        }
    }

    public Refinement makeRefinement(LList lList) {
        Debug.expectSame(S_REFINEMENT, lList.get(0));
        Refinement refinement = new Refinement();
        refinement.setName(LTF_Parser.theName(lList.get(1)));
        refinement.setPattern(LTF_Parser.theLList(lList.get(2)));
        LList lList2 = lList.drop(3);
        while (!lList2.isEmpty()) {
            Cons cons = LTF_Parser.theCons(lList2.car());
            Symbol symbol = LTF_Parser.theSymbol(cons.car());
            LList lList3 = cons.cdr();
            if (symbol == S_VARIABLES) {
                refinement.setVariableDeclarations(this.makeVarDcls(lList3));
            } else if (symbol == S_NODES) {
                refinement.setNodes(this.makeNodes(lList3));
            } else if (symbol == S_ORDERINGS) {
                refinement.setOrderings(this.makeOrderings(lList3));
            } else if (symbol == S_CONSTRAINTS) {
                refinement.setConstraints(this.makeConstraints(lList3));
            } else if (symbol == S_ISSUES) {
                refinement.setIssues(this.makeIssues(lList3));
            } else if (symbol == S_ANNOTATIONS) {
                refinement.takeAnnotations(this.makeAnnotations(cons));
            } else {
                throw this.syntaxError("Invalid clause " + cons);
            }
            lList2 = lList2.cdr();
        }
        return this.forceNumericNodeIds ? this.useNumericNodeIds(refinement) : refinement;
    }

    public ListOfVariableDeclaration makeVarDcls(LList lList) {
        LinkedListOfVariableDeclaration linkedListOfVariableDeclaration = new LinkedListOfVariableDeclaration();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            ItemVar itemVar = Util.mustBe(ItemVar.class, iterator.next());
            linkedListOfVariableDeclaration.add(new VariableDeclaration(itemVar));
        }
        return linkedListOfVariableDeclaration;
    }

    public ListOfNodeSpec makeNodes(LList lList) {
        LinkedListOfNodeSpec linkedListOfNodeSpec = new LinkedListOfNodeSpec();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            Cons cons = LTF_Parser.theCons(iterator.next());
            Name name = Name.valueOf(cons.get(0));
            LList lList2 = LTF_Parser.theLList(cons.get(1));
            linkedListOfNodeSpec.add(new NodeSpec(name, lList2));
        }
        return linkedListOfNodeSpec;
    }

    public ListOfOrdering makeOrderings(LList lList) {
        LinkedListOfOrdering linkedListOfOrdering = new LinkedListOfOrdering();
        LList lList2 = LTF_Parser.expandAllOrderings(lList);
        while (!lList2.isEmpty()) {
            Cons cons = LTF_Parser.theCons(lList2.car());
            Name name = LTF_Parser.theNodeId(cons.get(0));
            Name name2 = LTF_Parser.theNodeId(cons.get(1));
            linkedListOfOrdering.add(new Ordering(LTF_Parser.theNodeEndRef(name, End.END), LTF_Parser.theNodeEndRef(name2, End.BEGIN)));
            lList2 = lList2.cdr();
        }
        return linkedListOfOrdering;
    }

    public ListOfConstraint makeConstraints(LList lList) {
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        for (Object e : lList) {
            Constraint constraint = (Constraint)this.parsers.match(e);
            if (constraint == null) {
                throw this.syntaxError("Invalid constraint " + e);
            }
            linkedListOfConstraint.add(constraint);
        }
        return linkedListOfConstraint;
    }

    public ListOfIssue makeIssues(LList lList) {
        LinkedListOfIssue linkedListOfIssue = new LinkedListOfIssue();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            LList lList2 = LTF_Parser.theLList(iterator.next());
            if (lList2.get(0) != S_ISSUE) {
                throw this.syntaxError("Invalid issue syntax in " + lList2);
            }
            LList lList3 = LTF_Parser.theLList(lList2.get(1));
            linkedListOfIssue.add(new Issue(lList3));
        }
        return linkedListOfIssue;
    }

    Refinement useNumericNodeIds(Refinement refinement) {
        if (refinement.getNodes() != null) {
            Map map = this.makeNumericIdMap(refinement.getNodes());
            LinkedListOfNodeSpec linkedListOfNodeSpec = new LinkedListOfNodeSpec();
            for (Object object : refinement.getNodes()) {
                Serializable serializable = (Name)map.get(((NodeSpec)object).getId());
                Debug.expect(serializable != null);
                linkedListOfNodeSpec.add(new NodeSpec((Name)serializable, ((NodeSpec)object).getPattern()));
            }
            refinement.setNodes(linkedListOfNodeSpec);
            if (refinement.getOrderings() != null) {
                LinkedListOfOrdering linkedListOfOrdering = new LinkedListOfOrdering();
                for (Serializable serializable : refinement.getOrderings()) {
                    NodeEndRef nodeEndRef = ((Ordering)serializable).getFrom();
                    NodeEndRef nodeEndRef2 = ((Ordering)serializable).getTo();
                    Name name = (Name)map.get(nodeEndRef.getNode());
                    Name name2 = (Name)map.get(nodeEndRef2.getNode());
                    Debug.expect(name != null, "no node", name);
                    Debug.expect(name2 != null, "no node", name2);
                    linkedListOfOrdering.add(new Ordering(new NodeEndRef(nodeEndRef.getEnd(), name), new NodeEndRef(nodeEndRef2.getEnd(), name2)));
                }
                refinement.setOrderings(linkedListOfOrdering);
            }
        }
        return refinement;
    }

    Map makeNumericIdMap(ListOfNodeSpec listOfNodeSpec) {
        HashMap<Name, Name> hashMap = new HashMap<Name, Name>();
        int n = 1;
        for (NodeSpec nodeSpec : listOfNodeSpec) {
            hashMap.put(nodeSpec.getId(), Name.valueOf(new Long(n++)));
        }
        return hashMap;
    }

    public static LList expandAllOrderings(LList lList) {
        LListCollector lListCollector = new LListCollector();
        for (LList lList2 = lList; lList2 != Lisp.NIL; lList2 = lList2.cdr()) {
            lListCollector.concLList(LTF_Parser.expandOrdering(LTF_Parser.theLList(lList2.car())));
        }
        return lListCollector.contents();
    }

    public static LList expandOrdering(LList lList) {
        LListCollector lListCollector = new LListCollector();
        for (LList lList2 = lList; lList2 != Lisp.NIL; lList2 = lList2.cdr()) {
            Object object = lList2.car();
            Object object2 = lList2.cdr().car();
            lListCollector.concLList(LTF_Parser.expandOrderPair(object, object2));
        }
        return lListCollector.contents();
    }

    static LList expandOrderPair(Object object, Object object2) {
        LListCollector lListCollector = new LListCollector();
        for (LList lList = LTF_Parser.ensureList(object); lList != Lisp.NIL; lList = lList.cdr()) {
            for (LList lList2 = LTF_Parser.ensureList(object2); lList2 != Lisp.NIL; lList2 = lList2.cdr()) {
                Object object3 = lList.car();
                Object object4 = lList2.car();
                lListCollector.addElement(Lisp.list(object3, object4));
            }
        }
        return lListCollector.contents();
    }

    static LList ensureList(Object object) {
        return object instanceof LList ? (LList)object : Lisp.list(object);
    }

    public Constraint parseConstraint(Object object) {
        return (Constraint)this.parsers.match(object);
    }

    public MatchTable getConstraintParsers() {
        return this.parsers;
    }

    protected void addConstraintParsers() {
        this.parsers.addCase(new ConstraintParser("(world-state condition ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = LTF_Parser.theLList(matchEnv.get(LTF_Symbols.Q_PATTERN));
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(new PatternAssignment(lList2, v)));
            }

            public Constraint makeTemplate() {
                return new Constraint("world-state", "conditiion", (List)Lisp.list(new PatternAssignment()));
            }
        });
        this.parsers.addCase(new ConstraintParser("(world-state effect ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = LTF_Parser.theLList(matchEnv.get(LTF_Symbols.Q_PATTERN));
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(new PatternAssignment(lList2, v)));
            }

            public Constraint makeTemplate() {
                return new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment()));
            }
        });
        this.parsers.addCase(new ConstraintParser("(compute ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = LTF_Parser.theLList(matchEnv.get(LTF_Symbols.Q_PATTERN));
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), null, (List)Lisp.list(new PatternAssignment(lList2, v)));
            }

            public Constraint makeTemplate() {
                return new Constraint(Symbol.intern("compute"), null, (List)Lisp.list(new PatternAssignment()));
            }
        });
        this.parsers.addCase(new ConstraintParser("(compute multiple-answer ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = LTF_Parser.theLList(matchEnv.get(LTF_Symbols.Q_PATTERN));
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(new PatternAssignment(lList2, v)));
            }

            public Constraint makeTemplate() {
                return new Constraint("compute", "multiple-answer", (List)Lisp.list(new PatternAssignment()));
            }
        });
        this.parsers.addCase(new ConstraintParser("(temporal duration self = ?min .. ?max)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                String string = matchEnv.get(LTF_Symbols.Q_MIN).toString();
                String string2 = matchEnv.get(LTF_Symbols.Q_MAX).toString();
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(Name.valueOf("self"), new TimeWindow(new Duration(string), new Duration(string2))));
            }

            public Constraint makeTemplate() {
                return new Constraint("temporal", "duration", (List)Lisp.list(Name.class, new TimeWindow()));
            }
        });
        this.parsers.addCase(new ConstraintParser("(resource ?operation ?pattern = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = LTF_Parser.theLList(matchEnv.get(LTF_Symbols.Q_PATTERN));
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(new PatternAssignment(lList2, v)));
            }

            public Constraint makeTemplate() {
                return new Constraint("resource", "?operation", (List)Lisp.list(new PatternAssignment()));
            }
        });
        this.parsers.addCase(new ConstraintParser("(advice expansion-refinement ?verb ?names)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                return new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(LTF_Parser.theSymbol(lList.get(2)), lList.get(3)));
            }

            public Constraint makeTemplate() {
                return new Constraint("advice", "expansion-refinement", (List)Lisp.list(Symbol.class, ListOfSymbol.class));
            }
        });
        this.parsers.addCase(new ConstraintParser("(?type ?subtype (&rest ?pattern) = ?value)"){

            public Constraint makeConstraint(LList lList, MatchEnv matchEnv) {
                LList lList2 = LTF_Parser.theLList(matchEnv.get(LTF_Symbols.Q_PATTERN));
                Object v = matchEnv.get(LTF_Symbols.Q_VALUE);
                Constraint constraint = new Constraint(LTF_Parser.theSymbol(lList.get(0)), LTF_Parser.theSymbol(lList.get(1)), (List)Lisp.list(new PatternAssignment(lList2, v)));
                LTF_Parser.this.otherConstraints.add(constraint);
                return constraint;
            }

            public Constraint makeTemplate() {
                return new Constraint("?type", "?subtype", (List)Lisp.list(new PatternAssignment()));
            }
        });
    }

    ObjectClass makeObjectClass(LList lList) {
        Debug.expectEquals(S_OBJECT_CLASS, lList.get(0));
        ObjectClass objectClass = new ObjectClass();
        objectClass.setName(LTF_Parser.theName(lList.get(1)));
        objectClass.setSuperClassNames(this.makeSuperNames(LTF_Parser.theLList(lList.get(2))));
        objectClass.setObjectProperties(this.makeObjectProperties(lList.drop(3)));
        return objectClass;
    }

    ListOfSymbol makeSuperNames(LList lList) {
        LinkedListOfSymbol linkedListOfSymbol = new LinkedListOfSymbol();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            linkedListOfSymbol.add(LTF_Parser.theSymbol(iterator.next()));
        }
        return linkedListOfSymbol;
    }

    ListOfObjectProperty makeObjectProperties(LList lList) {
        LinkedListOfObjectProperty linkedListOfObjectProperty = new LinkedListOfObjectProperty();
        Iterator iterator = lList.iterator();
        while (iterator.hasNext()) {
            linkedListOfObjectProperty.add(this.makeObjectProperty(LTF_Parser.theLList(iterator.next())));
        }
        return linkedListOfObjectProperty;
    }

    ObjectProperty makeObjectProperty(LList lList) {
        Symbol symbol = LTF_Parser.theSymbol(lList.get(0));
        Symbol symbol2 = null;
        ObjectProperty.Syntax syntax = null;
        switch (lList.length()) {
            case 3: {
                syntax = ObjectProperty.Syntax.valueOf(LTF_Parser.theSymbol(lList.get(2)));
                if (lList.get(1) == K_SYNTAX) break;
                throw this.syntaxError("Expected :syntax in " + lList);
            }
            case 4: {
                syntax = ObjectProperty.Syntax.valueOf(LTF_Parser.theSymbol(lList.get(3)));
                if (lList.get(2) != K_SYNTAX) {
                    throw this.syntaxError("Expected :syntax in " + lList);
                }
                symbol2 = LTF_Parser.theSymbol(lList.get(1));
            }
            case 2: {
                symbol2 = LTF_Parser.theSymbol(lList.get(1));
            }
            case 1: {
                break;
            }
            default: {
                throw this.syntaxError("Invalid object property " + lList);
            }
        }
        return new ObjectProperty(symbol, symbol2, syntax);
    }

    Map makeAnnotations(LList lList) {
        Debug.expect(lList.get(0) == S_ANNOTATIONS);
        return this.makeMap(lList);
    }

    Map makeMap(LList lList) {
        StableHashMap stableHashMap = new StableHashMap();
        Iterator iterator = lList.cdr().iterator();
        while (iterator.hasNext()) {
            LList lList2 = LTF_Parser.theLList(iterator.next());
            if (SimpleMatcher.match(this.annotationSyntax, lList2) == null) {
                this.badAnnotation(lList2);
            }
            Object object = lList2.get(0);
            Object object2 = lList2.get(2);
            if (this.isMapSyntax(object2)) {
                object2 = this.makeMap((LList)object2);
            }
            stableHashMap.put(object, object2);
        }
        return stableHashMap;
    }

    boolean isMapSyntax(Object object) {
        return object instanceof LList && ((LList)object).car() == S_MAP;
    }

    void badAnnotation(LList lList) {
        if (this.badAnnotationsAreErrors) {
            throw this.syntaxError("Annotation " + lList + " does not have the form (key = value).");
        }
        this.badAnnotations.add(lList.get(0).toString());
    }

    void doInclude(LList lList) throws IOException {
        Debug.expectSame(S_INCLUDE, lList.car());
        String string = LTF_Parser.theString(lList.get(1));
        URL uRL = this.defaultedIncludeURL(string);
        Debug.noteln("Will try LTF include from", (Object)uRL);
        Reader reader = Util.openURLReader(uRL);
        IncludeReader includeReader = new IncludeReader(uRL, reader, this.lin);
        includeReader.pushState();
    }

    URL defaultedIncludeURL(String string) throws MalformedURLException {
        String string2 = this.sourceName;
        URL uRL = XML.toURL(string2);
        Debug.noteln("Base URL for LTF include", (Object)uRL);
        if (uRL == null) {
            throw new MalformedURLException("Cannot treat as URL: " + string2);
        }
        return new URL(uRL, string);
    }

    class IncludeReader
    extends LispReader {
        String resourceName;
        LispReader wrappedReader;
        LispReader pushedReader;
        String pushedSourceName;
        Object pushedLastRead;

        IncludeReader(URL uRL, Reader reader, LispReader lispReader) {
            super(reader);
            this.resourceName = uRL.toString();
            this.wrappedReader = lispReader;
        }

        public Object readObject() {
            try {
                Object object = super.readObject();
                if (object != Lisp.EOF) {
                    return object;
                }
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                SyntaxException syntaxException = LTF_Parser.this.syntaxError(Debug.describeException(throwable));
                this.popState();
                throw syntaxException;
            }
            this.popState();
            return this.wrappedReader.readObject();
        }

        void pushState() {
            Debug.noteln("Pushing LTF_Parser state to", (Object)this.resourceName);
            this.pushedSourceName = LTF_Parser.this.sourceName;
            this.pushedLastRead = LTF_Parser.this.lastRead;
            this.pushedReader = LTF_Parser.this.lin;
            LTF_Parser.this.sourceName = this.resourceName;
            LTF_Parser.this.lastRead = "Start of file";
            LTF_Parser.this.lin = this;
        }

        void popState() {
            Debug.noteln("Popping LTF_Parser state back to", (Object)this.pushedSourceName);
            LTF_Parser.this.lin = this.pushedReader;
            LTF_Parser.this.sourceName = this.pushedSourceName;
            LTF_Parser.this.lastRead = this.pushedLastRead;
        }
    }

    public static abstract class ConstraintParser
    extends MatchCase {
        ConstraintParser(String string) {
            this.pattern = Lisp.readFromString(string);
        }

        public Object tryMatch(Object object) {
            MatchEnv matchEnv = SimpleMatcher.match(this.pattern, object);
            return matchEnv;
        }

        public Object ifSelected(Object object, Object object2) {
            return this.makeConstraint((LList)object, (MatchEnv)object2);
        }

        public abstract Constraint makeConstraint(LList var1, MatchEnv var2);

        public abstract Constraint makeTemplate();
    }
}

