/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.util.ConsistencyException;
import ix.util.Duration;
import java.io.Serializable;

public class TimeWindow
implements Serializable {
    protected Duration min;
    protected Duration max;

    public TimeWindow() {
    }

    public TimeWindow(Duration duration, Duration duration2) {
        this.min = duration;
        this.max = duration2;
        if (duration2 != null && duration.compareTo(duration2) > 0) {
            throw new ConsistencyException("Min duration " + duration + " is not <= max duration " + duration2);
        }
    }

    public Duration getMin() {
        return this.min;
    }

    public void setMin(Duration duration) {
        this.min = duration;
    }

    public Duration getMax() {
        return this.max;
    }

    public void setMax(Duration duration) {
        this.max = duration;
    }

    public boolean hasUnboundedMax() {
        return this.max == null;
    }

    public String toString() {
        return "TimeWindow[" + this.getMin().toISOString() + ".." + (this.hasUnboundedMax() ? "inf" : this.getMax().toISOString()) + "]";
    }
}

