/*
 * Decompiled with CFR 0.152.
 */
package ix.applet;

import ix.applet.AppletCommunicationStrategy;
import ix.icore.IXAgent;
import ix.iface.util.ToolController;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import ix.util.Util;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AppletCommunicationTool {
    AppletCommunicationStrategy strategy;
    ToolFrame frame;

    public AppletCommunicationTool(AppletCommunicationStrategy appletCommunicationStrategy) {
        this.strategy = appletCommunicationStrategy;
        appletCommunicationStrategy.setTool(this);
        this.frame = new ToolFrame(appletCommunicationStrategy.agent.getAgentDisplayName() + " Applet Communications");
        this.transcript("Applet base URL: " + appletCommunicationStrategy.getDocumentBase());
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    void register() {
        this.frame.registerButton.setEnabled(false);
        while (!this.strategy.isAbleToSend()) {
            String string;
            String string2 = IXAgent.getAgent().getAgentSymbolName();
            if (string2 == " I-P2 Applet ") {
                string2 = "";
            }
            if ((string = this.showInputDialog(this.frame, "Enter the agent name", string2)) == null) {
                this.frame.registerButton.setEnabled(true);
                return;
            }
            try {
                this.strategy.registerAs(string);
            }
            catch (Exception exception) {
                Debug.displayException(exception);
            }
        }
        Debug.expect(this.strategy.isAbleToSend());
    }

    String showInputDialog(Component component, Object object, Object object2) {
        return (String)JOptionPane.showInputDialog(component, object, "Question", 3, null, null, object2);
    }

    void needToReregister() {
        Util.displayAndWait(this.frame, new String[]{"This agent is unable to connect to the server needed", "for applet communications, probably because the server", "has exited.  You will need to re-register when a server", "is again available.  Some messages may have been lost."});
        this.frame.registerButton.setEnabled(true);
    }

    void transcript(String string) {
        this.frame.appendLine(string);
    }

    public static class Controller
    extends ToolController {
        AppletCommunicationStrategy strategy;

        public Controller(AppletCommunicationStrategy appletCommunicationStrategy) {
            super("Applet Communications");
            this.strategy = appletCommunicationStrategy;
        }

        protected Object createTool() {
            return new AppletCommunicationTool(this.strategy);
        }
    }

    protected class ToolFrame
    extends TextAreaFrame {
        JButton registerButton;

        ToolFrame(String string) {
            super(0, 0, string, new String[0]);
            this.setEditable(false);
            this.addListener(new ToolTListener());
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 200);
            this.frame.validate();
        }

        protected TextAreaFrame.TFrame makeTFrame(String string, String[] stringArray) {
            return new ToolTFrame(string, stringArray);
        }

        class ToolTListener
        implements TextAreaFrame.TListener {
            ToolTListener() {
            }

            public void buttonPressed(String string) {
                if (string.equals("Register")) {
                    AppletCommunicationTool.this.register();
                } else {
                    Debug.noteln("ToolTListener ignores", (Object)string);
                }
            }
        }

        class ToolTFrame
        extends TextAreaFrame.TFrame {
            ToolTFrame(String string, String[] stringArray) {
                super(ToolFrame.this, string, stringArray);
                this.contentPane.add((Component)this.makeButtonPanel(), "South");
            }

            protected JPanel makeButtonPanel() {
                JPanel jPanel = new JPanel();
                ToolFrame.this.registerButton = this.makeButton("Register");
                jPanel.add(ToolFrame.this.registerButton);
                return jPanel;
            }
        }
    }
}

