/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.xml.util;

import edu.stanford.db.xml.util.QName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class Element {
    public static final String EMPTY_STR = "";
    public static final int EMPTY = 0;
    public static final int CDATA = 1;
    public static final int ELEMENTS = 2;
    public static final int MIXED = 3;
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("ElementEnumerator");
        }
    };
    protected int type = 0;
    protected Element parent;
    protected Element child;
    protected QName name;
    protected int numInParent;
    protected String value = "";
    protected Hashtable attrs;

    public String getAttribute(QName qName) {
        if (this.attrs == null) {
            return null;
        }
        return (String)this.attrs.get(qName);
    }

    public Enumeration getAttributes() {
        if (this.attrs == null) {
            return EMPTY_ENUMERATION;
        }
        return this.attrs.keys();
    }

    public QName getName() {
        return this.name;
    }

    public int getNumInParent() {
        return this.numInParent;
    }

    public Element getParent() {
        return this.parent;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setAttribute(QName qName, String string) {
        if (this.attrs == null) {
            this.attrs = new Hashtable();
        }
        this.attrs.put(qName, string);
    }

    public void setChild(Element element) {
        this.child = element;
        this.type |= 2;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public void setNumInParent(int n) {
        this.numInParent = n;
    }

    public void setParent(Element element) {
        this.parent = element;
    }

    public void setValue(String string) {
        this.value = string;
        this.type |= 1;
    }
}

